# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFolderResult',
    'AwaitableGetFolderResult',
    'get_folder',
    'get_folder_output',
]

@pulumi.output_type
class GetFolderResult:
    """
    A collection of values returned by getFolder.
    """
    def __init__(__self__, id=None, org_id=None, parent_folder_uid=None, title=None, uid=None, url=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if parent_folder_uid and not isinstance(parent_folder_uid, str):
            raise TypeError("Expected argument 'parent_folder_uid' to be a str")
        pulumi.set(__self__, "parent_folder_uid", parent_folder_uid)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.str]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="parentFolderUid")
    def parent_folder_uid(self) -> builtins.str:
        """
        The uid of the parent folder. If set, the folder will be nested. If not set, the folder will be created in the root folder. Note: This requires the nestedFolders feature flag to be enabled on your Grafana instance.
        """
        return pulumi.get(self, "parent_folder_uid")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The title of the folder.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        Unique identifier.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The full URL of the folder.
        """
        return pulumi.get(self, "url")


class AwaitableGetFolderResult(GetFolderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFolderResult(
            id=self.id,
            org_id=self.org_id,
            parent_folder_uid=self.parent_folder_uid,
            title=self.title,
            uid=self.uid,
            url=self.url)


def get_folder(org_id: Optional[builtins.str] = None,
               title: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFolderResult:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/manage-dashboards/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.Folder("test",
        title="test-folder",
        uid="test-ds-folder-uid")
    from_title = grafana.oss.get_folder_output(title=test.title)
    ```


    :param builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    :param builtins.str title: The title of the folder.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    __args__['title'] = title
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:oss/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult).value

    return AwaitableGetFolderResult(
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        parent_folder_uid=pulumi.get(__ret__, 'parent_folder_uid'),
        title=pulumi.get(__ret__, 'title'),
        uid=pulumi.get(__ret__, 'uid'),
        url=pulumi.get(__ret__, 'url'))
def get_folder_output(org_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      title: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFolderResult]:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/dashboards/manage-dashboards/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/folder/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.Folder("test",
        title="test-folder",
        uid="test-ds-folder-uid")
    from_title = grafana.oss.get_folder_output(title=test.title)
    ```


    :param builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    :param builtins.str title: The title of the folder.
    """
    __args__ = dict()
    __args__['orgId'] = org_id
    __args__['title'] = title
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:oss/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult)
    return __ret__.apply(lambda __response__: GetFolderResult(
        id=pulumi.get(__response__, 'id'),
        org_id=pulumi.get(__response__, 'org_id'),
        parent_folder_uid=pulumi.get(__response__, 'parent_folder_uid'),
        title=pulumi.get(__response__, 'title'),
        uid=pulumi.get(__response__, 'uid'),
        url=pulumi.get(__response__, 'url')))
