# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProbeResult',
    'AwaitableGetProbeResult',
    'get_probe',
    'get_probe_output',
]

@pulumi.output_type
class GetProbeResult:
    """
    A collection of values returned by getProbe.
    """
    def __init__(__self__, disable_browser_checks=None, disable_scripted_checks=None, id=None, labels=None, latitude=None, longitude=None, name=None, public=None, region=None, tenant_id=None):
        if disable_browser_checks and not isinstance(disable_browser_checks, bool):
            raise TypeError("Expected argument 'disable_browser_checks' to be a bool")
        pulumi.set(__self__, "disable_browser_checks", disable_browser_checks)
        if disable_scripted_checks and not isinstance(disable_scripted_checks, bool):
            raise TypeError("Expected argument 'disable_scripted_checks' to be a bool")
        pulumi.set(__self__, "disable_scripted_checks", disable_scripted_checks)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if latitude and not isinstance(latitude, float):
            raise TypeError("Expected argument 'latitude' to be a float")
        pulumi.set(__self__, "latitude", latitude)
        if longitude and not isinstance(longitude, float):
            raise TypeError("Expected argument 'longitude' to be a float")
        pulumi.set(__self__, "longitude", longitude)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public and not isinstance(public, bool):
            raise TypeError("Expected argument 'public' to be a bool")
        pulumi.set(__self__, "public", public)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tenant_id and not isinstance(tenant_id, int):
            raise TypeError("Expected argument 'tenant_id' to be a int")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="disableBrowserChecks")
    def disable_browser_checks(self) -> builtins.bool:
        """
        Disables browser checks for this probe.
        """
        return pulumi.get(self, "disable_browser_checks")

    @property
    @pulumi.getter(name="disableScriptedChecks")
    def disable_scripted_checks(self) -> builtins.bool:
        """
        Disables scripted checks for this probe.
        """
        return pulumi.get(self, "disable_scripted_checks")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the probe.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        Custom labels to be included with collected metrics and logs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def latitude(self) -> builtins.float:
        """
        Latitude coordinates.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> builtins.float:
        """
        Longitude coordinates.
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the probe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def public(self) -> builtins.bool:
        """
        Public probes are run by Grafana Labs and can be used by all users. Only Grafana Labs managed public probes will be set to `true`.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region of the probe.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.int:
        """
        The tenant ID of the probe.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetProbeResult(GetProbeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProbeResult(
            disable_browser_checks=self.disable_browser_checks,
            disable_scripted_checks=self.disable_scripted_checks,
            id=self.id,
            labels=self.labels,
            latitude=self.latitude,
            longitude=self.longitude,
            name=self.name,
            public=self.public,
            region=self.region,
            tenant_id=self.tenant_id)


def get_probe(name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProbeResult:
    """
    Data source for retrieving a single probe by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    ohio = grafana.syntheticMonitoring.get_probe(name="Ohio")
    ```


    :param builtins.str name: Name of the probe.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:syntheticMonitoring/getProbe:getProbe', __args__, opts=opts, typ=GetProbeResult).value

    return AwaitableGetProbeResult(
        disable_browser_checks=pulumi.get(__ret__, 'disable_browser_checks'),
        disable_scripted_checks=pulumi.get(__ret__, 'disable_scripted_checks'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        latitude=pulumi.get(__ret__, 'latitude'),
        longitude=pulumi.get(__ret__, 'longitude'),
        name=pulumi.get(__ret__, 'name'),
        public=pulumi.get(__ret__, 'public'),
        region=pulumi.get(__ret__, 'region'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_probe_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProbeResult]:
    """
    Data source for retrieving a single probe by name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana

    ohio = grafana.syntheticMonitoring.get_probe(name="Ohio")
    ```


    :param builtins.str name: Name of the probe.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:syntheticMonitoring/getProbe:getProbe', __args__, opts=opts, typ=GetProbeResult)
    return __ret__.apply(lambda __response__: GetProbeResult(
        disable_browser_checks=pulumi.get(__response__, 'disable_browser_checks'),
        disable_scripted_checks=pulumi.get(__response__, 'disable_scripted_checks'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        latitude=pulumi.get(__response__, 'latitude'),
        longitude=pulumi.get(__response__, 'longitude'),
        name=pulumi.get(__response__, 'name'),
        public=pulumi.get(__response__, 'public'),
        region=pulumi.get(__response__, 'region'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
