# Open Source Code of Conduct

## Purpose

This Code of Conduct sets expectations for behavior in our open source community. It ensures a respectful, safe, and inclusive environment for contributors, maintainers, users, and newcomers—regardless of background, skill level, or personal identity.

Open source thrives when everyone can contribute without harassment, discrimination, or toxicity. If you're here to collaborate, you're expected to follow this.

## Expected Behavior

We expect all contributors to:

- **Be respectful**: Value different perspectives. Disagree without personal attacks.
- **Be constructive**: Critique code and ideas, not people. If something’s broken, propose a fix.
- **Be inclusive**: Welcome beginners, mentor others, and use inclusive language.
- **Take responsibility**: Own your mistakes, learn from feedback, and help improve the project.
- **Communicate clearly**: Write good issues, PRs, and commit messages. Default to transparency.

## Unacceptable Behavior

These are **not tolerated**:

- Hate speech, slurs, or discriminatory jokes.
- Harassment, intimidation, or sustained disruption.
- Doxxing or sharing private information without consent.
- Trolling, flame wars, or intentionally derailing conversations.
- “Gatekeeping” or belittling others based on experience, tools, or tech stack.

## Enforcement

Violations will be handled promptly and decisively:

- Minor incidents may result in a warning.
- Repeated or severe behavior can lead to bans from the project (GitHub issues, PRs, Slack/Discord, etc.).
- Reports will be reviewed by the maintainers or a designated moderation team.

## Reporting

If you experience or witness a violation, **speak up**:

- Email: opensource@itential.com
- Or DM a maintainer in private on our official chat

All reports are confidential. Retaliation against reporters **will not be tolerated**.

## Scope

This Code of Conduct applies in all project spaces, including:

- GitHub issues and PRs
- Community forums, chats, and meetings
- Social media when representing the project

## Attribution

This code is based on the [Contributor Covenant](https://www.contributor-covenant.org), with pragmatic additions tailored for modern open source development.
