 <img src="https://www.salabim.org/salabim_logo_payoff.png" width=400 />

Salabim is a Python library for object-oriented discrete event simulation (DES) and animation.

### Introduction

Discrete event simulation (DES) finds applications in various logistical domains including production facilities, warehousing, airports, hospitals, mining, materials handling, steel mills, and computer network analysis.

Salabim follows a well-proven and intuitive process description method similar to Tomas and Must.</br>The package provides:

- Components
- Queues
- Resources
- Stores
- States
- Monitors for data collection and presentation
- 2D and 3D animation (including video production) (see below)
- Tracing facilities
- Advanced statistical sampling

In contrast to some other Python DES packages, salabim does not require the use of yield statements for process control, making it more straightforward to use. Salabim has minimal requirements, especially when animation is disabled.



### Some salabim animations

 <img src="https://www.salabim.org/cymulation3d.gif" width=700 />

 <img src="https://www.salabim.org/elevator.gif" width=700 />

 <img src="https://www.salabim.org/lights-3d.gif" width=700 />

### Features and documentation

- Cross-platform support: salabim runs on Windows, macOS, Linux, iOS/iPadOS (Pythonista), and can even be used with "Python In Excel".
- Comprehensive documentation: Visit [www.salabim.org/manual](https://www.salabim.org/manual) for detailed documentation.

### Resources

The salabim package can be found on GitHub: www.github.com/salabim/salabim

And on PyPI: https://pypi.org/project/salabim/

### Contributing and Reporting Issues

Contributions to salabim are highly appreciated! You can contribute by issuing a pull request or submitting an issue on [GitHub](https://github.com/salabim/salabim). Alternatively, you can use the [salabim Google user group](https://groups.google.com/g/salabim) for discussions and reporting issues.

### License

Salabim is licensed under the MIT License.

### Support

Ruud van der Ham, the core developer, is available and willing to help users with issues related to the package and modeling in general. He also provides services such as code and model reviews, consultancy, and training.

### Getting Started

To start using salabim, visit [www.salabim.org](www.salabim.org) for installation instructions and further details.

### Badges

![PyPI](https://img.shields.io/pypi/v/salabim) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/salabim) ![PyPI - Implementation](https://img.shields.io/pypi/implementation/salabim)
![PyPI - License](https://img.shields.io/pypi/l/salabim) ![Black](https://img.shields.io/badge/code%20style-black-000000.svg) 
![GitHub last commit](https://img.shields.io/github/last-commit/salabim/salabim)
