# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEventStreamResult',
    'AwaitableGetEventStreamResult',
    'get_event_stream',
    'get_event_stream_output',
]

@pulumi.output_type
class GetEventStreamResult:
    """
    A collection of values returned by getEventStream.
    """
    def __init__(__self__, created_at=None, destination_type=None, eventbridge_configurations=None, id=None, name=None, status=None, subscriptions=None, updated_at=None, webhook_configurations=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if destination_type and not isinstance(destination_type, str):
            raise TypeError("Expected argument 'destination_type' to be a str")
        pulumi.set(__self__, "destination_type", destination_type)
        if eventbridge_configurations and not isinstance(eventbridge_configurations, list):
            raise TypeError("Expected argument 'eventbridge_configurations' to be a list")
        pulumi.set(__self__, "eventbridge_configurations", eventbridge_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if webhook_configurations and not isinstance(webhook_configurations, list):
            raise TypeError("Expected argument 'webhook_configurations' to be a list")
        pulumi.set(__self__, "webhook_configurations", webhook_configurations)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The ISO 8601 timestamp when the stream was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> _builtins.str:
        """
        The type of event stream destination (either 'eventbridge' or 'webhook').
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="eventbridgeConfigurations")
    def eventbridge_configurations(self) -> Sequence['outputs.GetEventStreamEventbridgeConfigurationResult']:
        """
        Configuration for the EventBridge destination. This block is only applicable when `destination_type` is set to `eventbridge`. EventBridge configurations **cannot** be updated after creation. Any change to this block will force the resource to be recreated.
        """
        return pulumi.get(self, "eventbridge_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Event Stream.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the event stream.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> Sequence[_builtins.str]:
        """
        List of event types this stream is subscribed to.
        """
        return pulumi.get(self, "subscriptions")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The ISO 8601 timestamp when the stream was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="webhookConfigurations")
    def webhook_configurations(self) -> Sequence['outputs.GetEventStreamWebhookConfigurationResult']:
        """
        Configuration for the Webhook destination. This block is only applicable when `destination_type` is set to `webhook`. Webhook configurations **can** be updated after creation, including the endpoint and authorization fields.
        """
        return pulumi.get(self, "webhook_configurations")


class AwaitableGetEventStreamResult(GetEventStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventStreamResult(
            created_at=self.created_at,
            destination_type=self.destination_type,
            eventbridge_configurations=self.eventbridge_configurations,
            id=self.id,
            name=self.name,
            status=self.status,
            subscriptions=self.subscriptions,
            updated_at=self.updated_at,
            webhook_configurations=self.webhook_configurations)


def get_event_stream(id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventStreamResult:
    """
    Data source to retrieve a specific Auth0 Event Stream by `id`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Event Stream loaded using its ID.
    test = auth0.get_event_stream(id="est_XXXXXXXXXXXXXXX")
    ```


    :param _builtins.str id: The ID of the Event Stream.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getEventStream:getEventStream', __args__, opts=opts, typ=GetEventStreamResult).value

    return AwaitableGetEventStreamResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        destination_type=pulumi.get(__ret__, 'destination_type'),
        eventbridge_configurations=pulumi.get(__ret__, 'eventbridge_configurations'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        subscriptions=pulumi.get(__ret__, 'subscriptions'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        webhook_configurations=pulumi.get(__ret__, 'webhook_configurations'))
def get_event_stream_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventStreamResult]:
    """
    Data source to retrieve a specific Auth0 Event Stream by `id`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Event Stream loaded using its ID.
    test = auth0.get_event_stream(id="est_XXXXXXXXXXXXXXX")
    ```


    :param _builtins.str id: The ID of the Event Stream.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getEventStream:getEventStream', __args__, opts=opts, typ=GetEventStreamResult)
    return __ret__.apply(lambda __response__: GetEventStreamResult(
        created_at=pulumi.get(__response__, 'created_at'),
        destination_type=pulumi.get(__response__, 'destination_type'),
        eventbridge_configurations=pulumi.get(__response__, 'eventbridge_configurations'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        subscriptions=pulumi.get(__response__, 'subscriptions'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        webhook_configurations=pulumi.get(__response__, 'webhook_configurations')))
