# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ModelComponentModelArgs',
    'ModelComponentModelArgsDict',
    'ModelMetricArgs',
    'ModelMetricArgsDict',
    'ModelMetricDatasetSummaryArgs',
    'ModelMetricDatasetSummaryArgsDict',
    'ModelMetricLabelMetricsReportArgs',
    'ModelMetricLabelMetricsReportArgsDict',
    'ModelMetricLabelMetricsReportConfidenceEntryArgs',
    'ModelMetricLabelMetricsReportConfidenceEntryArgsDict',
    'ModelMetricOverallMetricsReportArgs',
    'ModelMetricOverallMetricsReportArgsDict',
    'ModelMetricOverallMetricsReportConfidenceEntryArgs',
    'ModelMetricOverallMetricsReportConfidenceEntryArgsDict',
    'ModelTestingDatasetArgs',
    'ModelTestingDatasetArgsDict',
    'ModelTrainingDatasetArgs',
    'ModelTrainingDatasetArgsDict',
    'ModelValidationDatasetArgs',
    'ModelValidationDatasetArgsDict',
    'ProcessorJobInputLocationArgs',
    'ProcessorJobInputLocationArgsDict',
    'ProcessorJobInputLocationObjectLocationArgs',
    'ProcessorJobInputLocationObjectLocationArgsDict',
    'ProcessorJobOutputLocationArgs',
    'ProcessorJobOutputLocationArgsDict',
    'ProcessorJobProcessorConfigArgs',
    'ProcessorJobProcessorConfigArgsDict',
    'ProcessorJobProcessorConfigFeatureArgs',
    'ProcessorJobProcessorConfigFeatureArgsDict',
    'GetModelsFilterArgs',
    'GetModelsFilterArgsDict',
    'GetProjectsFilterArgs',
    'GetProjectsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ModelComponentModelArgsDict(TypedDict):
        model_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
elif False:
    ModelComponentModelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelComponentModelArgs:
    def __init__(__self__, *,
                 model_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_id", value)


if not MYPY:
    class ModelMetricArgsDict(TypedDict):
        dataset_summaries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgsDict']]]]
        """
        Summary of count of samples used during model training.
        """
        label_metrics_reports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgsDict']]]]
        """
        List of metrics entries per label.
        """
        model_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of the Document model.
        """
        overall_metrics_reports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgsDict']]]]
        """
        Overall Metrics report for Document Classification Model.
        """
elif False:
    ModelMetricArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricArgs:
    def __init__(__self__, *,
                 dataset_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]] = None,
                 label_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]] = None,
                 model_type: Optional[pulumi.Input[builtins.str]] = None,
                 overall_metrics_reports: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]] dataset_summaries: Summary of count of samples used during model training.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]] label_metrics_reports: List of metrics entries per label.
        :param pulumi.Input[builtins.str] model_type: The type of the Document model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @dataset_summaries.setter
    def dataset_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricDatasetSummaryArgs']]]]):
        pulumi.set(self, "dataset_summaries", value)

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @label_metrics_reports.setter
    def label_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportArgs']]]]):
        pulumi.set(self, "label_metrics_reports", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")

    @overall_metrics_reports.setter
    def overall_metrics_reports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportArgs']]]]):
        pulumi.set(self, "overall_metrics_reports", value)


if not MYPY:
    class ModelMetricDatasetSummaryArgsDict(TypedDict):
        test_sample_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of samples used for testing the model.
        """
        training_sample_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of samples used for training the model.
        """
        validation_sample_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of samples used for validating the model.
        """
elif False:
    ModelMetricDatasetSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricDatasetSummaryArgs:
    def __init__(__self__, *,
                 test_sample_count: Optional[pulumi.Input[builtins.int]] = None,
                 training_sample_count: Optional[pulumi.Input[builtins.int]] = None,
                 validation_sample_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] test_sample_count: Number of samples used for testing the model.
        :param pulumi.Input[builtins.int] training_sample_count: Number of samples used for training the model.
        :param pulumi.Input[builtins.int] validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @test_sample_count.setter
    def test_sample_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "test_sample_count", value)

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @training_sample_count.setter
    def training_sample_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "training_sample_count", value)

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")

    @validation_sample_count.setter
    def validation_sample_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "validation_sample_count", value)


if not MYPY:
    class ModelMetricLabelMetricsReportArgsDict(TypedDict):
        confidence_entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgsDict']]]]
        """
        List of document classification confidence report.
        """
        document_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Total test documents in the label.
        """
        label: NotRequired[pulumi.Input[builtins.str]]
        """
        Label name
        """
        mean_average_precision: NotRequired[pulumi.Input[builtins.float]]
        """
        Mean average precision under different thresholds
        """
elif False:
    ModelMetricLabelMetricsReportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricLabelMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[builtins.int]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 mean_average_precision: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[builtins.int] document_count: Total test documents in the label.
        :param pulumi.Input[builtins.str] label: Label name
        :param pulumi.Input[builtins.float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricLabelMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "document_count", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "mean_average_precision", value)


if not MYPY:
    class ModelMetricLabelMetricsReportConfidenceEntryArgsDict(TypedDict):
        accuracy: NotRequired[pulumi.Input[builtins.float]]
        """
        accuracy under the threshold
        """
        f1score: NotRequired[pulumi.Input[builtins.float]]
        """
        f1Score under the threshold
        """
        precision: NotRequired[pulumi.Input[builtins.float]]
        """
        Precision under the threshold
        """
        recall: NotRequired[pulumi.Input[builtins.float]]
        """
        Recall under the threshold
        """
        threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        Threshold used to calculate precision and recall.
        """
elif False:
    ModelMetricLabelMetricsReportConfidenceEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricLabelMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[builtins.float]] = None,
                 f1score: Optional[pulumi.Input[builtins.float]] = None,
                 precision: Optional[pulumi.Input[builtins.float]] = None,
                 recall: Optional[pulumi.Input[builtins.float]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.float] accuracy: accuracy under the threshold
        :param pulumi.Input[builtins.float] f1score: f1Score under the threshold
        :param pulumi.Input[builtins.float] precision: Precision under the threshold
        :param pulumi.Input[builtins.float] recall: Recall under the threshold
        :param pulumi.Input[builtins.float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "accuracy", value)

    @property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "f1score", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class ModelMetricOverallMetricsReportArgsDict(TypedDict):
        confidence_entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgsDict']]]]
        """
        List of document classification confidence report.
        """
        document_count: NotRequired[pulumi.Input[builtins.int]]
        """
        Total test documents in the label.
        """
        mean_average_precision: NotRequired[pulumi.Input[builtins.float]]
        """
        Mean average precision under different thresholds
        """
elif False:
    ModelMetricOverallMetricsReportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricOverallMetricsReportArgs:
    def __init__(__self__, *,
                 confidence_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]] = None,
                 document_count: Optional[pulumi.Input[builtins.int]] = None,
                 mean_average_precision: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]] confidence_entries: List of document classification confidence report.
        :param pulumi.Input[builtins.int] document_count: Total test documents in the label.
        :param pulumi.Input[builtins.float] mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @confidence_entries.setter
    def confidence_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricOverallMetricsReportConfidenceEntryArgs']]]]):
        pulumi.set(self, "confidence_entries", value)

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @document_count.setter
    def document_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "document_count", value)

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")

    @mean_average_precision.setter
    def mean_average_precision(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "mean_average_precision", value)


if not MYPY:
    class ModelMetricOverallMetricsReportConfidenceEntryArgsDict(TypedDict):
        accuracy: NotRequired[pulumi.Input[builtins.float]]
        """
        accuracy under the threshold
        """
        f1score: NotRequired[pulumi.Input[builtins.float]]
        """
        f1Score under the threshold
        """
        precision: NotRequired[pulumi.Input[builtins.float]]
        """
        Precision under the threshold
        """
        recall: NotRequired[pulumi.Input[builtins.float]]
        """
        Recall under the threshold
        """
        threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        Threshold used to calculate precision and recall.
        """
elif False:
    ModelMetricOverallMetricsReportConfidenceEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelMetricOverallMetricsReportConfidenceEntryArgs:
    def __init__(__self__, *,
                 accuracy: Optional[pulumi.Input[builtins.float]] = None,
                 f1score: Optional[pulumi.Input[builtins.float]] = None,
                 precision: Optional[pulumi.Input[builtins.float]] = None,
                 recall: Optional[pulumi.Input[builtins.float]] = None,
                 threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.float] accuracy: accuracy under the threshold
        :param pulumi.Input[builtins.float] f1score: f1Score under the threshold
        :param pulumi.Input[builtins.float] precision: Precision under the threshold
        :param pulumi.Input[builtins.float] recall: Recall under the threshold
        :param pulumi.Input[builtins.float] threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @accuracy.setter
    def accuracy(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "accuracy", value)

    @property
    @pulumi.getter
    def f1score(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @f1score.setter
    def f1score(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "f1score", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class ModelTestingDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[builtins.str]]
        """
        The object name of the input data file.
        """
elif False:
    ModelTestingDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelTestingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[builtins.str],
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ModelTrainingDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[builtins.str]]
        """
        The object name of the input data file.
        """
elif False:
    ModelTrainingDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelTrainingDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[builtins.str],
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ModelValidationDatasetArgsDict(TypedDict):
        dataset_type: pulumi.Input[builtins.str]
        """
        The dataset type, based on where it is stored.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        dataset_id: NotRequired[pulumi.Input[builtins.str]]
        """
        OCID of the Data Labeling dataset.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        object: NotRequired[pulumi.Input[builtins.str]]
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    ModelValidationDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ModelValidationDatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input[builtins.str],
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dataset_type: The dataset type, based on where it is stored.
        :param pulumi.Input[builtins.str] bucket: The name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] dataset_id: OCID of the Data Labeling dataset.
        :param pulumi.Input[builtins.str] namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param pulumi.Input[builtins.str] object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input[builtins.str]:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ProcessorJobInputLocationArgsDict(TypedDict):
        source_type: pulumi.Input[builtins.str]
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        data: NotRequired[pulumi.Input[builtins.str]]
        """
        Raw document data with Base64 encoding.
        """
        object_locations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgsDict']]]]
        """
        The list of ObjectLocations.
        """
elif False:
    ProcessorJobInputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobInputLocationArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[builtins.str],
                 data: Optional[pulumi.Input[builtins.str]] = None,
                 object_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        :param pulumi.Input[builtins.str] data: Raw document data with Base64 encoding.
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]] object_locations: The list of ObjectLocations.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @object_locations.setter
    def object_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProcessorJobInputLocationObjectLocationArgs']]]]):
        pulumi.set(self, "object_locations", value)


if not MYPY:
    class ProcessorJobInputLocationObjectLocationArgsDict(TypedDict):
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The Object Storage bucket name.
        """
        namespace: NotRequired[pulumi.Input[builtins.str]]
        """
        The Object Storage namespace name.
        """
        object: NotRequired[pulumi.Input[builtins.str]]
        """
        The Object Storage object name.
        """
elif False:
    ProcessorJobInputLocationObjectLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobInputLocationObjectLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: The Object Storage bucket name.
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace name.
        :param pulumi.Input[builtins.str] object: The Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)


if not MYPY:
    class ProcessorJobOutputLocationArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        The Object Storage bucket name.
        """
        namespace: pulumi.Input[builtins.str]
        """
        The Object Storage namespace.
        """
        prefix: pulumi.Input[builtins.str]
        """
        The Object Storage folder name.
        """
elif False:
    ProcessorJobOutputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobOutputLocationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 namespace: pulumi.Input[builtins.str],
                 prefix: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] bucket: The Object Storage bucket name.
        :param pulumi.Input[builtins.str] namespace: The Object Storage namespace.
        :param pulumi.Input[builtins.str] prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[builtins.str]:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[builtins.str]:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class ProcessorJobProcessorConfigArgsDict(TypedDict):
        features: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgsDict']]]
        """
        The types of document analysis requested.
        """
        processor_type: pulumi.Input[builtins.str]
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        document_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The document type.
        """
        is_zip_output_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not to generate a ZIP file containing the results.
        """
        language: NotRequired[pulumi.Input[builtins.str]]
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
elif False:
    ProcessorJobProcessorConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigArgs:
    def __init__(__self__, *,
                 features: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]],
                 processor_type: pulumi.Input[builtins.str],
                 document_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_zip_output_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]] features: The types of document analysis requested.
        :param pulumi.Input[builtins.str] processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] document_type: The document type.
        :param pulumi.Input[builtins.bool] is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param pulumi.Input[builtins.str] language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter
    def features(self) -> pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input[Sequence[pulumi.Input['ProcessorJobProcessorConfigFeatureArgs']]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @processor_type.setter
    def processor_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "processor_type", value)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @document_type.setter
    def document_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_type", value)

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @is_zip_output_enabled.setter
    def is_zip_output_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_zip_output_enabled", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)


if not MYPY:
    class ProcessorJobProcessorConfigFeatureArgsDict(TypedDict):
        feature_type: pulumi.Input[builtins.str]
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        generate_searchable_pdf: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not to generate a searchable PDF file.
        """
        max_results: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum number of results to return.
        """
        model_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The custom model ID.
        """
        tenancy_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
elif False:
    ProcessorJobProcessorConfigFeatureArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProcessorJobProcessorConfigFeatureArgs:
    def __init__(__self__, *,
                 feature_type: pulumi.Input[builtins.str],
                 generate_searchable_pdf: Optional[pulumi.Input[builtins.bool]] = None,
                 max_results: Optional[pulumi.Input[builtins.int]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenancy_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        :param pulumi.Input[builtins.bool] generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param pulumi.Input[builtins.int] max_results: The maximum number of results to return.
        :param pulumi.Input[builtins.str] model_id: The custom model ID.
        :param pulumi.Input[builtins.str] tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        return pulumi.get(self, "feature_type")

    @feature_type.setter
    def feature_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_type", value)

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @generate_searchable_pdf.setter
    def generate_searchable_pdf(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "generate_searchable_pdf", value)

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @max_results.setter
    def max_results(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_results", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_id", value)


if not MYPY:
    class GetModelsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetModelsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetModelsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetProjectsFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
        regex: NotRequired[builtins.bool]
elif False:
    GetProjectsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetProjectsFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[builtins.bool]):
        pulumi.set(self, "regex", value)


