# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiResult',
    'AwaitableGetApiResult',
    'get_api',
    'get_api_output',
]

@pulumi.output_type
class GetApiResult:
    """
    A collection of values returned by getApi.
    """
    def __init__(__self__, api_id=None, compartment_id=None, content=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, specification_type=None, state=None, time_created=None, time_updated=None, validation_results=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if specification_type and not isinstance(specification_type, str):
            raise TypeError("Expected argument 'specification_type' to be a str")
        pulumi.set(__self__, "specification_type", specification_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if validation_results and not isinstance(validation_results, list):
            raise TypeError("Expected argument 'validation_results' to be a list")
        pulumi.set(__self__, "validation_results", validation_results)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> builtins.str:
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current lifecycleState in more detail. For ACTIVE state it describes if the document has been validated and the possible values are:
        * 'New' for just updated API Specifications
        * 'Validating' for a document which is being validated.
        * 'Valid' the document has been validated without any errors or warnings
        * 'Warning' the document has been validated and contains warnings
        * 'Error' the document has been validated and contains errors
        * 'Failed' the document validation failed
        * 'Canceled' the document validation was canceled
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="specificationType")
    def specification_type(self) -> builtins.str:
        """
        Type of API Specification file.
        """
        return pulumi.get(self, "specification_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the API.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="validationResults")
    def validation_results(self) -> Sequence['outputs.GetApiValidationResultResult']:
        """
        Status of each feature available from the API.
        """
        return pulumi.get(self, "validation_results")


class AwaitableGetApiResult(GetApiResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiResult(
            api_id=self.api_id,
            compartment_id=self.compartment_id,
            content=self.content,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            specification_type=self.specification_type,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            validation_results=self.validation_results)


def get_api(api_id: Optional[builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiResult:
    """
    This data source provides details about a specific Api resource in Oracle Cloud Infrastructure API Gateway service.

    Gets an API by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api = oci.ApiGateway.get_api(api_id=test_api_oci_apigateway_api["id"])
    ```


    :param builtins.str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getApi:getApi', __args__, opts=opts, typ=GetApiResult).value

    return AwaitableGetApiResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        content=pulumi.get(__ret__, 'content'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        specification_type=pulumi.get(__ret__, 'specification_type'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        validation_results=pulumi.get(__ret__, 'validation_results'))
def get_api_output(api_id: Optional[pulumi.Input[builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiResult]:
    """
    This data source provides details about a specific Api resource in Oracle Cloud Infrastructure API Gateway service.

    Gets an API by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api = oci.ApiGateway.get_api(api_id=test_api_oci_apigateway_api["id"])
    ```


    :param builtins.str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApiGateway/getApi:getApi', __args__, opts=opts, typ=GetApiResult)
    return __ret__.apply(lambda __response__: GetApiResult(
        api_id=pulumi.get(__response__, 'api_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        content=pulumi.get(__response__, 'content'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        specification_type=pulumi.get(__response__, 'specification_type'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        validation_results=pulumi.get(__response__, 'validation_results')))
