# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBastionResult',
    'AwaitableGetBastionResult',
    'get_bastion',
    'get_bastion_output',
]

@pulumi.output_type
class GetBastionResult:
    """
    A collection of values returned by getBastion.
    """
    def __init__(__self__, bastion_id=None, bastion_type=None, client_cidr_block_allow_lists=None, compartment_id=None, defined_tags=None, dns_proxy_status=None, freeform_tags=None, id=None, lifecycle_details=None, max_session_ttl_in_seconds=None, max_sessions_allowed=None, name=None, phone_book_entry=None, private_endpoint_ip_address=None, state=None, static_jump_host_ip_addresses=None, system_tags=None, target_subnet_id=None, target_vcn_id=None, time_created=None, time_updated=None):
        if bastion_id and not isinstance(bastion_id, str):
            raise TypeError("Expected argument 'bastion_id' to be a str")
        pulumi.set(__self__, "bastion_id", bastion_id)
        if bastion_type and not isinstance(bastion_type, str):
            raise TypeError("Expected argument 'bastion_type' to be a str")
        pulumi.set(__self__, "bastion_type", bastion_type)
        if client_cidr_block_allow_lists and not isinstance(client_cidr_block_allow_lists, list):
            raise TypeError("Expected argument 'client_cidr_block_allow_lists' to be a list")
        pulumi.set(__self__, "client_cidr_block_allow_lists", client_cidr_block_allow_lists)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if dns_proxy_status and not isinstance(dns_proxy_status, str):
            raise TypeError("Expected argument 'dns_proxy_status' to be a str")
        pulumi.set(__self__, "dns_proxy_status", dns_proxy_status)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_session_ttl_in_seconds and not isinstance(max_session_ttl_in_seconds, int):
            raise TypeError("Expected argument 'max_session_ttl_in_seconds' to be a int")
        pulumi.set(__self__, "max_session_ttl_in_seconds", max_session_ttl_in_seconds)
        if max_sessions_allowed and not isinstance(max_sessions_allowed, int):
            raise TypeError("Expected argument 'max_sessions_allowed' to be a int")
        pulumi.set(__self__, "max_sessions_allowed", max_sessions_allowed)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if phone_book_entry and not isinstance(phone_book_entry, str):
            raise TypeError("Expected argument 'phone_book_entry' to be a str")
        pulumi.set(__self__, "phone_book_entry", phone_book_entry)
        if private_endpoint_ip_address and not isinstance(private_endpoint_ip_address, str):
            raise TypeError("Expected argument 'private_endpoint_ip_address' to be a str")
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if static_jump_host_ip_addresses and not isinstance(static_jump_host_ip_addresses, list):
            raise TypeError("Expected argument 'static_jump_host_ip_addresses' to be a list")
        pulumi.set(__self__, "static_jump_host_ip_addresses", static_jump_host_ip_addresses)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_subnet_id and not isinstance(target_subnet_id, str):
            raise TypeError("Expected argument 'target_subnet_id' to be a str")
        pulumi.set(__self__, "target_subnet_id", target_subnet_id)
        if target_vcn_id and not isinstance(target_vcn_id, str):
            raise TypeError("Expected argument 'target_vcn_id' to be a str")
        pulumi.set(__self__, "target_vcn_id", target_vcn_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> builtins.str:
        return pulumi.get(self, "bastion_id")

    @property
    @pulumi.getter(name="bastionType")
    def bastion_type(self) -> builtins.str:
        """
        The type of bastion.
        """
        return pulumi.get(self, "bastion_type")

    @property
    @pulumi.getter(name="clientCidrBlockAllowLists")
    def client_cidr_block_allow_lists(self) -> Sequence[builtins.str]:
        """
        A list of address ranges in CIDR notation that you want to allow to connect to sessions hosted by this bastion.
        """
        return pulumi.get(self, "client_cidr_block_allow_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The unique identifier (OCID) of the compartment where the bastion is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dnsProxyStatus")
    def dns_proxy_status(self) -> builtins.str:
        """
        Flag to enable FQDN and SOCKS5 Proxy Support. Example: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "dns_proxy_status")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier (OCID) of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxSessionTtlInSeconds")
    def max_session_ttl_in_seconds(self) -> builtins.int:
        """
        The maximum amount of time that any session on the bastion can remain active.
        """
        return pulumi.get(self, "max_session_ttl_in_seconds")

    @property
    @pulumi.getter(name="maxSessionsAllowed")
    def max_sessions_allowed(self) -> builtins.int:
        """
        The maximum number of active sessions allowed on the bastion.
        """
        return pulumi.get(self, "max_sessions_allowed")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneBookEntry")
    def phone_book_entry(self) -> builtins.str:
        """
        The phonebook entry of the customer's team, which can't be changed after creation. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "phone_book_entry")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> builtins.str:
        """
        The private IP address of the created private endpoint.
        """
        return pulumi.get(self, "private_endpoint_ip_address")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the bastion.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticJumpHostIpAddresses")
    def static_jump_host_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A list of IP addresses of the hosts that the bastion has access to. Not applicable to `standard` bastions.
        """
        return pulumi.get(self, "static_jump_host_ip_addresses")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetSubnetId")
    def target_subnet_id(self) -> builtins.str:
        """
        The unique identifier (OCID) of the subnet that the bastion connects to.
        """
        return pulumi.get(self, "target_subnet_id")

    @property
    @pulumi.getter(name="targetVcnId")
    def target_vcn_id(self) -> builtins.str:
        """
        The unique identifier (OCID) of the virtual cloud network (VCN) that the bastion connects to.
        """
        return pulumi.get(self, "target_vcn_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the bastion was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the bastion was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetBastionResult(GetBastionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBastionResult(
            bastion_id=self.bastion_id,
            bastion_type=self.bastion_type,
            client_cidr_block_allow_lists=self.client_cidr_block_allow_lists,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            dns_proxy_status=self.dns_proxy_status,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            max_session_ttl_in_seconds=self.max_session_ttl_in_seconds,
            max_sessions_allowed=self.max_sessions_allowed,
            name=self.name,
            phone_book_entry=self.phone_book_entry,
            private_endpoint_ip_address=self.private_endpoint_ip_address,
            state=self.state,
            static_jump_host_ip_addresses=self.static_jump_host_ip_addresses,
            system_tags=self.system_tags,
            target_subnet_id=self.target_subnet_id,
            target_vcn_id=self.target_vcn_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_bastion(bastion_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBastionResult:
    """
    This data source provides details about a specific Bastion resource in Oracle Cloud Infrastructure Bastion service.

    Retrieves a bastion identified by the bastion ID. A bastion provides secured, public access to target resources in the cloud that you cannot otherwise reach from the internet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bastion = oci.Bastion.get_bastion(bastion_id=test_bastion_oci_bastion_bastion["id"])
    ```


    :param builtins.str bastion_id: The unique identifier (OCID) of the bastion.
    """
    __args__ = dict()
    __args__['bastionId'] = bastion_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Bastion/getBastion:getBastion', __args__, opts=opts, typ=GetBastionResult).value

    return AwaitableGetBastionResult(
        bastion_id=pulumi.get(__ret__, 'bastion_id'),
        bastion_type=pulumi.get(__ret__, 'bastion_type'),
        client_cidr_block_allow_lists=pulumi.get(__ret__, 'client_cidr_block_allow_lists'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        dns_proxy_status=pulumi.get(__ret__, 'dns_proxy_status'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        max_session_ttl_in_seconds=pulumi.get(__ret__, 'max_session_ttl_in_seconds'),
        max_sessions_allowed=pulumi.get(__ret__, 'max_sessions_allowed'),
        name=pulumi.get(__ret__, 'name'),
        phone_book_entry=pulumi.get(__ret__, 'phone_book_entry'),
        private_endpoint_ip_address=pulumi.get(__ret__, 'private_endpoint_ip_address'),
        state=pulumi.get(__ret__, 'state'),
        static_jump_host_ip_addresses=pulumi.get(__ret__, 'static_jump_host_ip_addresses'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_subnet_id=pulumi.get(__ret__, 'target_subnet_id'),
        target_vcn_id=pulumi.get(__ret__, 'target_vcn_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_bastion_output(bastion_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBastionResult]:
    """
    This data source provides details about a specific Bastion resource in Oracle Cloud Infrastructure Bastion service.

    Retrieves a bastion identified by the bastion ID. A bastion provides secured, public access to target resources in the cloud that you cannot otherwise reach from the internet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bastion = oci.Bastion.get_bastion(bastion_id=test_bastion_oci_bastion_bastion["id"])
    ```


    :param builtins.str bastion_id: The unique identifier (OCID) of the bastion.
    """
    __args__ = dict()
    __args__['bastionId'] = bastion_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Bastion/getBastion:getBastion', __args__, opts=opts, typ=GetBastionResult)
    return __ret__.apply(lambda __response__: GetBastionResult(
        bastion_id=pulumi.get(__response__, 'bastion_id'),
        bastion_type=pulumi.get(__response__, 'bastion_type'),
        client_cidr_block_allow_lists=pulumi.get(__response__, 'client_cidr_block_allow_lists'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        dns_proxy_status=pulumi.get(__response__, 'dns_proxy_status'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        max_session_ttl_in_seconds=pulumi.get(__response__, 'max_session_ttl_in_seconds'),
        max_sessions_allowed=pulumi.get(__response__, 'max_sessions_allowed'),
        name=pulumi.get(__response__, 'name'),
        phone_book_entry=pulumi.get(__response__, 'phone_book_entry'),
        private_endpoint_ip_address=pulumi.get(__response__, 'private_endpoint_ip_address'),
        state=pulumi.get(__response__, 'state'),
        static_jump_host_ip_addresses=pulumi.get(__response__, 'static_jump_host_ip_addresses'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_subnet_id=pulumi.get(__response__, 'target_subnet_id'),
        target_vcn_id=pulumi.get(__response__, 'target_vcn_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
