# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BdsInstanceOperationCertificateManagementsManagementArgs', 'BdsInstanceOperationCertificateManagementsManagement']

@pulumi.input_type
class BdsInstanceOperationCertificateManagementsManagementArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[builtins.str],
                 cluster_admin_password: pulumi.Input[builtins.str],
                 enable_operation_certificate_management: pulumi.Input[builtins.bool],
                 renew_operation_certificate_management: pulumi.Input[builtins.bool],
                 services: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 host_cert_details: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]] = None,
                 root_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_key_password: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BdsInstanceOperationCertificateManagementsManagement resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.bool] enable_operation_certificate_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        :param pulumi.Input[builtins.bool] renew_operation_certificate_management: (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: List of services for which certificate needs to be enabled.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]] host_cert_details: List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        :param pulumi.Input[builtins.str] root_certificate: Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        :param pulumi.Input[builtins.str] server_key_password: Base-64 encoded password for CA certificate's private key. This value can be empty.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        pulumi.set(__self__, "enable_operation_certificate_management", enable_operation_certificate_management)
        pulumi.set(__self__, "renew_operation_certificate_management", renew_operation_certificate_management)
        pulumi.set(__self__, "services", services)
        if host_cert_details is not None:
            pulumi.set(__self__, "host_cert_details", host_cert_details)
        if root_certificate is not None:
            pulumi.set(__self__, "root_certificate", root_certificate)
        if server_key_password is not None:
            pulumi.set(__self__, "server_key_password", server_key_password)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Input[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="enableOperationCertificateManagement")
    def enable_operation_certificate_management(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        """
        return pulumi.get(self, "enable_operation_certificate_management")

    @enable_operation_certificate_management.setter
    def enable_operation_certificate_management(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_operation_certificate_management", value)

    @property
    @pulumi.getter(name="renewOperationCertificateManagement")
    def renew_operation_certificate_management(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "renew_operation_certificate_management")

    @renew_operation_certificate_management.setter
    def renew_operation_certificate_management(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "renew_operation_certificate_management", value)

    @property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of services for which certificate needs to be enabled.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="hostCertDetails")
    def host_cert_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]]:
        """
        List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        """
        return pulumi.get(self, "host_cert_details")

    @host_cert_details.setter
    def host_cert_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]]):
        pulumi.set(self, "host_cert_details", value)

    @property
    @pulumi.getter(name="rootCertificate")
    def root_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        """
        return pulumi.get(self, "root_certificate")

    @root_certificate.setter
    def root_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_certificate", value)

    @property
    @pulumi.getter(name="serverKeyPassword")
    def server_key_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded password for CA certificate's private key. This value can be empty.
        """
        return pulumi.get(self, "server_key_password")

    @server_key_password.setter
    def server_key_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_key_password", value)


@pulumi.input_type
class _BdsInstanceOperationCertificateManagementsManagementState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 enable_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 host_cert_details: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]] = None,
                 renew_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceOperationCertificateManagementsManagement resources.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.bool] enable_operation_certificate_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        :param pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]] host_cert_details: List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        :param pulumi.Input[builtins.bool] renew_operation_certificate_management: (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] root_certificate: Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        :param pulumi.Input[builtins.str] server_key_password: Base-64 encoded password for CA certificate's private key. This value can be empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: List of services for which certificate needs to be enabled.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password is not None:
            pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if enable_operation_certificate_management is not None:
            pulumi.set(__self__, "enable_operation_certificate_management", enable_operation_certificate_management)
        if host_cert_details is not None:
            pulumi.set(__self__, "host_cert_details", host_cert_details)
        if renew_operation_certificate_management is not None:
            pulumi.set(__self__, "renew_operation_certificate_management", renew_operation_certificate_management)
        if root_certificate is not None:
            pulumi.set(__self__, "root_certificate", root_certificate)
        if server_key_password is not None:
            pulumi.set(__self__, "server_key_password", server_key_password)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @cluster_admin_password.setter
    def cluster_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_admin_password", value)

    @property
    @pulumi.getter(name="enableOperationCertificateManagement")
    def enable_operation_certificate_management(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        """
        return pulumi.get(self, "enable_operation_certificate_management")

    @enable_operation_certificate_management.setter
    def enable_operation_certificate_management(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_operation_certificate_management", value)

    @property
    @pulumi.getter(name="hostCertDetails")
    def host_cert_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]]:
        """
        List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        """
        return pulumi.get(self, "host_cert_details")

    @host_cert_details.setter
    def host_cert_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs']]]]):
        pulumi.set(self, "host_cert_details", value)

    @property
    @pulumi.getter(name="renewOperationCertificateManagement")
    def renew_operation_certificate_management(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "renew_operation_certificate_management")

    @renew_operation_certificate_management.setter
    def renew_operation_certificate_management(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "renew_operation_certificate_management", value)

    @property
    @pulumi.getter(name="rootCertificate")
    def root_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        """
        return pulumi.get(self, "root_certificate")

    @root_certificate.setter
    def root_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_certificate", value)

    @property
    @pulumi.getter(name="serverKeyPassword")
    def server_key_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base-64 encoded password for CA certificate's private key. This value can be empty.
        """
        return pulumi.get(self, "server_key_password")

    @server_key_password.setter
    def server_key_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_key_password", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of services for which certificate needs to be enabled.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "services", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceOperationCertificateManagementsManagement:BdsInstanceOperationCertificateManagementsManagement")
class BdsInstanceOperationCertificateManagementsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 enable_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 host_cert_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs', 'BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgsDict']]]]] = None,
                 renew_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Bds Instance Operation Certificate Managements Management resource in Oracle Cloud Infrastructure Big Data Service service.

        Configuring TLS/SSL for various ODH services running on the BDS cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_operation_certificate_managements_management = oci.big_data_service.BdsInstanceOperationCertificateManagementsManagement("test_bds_instance_operation_certificate_managements_management",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_operation_certificate_managements_management_cluster_admin_password,
            services=bds_instance_operation_certificate_managements_management_services,
            enable_operation_certificate_management=enable_operation_certificate_management,
            renew_operation_certificate_management=renew_operation_certificate_management,
            host_cert_details=[{
                "certificate": bds_instance_operation_certificate_managements_management_host_cert_details_certificate,
                "host_name": bds_instance_operation_certificate_managements_management_host_cert_details_host_name,
                "private_key": bds_instance_operation_certificate_managements_management_host_cert_details_private_key,
            }],
            root_certificate=bds_instance_operation_certificate_managements_management_root_certificate,
            server_key_password=bds_instance_operation_certificate_managements_management_server_key_password)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.bool] enable_operation_certificate_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs', 'BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgsDict']]]] host_cert_details: List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        :param pulumi.Input[builtins.bool] renew_operation_certificate_management: (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] root_certificate: Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        :param pulumi.Input[builtins.str] server_key_password: Base-64 encoded password for CA certificate's private key. This value can be empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: List of services for which certificate needs to be enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceOperationCertificateManagementsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Bds Instance Operation Certificate Managements Management resource in Oracle Cloud Infrastructure Big Data Service service.

        Configuring TLS/SSL for various ODH services running on the BDS cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_bds_instance_operation_certificate_managements_management = oci.big_data_service.BdsInstanceOperationCertificateManagementsManagement("test_bds_instance_operation_certificate_managements_management",
            bds_instance_id=test_bds_instance["id"],
            cluster_admin_password=bds_instance_operation_certificate_managements_management_cluster_admin_password,
            services=bds_instance_operation_certificate_managements_management_services,
            enable_operation_certificate_management=enable_operation_certificate_management,
            renew_operation_certificate_management=renew_operation_certificate_management,
            host_cert_details=[{
                "certificate": bds_instance_operation_certificate_managements_management_host_cert_details_certificate,
                "host_name": bds_instance_operation_certificate_managements_management_host_cert_details_host_name,
                "private_key": bds_instance_operation_certificate_managements_management_host_cert_details_private_key,
            }],
            root_certificate=bds_instance_operation_certificate_managements_management_root_certificate,
            server_key_password=bds_instance_operation_certificate_managements_management_server_key_password)
        ```

        :param str resource_name: The name of the resource.
        :param BdsInstanceOperationCertificateManagementsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceOperationCertificateManagementsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 enable_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 host_cert_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs', 'BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgsDict']]]]] = None,
                 renew_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 server_key_password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceOperationCertificateManagementsManagementArgs.__new__(BdsInstanceOperationCertificateManagementsManagementArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if cluster_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_admin_password'")
            __props__.__dict__["cluster_admin_password"] = None if cluster_admin_password is None else pulumi.Output.secret(cluster_admin_password)
            if enable_operation_certificate_management is None and not opts.urn:
                raise TypeError("Missing required property 'enable_operation_certificate_management'")
            __props__.__dict__["enable_operation_certificate_management"] = enable_operation_certificate_management
            __props__.__dict__["host_cert_details"] = host_cert_details
            if renew_operation_certificate_management is None and not opts.urn:
                raise TypeError("Missing required property 'renew_operation_certificate_management'")
            __props__.__dict__["renew_operation_certificate_management"] = renew_operation_certificate_management
            __props__.__dict__["root_certificate"] = root_certificate
            __props__.__dict__["server_key_password"] = None if server_key_password is None else pulumi.Output.secret(server_key_password)
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clusterAdminPassword", "serverKeyPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BdsInstanceOperationCertificateManagementsManagement, __self__).__init__(
            'oci:BigDataService/bdsInstanceOperationCertificateManagementsManagement:BdsInstanceOperationCertificateManagementsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_admin_password: Optional[pulumi.Input[builtins.str]] = None,
            enable_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
            host_cert_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs', 'BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgsDict']]]]] = None,
            renew_operation_certificate_management: Optional[pulumi.Input[builtins.bool]] = None,
            root_certificate: Optional[pulumi.Input[builtins.str]] = None,
            server_key_password: Optional[pulumi.Input[builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'BdsInstanceOperationCertificateManagementsManagement':
        """
        Get an existing BdsInstanceOperationCertificateManagementsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        :param pulumi.Input[builtins.str] cluster_admin_password: Base-64 encoded password for the cluster admin user.
        :param pulumi.Input[builtins.bool] enable_operation_certificate_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgs', 'BdsInstanceOperationCertificateManagementsManagementHostCertDetailArgsDict']]]] host_cert_details: List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        :param pulumi.Input[builtins.bool] renew_operation_certificate_management: (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] root_certificate: Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        :param pulumi.Input[builtins.str] server_key_password: Base-64 encoded password for CA certificate's private key. This value can be empty.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] services: List of services for which certificate needs to be enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceOperationCertificateManagementsManagementState.__new__(_BdsInstanceOperationCertificateManagementsManagementState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["cluster_admin_password"] = cluster_admin_password
        __props__.__dict__["enable_operation_certificate_management"] = enable_operation_certificate_management
        __props__.__dict__["host_cert_details"] = host_cert_details
        __props__.__dict__["renew_operation_certificate_management"] = renew_operation_certificate_management
        __props__.__dict__["root_certificate"] = root_certificate
        __props__.__dict__["server_key_password"] = server_key_password
        __props__.__dict__["services"] = services
        return BdsInstanceOperationCertificateManagementsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> pulumi.Output[builtins.str]:
        """
        Base-64 encoded password for the cluster admin user.
        """
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="enableOperationCertificateManagement")
    def enable_operation_certificate_management(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
        """
        return pulumi.get(self, "enable_operation_certificate_management")

    @property
    @pulumi.getter(name="hostCertDetails")
    def host_cert_details(self) -> pulumi.Output[Sequence['outputs.BdsInstanceOperationCertificateManagementsManagementHostCertDetail']]:
        """
        List of leaf certificates to use for services on each host. If custom host certificate is provided the root certificate becomes required.
        """
        return pulumi.get(self, "host_cert_details")

    @property
    @pulumi.getter(name="renewOperationCertificateManagement")
    def renew_operation_certificate_management(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls renew action and when set to `false` defaults to enable_operation_certificate_management's value action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "renew_operation_certificate_management")

    @property
    @pulumi.getter(name="rootCertificate")
    def root_certificate(self) -> pulumi.Output[builtins.str]:
        """
        Plain text certificate/s in order, separated by new line character. If not provided in request a self-signed root certificate is generated inside the cluster. In case hostCertDetails is provided, root certificate is mandatory.
        """
        return pulumi.get(self, "root_certificate")

    @property
    @pulumi.getter(name="serverKeyPassword")
    def server_key_password(self) -> pulumi.Output[builtins.str]:
        """
        Base-64 encoded password for CA certificate's private key. This value can be empty.
        """
        return pulumi.get(self, "server_key_password")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of services for which certificate needs to be enabled.
        """
        return pulumi.get(self, "services")

