# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BdsInstanceSoftwareUpdateActionArgs', 'BdsInstanceSoftwareUpdateAction']

@pulumi.input_type
class BdsInstanceSoftwareUpdateActionArgs:
    def __init__(__self__, *,
                 bds_instance_id: pulumi.Input[builtins.str],
                 software_update_keys: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        The set of arguments for constructing a BdsInstanceSoftwareUpdateAction resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        """
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        pulumi.set(__self__, "software_update_keys", software_update_keys)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="softwareUpdateKeys")
    def software_update_keys(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "software_update_keys")

    @software_update_keys.setter
    def software_update_keys(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "software_update_keys", value)


@pulumi.input_type
class _BdsInstanceSoftwareUpdateActionState:
    def __init__(__self__, *,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 software_update_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering BdsInstanceSoftwareUpdateAction resources.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        """
        if bds_instance_id is not None:
            pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if software_update_keys is not None:
            pulumi.set(__self__, "software_update_keys", software_update_keys)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @bds_instance_id.setter
    def bds_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bds_instance_id", value)

    @property
    @pulumi.getter(name="softwareUpdateKeys")
    def software_update_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "software_update_keys")

    @software_update_keys.setter
    def software_update_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "software_update_keys", value)


@pulumi.type_token("oci:BigDataService/bdsInstanceSoftwareUpdateAction:BdsInstanceSoftwareUpdateAction")
class BdsInstanceSoftwareUpdateAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 software_update_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource installs the specified software update to the nodes of the Oracle Cloud Infrastructure Big Data Service cluster.

        Install Software Update of the specified SoftwareUpdateId to this BDS cluster's nodes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BdsInstanceSoftwareUpdateActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource installs the specified software update to the nodes of the Oracle Cloud Infrastructure Big Data Service cluster.

        Install Software Update of the specified SoftwareUpdateId to this BDS cluster's nodes.

        :param str resource_name: The name of the resource.
        :param BdsInstanceSoftwareUpdateActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BdsInstanceSoftwareUpdateActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 software_update_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BdsInstanceSoftwareUpdateActionArgs.__new__(BdsInstanceSoftwareUpdateActionArgs)

            if bds_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bds_instance_id'")
            __props__.__dict__["bds_instance_id"] = bds_instance_id
            if software_update_keys is None and not opts.urn:
                raise TypeError("Missing required property 'software_update_keys'")
            __props__.__dict__["software_update_keys"] = software_update_keys
        super(BdsInstanceSoftwareUpdateAction, __self__).__init__(
            'oci:BigDataService/bdsInstanceSoftwareUpdateAction:BdsInstanceSoftwareUpdateAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
            software_update_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'BdsInstanceSoftwareUpdateAction':
        """
        Get an existing BdsInstanceSoftwareUpdateAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bds_instance_id: The OCID of the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BdsInstanceSoftwareUpdateActionState.__new__(_BdsInstanceSoftwareUpdateActionState)

        __props__.__dict__["bds_instance_id"] = bds_instance_id
        __props__.__dict__["software_update_keys"] = software_update_keys
        return BdsInstanceSoftwareUpdateAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="softwareUpdateKeys")
    def software_update_keys(self) -> pulumi.Output[Sequence[builtins.str]]:
        return pulumi.get(self, "software_update_keys")

