# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceNodeBackupsResult',
    'AwaitableGetBdsInstanceNodeBackupsResult',
    'get_bds_instance_node_backups',
    'get_bds_instance_node_backups_output',
]

@pulumi.output_type
class GetBdsInstanceNodeBackupsResult:
    """
    A collection of values returned by getBdsInstanceNodeBackups.
    """
    def __init__(__self__, bds_instance_id=None, display_name=None, filters=None, id=None, node_backups=None, node_host_name=None, state=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_backups and not isinstance(node_backups, list):
            raise TypeError("Expected argument 'node_backups' to be a list")
        pulumi.set(__self__, "node_backups", node_backups)
        if node_host_name and not isinstance(node_host_name, str):
            raise TypeError("Expected argument 'node_host_name' to be a str")
        pulumi.set(__self__, "node_host_name", node_host_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        BDS generated name for the backup. Format is nodeHostName_timeCreated.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceNodeBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeBackups")
    def node_backups(self) -> Sequence['outputs.GetBdsInstanceNodeBackupsNodeBackupResult']:
        """
        The list of node_backups.
        """
        return pulumi.get(self, "node_backups")

    @property
    @pulumi.getter(name="nodeHostName")
    def node_host_name(self) -> Optional[builtins.str]:
        """
        Host name of the node to which this backup belongs.
        """
        return pulumi.get(self, "node_host_name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the NodeBackup.
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstanceNodeBackupsResult(GetBdsInstanceNodeBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceNodeBackupsResult(
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            node_backups=self.node_backups,
            node_host_name=self.node_host_name,
            state=self.state)


def get_bds_instance_node_backups(bds_instance_id: Optional[builtins.str] = None,
                                  display_name: Optional[builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetBdsInstanceNodeBackupsFilterArgs', 'GetBdsInstanceNodeBackupsFilterArgsDict']]] = None,
                                  node_host_name: Optional[builtins.str] = None,
                                  state: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceNodeBackupsResult:
    """
    This data source provides the list of Bds Instance Node Backups in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the node Backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backups = oci.BigDataService.get_bds_instance_node_backups(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_node_backup_display_name,
        node_host_name=bds_instance_node_backup_node_host_name,
        state=bds_instance_node_backup_state)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str display_name: The display name belonged to the node backup.
    :param builtins.str node_host_name: The node host name belonged to a node that has a node backup.
    :param builtins.str state: The state of the Node's Backup.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['nodeHostName'] = node_host_name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceNodeBackups:getBdsInstanceNodeBackups', __args__, opts=opts, typ=GetBdsInstanceNodeBackupsResult).value

    return AwaitableGetBdsInstanceNodeBackupsResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        node_backups=pulumi.get(__ret__, 'node_backups'),
        node_host_name=pulumi.get(__ret__, 'node_host_name'),
        state=pulumi.get(__ret__, 'state'))
def get_bds_instance_node_backups_output(bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceNodeBackupsFilterArgs', 'GetBdsInstanceNodeBackupsFilterArgsDict']]]]] = None,
                                         node_host_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceNodeBackupsResult]:
    """
    This data source provides the list of Bds Instance Node Backups in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the node Backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backups = oci.BigDataService.get_bds_instance_node_backups(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_node_backup_display_name,
        node_host_name=bds_instance_node_backup_node_host_name,
        state=bds_instance_node_backup_state)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str display_name: The display name belonged to the node backup.
    :param builtins.str node_host_name: The node host name belonged to a node that has a node backup.
    :param builtins.str state: The state of the Node's Backup.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['nodeHostName'] = node_host_name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceNodeBackups:getBdsInstanceNodeBackups', __args__, opts=opts, typ=GetBdsInstanceNodeBackupsResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceNodeBackupsResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        node_backups=pulumi.get(__response__, 'node_backups'),
        node_host_name=pulumi.get(__response__, 'node_host_name'),
        state=pulumi.get(__response__, 'state')))
