# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceNodeReplaceConfigurationsResult',
    'AwaitableGetBdsInstanceNodeReplaceConfigurationsResult',
    'get_bds_instance_node_replace_configurations',
    'get_bds_instance_node_replace_configurations_output',
]

@pulumi.output_type
class GetBdsInstanceNodeReplaceConfigurationsResult:
    """
    A collection of values returned by getBdsInstanceNodeReplaceConfigurations.
    """
    def __init__(__self__, bds_instance_id=None, display_name=None, filters=None, id=None, node_replace_configurations=None, state=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_replace_configurations and not isinstance(node_replace_configurations, list):
            raise TypeError("Expected argument 'node_replace_configurations' to be a list")
        pulumi.set(__self__, "node_replace_configurations", node_replace_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> builtins.str:
        """
        The OCID of the bdsInstance which is the parent resource id.
        """
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceNodeReplaceConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeReplaceConfigurations")
    def node_replace_configurations(self) -> Sequence['outputs.GetBdsInstanceNodeReplaceConfigurationsNodeReplaceConfigurationResult']:
        """
        The list of node_replace_configurations.
        """
        return pulumi.get(self, "node_replace_configurations")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the NodeReplaceConfiguration.
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstanceNodeReplaceConfigurationsResult(GetBdsInstanceNodeReplaceConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceNodeReplaceConfigurationsResult(
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            node_replace_configurations=self.node_replace_configurations,
            state=self.state)


def get_bds_instance_node_replace_configurations(bds_instance_id: Optional[builtins.str] = None,
                                                 display_name: Optional[builtins.str] = None,
                                                 filters: Optional[Sequence[Union['GetBdsInstanceNodeReplaceConfigurationsFilterArgs', 'GetBdsInstanceNodeReplaceConfigurationsFilterArgsDict']]] = None,
                                                 state: Optional[builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceNodeReplaceConfigurationsResult:
    """
    This data source provides the list of Bds Instance Node Replace Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the NodeReplaceConfiguration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_replace_configurations = oci.BigDataService.get_bds_instance_node_replace_configurations(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_node_replace_configuration_display_name,
        state=bds_instance_node_replace_configuration_state)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: The state of the NodeReplaceConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceNodeReplaceConfigurations:getBdsInstanceNodeReplaceConfigurations', __args__, opts=opts, typ=GetBdsInstanceNodeReplaceConfigurationsResult).value

    return AwaitableGetBdsInstanceNodeReplaceConfigurationsResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        node_replace_configurations=pulumi.get(__ret__, 'node_replace_configurations'),
        state=pulumi.get(__ret__, 'state'))
def get_bds_instance_node_replace_configurations_output(bds_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                                        display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceNodeReplaceConfigurationsFilterArgs', 'GetBdsInstanceNodeReplaceConfigurationsFilterArgsDict']]]]] = None,
                                                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceNodeReplaceConfigurationsResult]:
    """
    This data source provides the list of Bds Instance Node Replace Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the NodeReplaceConfiguration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_replace_configurations = oci.BigDataService.get_bds_instance_node_replace_configurations(bds_instance_id=test_bds_instance["id"],
        display_name=bds_instance_node_replace_configuration_display_name,
        state=bds_instance_node_replace_configuration_state)
    ```


    :param builtins.str bds_instance_id: The OCID of the cluster.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str state: The state of the NodeReplaceConfiguration.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceNodeReplaceConfigurations:getBdsInstanceNodeReplaceConfigurations', __args__, opts=opts, typ=GetBdsInstanceNodeReplaceConfigurationsResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceNodeReplaceConfigurationsResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        node_replace_configurations=pulumi.get(__response__, 'node_replace_configurations'),
        state=pulumi.get(__response__, 'state')))
