# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlertRulesResult',
    'AwaitableGetAlertRulesResult',
    'get_alert_rules',
    'get_alert_rules_output',
]

@pulumi.output_type
class GetAlertRulesResult:
    """
    A collection of values returned by getAlertRules.
    """
    def __init__(__self__, alert_rules=None, budget_id=None, display_name=None, filters=None, id=None, state=None):
        if alert_rules and not isinstance(alert_rules, list):
            raise TypeError("Expected argument 'alert_rules' to be a list")
        pulumi.set(__self__, "alert_rules", alert_rules)
        if budget_id and not isinstance(budget_id, str):
            raise TypeError("Expected argument 'budget_id' to be a str")
        pulumi.set(__self__, "budget_id", budget_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="alertRules")
    def alert_rules(self) -> Sequence['outputs.GetAlertRulesAlertRuleResult']:
        """
        The list of alert_rules.
        """
        return pulumi.get(self, "alert_rules")

    @property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> builtins.str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "budget_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The name of the alert rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAlertRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the alert rule.
        """
        return pulumi.get(self, "state")


class AwaitableGetAlertRulesResult(GetAlertRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertRulesResult(
            alert_rules=self.alert_rules,
            budget_id=self.budget_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_alert_rules(budget_id: Optional[builtins.str] = None,
                    display_name: Optional[builtins.str] = None,
                    filters: Optional[Sequence[Union['GetAlertRulesFilterArgs', 'GetAlertRulesFilterArgsDict']]] = None,
                    state: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertRulesResult:
    """
    This data source provides the list of Alert Rules in Oracle Cloud Infrastructure Budget service.

    Returns a list of Alert Rules for a specified budget.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_rules = oci.Budget.get_alert_rules(budget_id=test_budget["id"],
        display_name=alert_rule_display_name,
        state=alert_rule_state)
    ```


    :param builtins.str budget_id: The unique budget OCID.
    :param builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
    :param builtins.str state: The current state of the resource to filter by.
    """
    __args__ = dict()
    __args__['budgetId'] = budget_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Budget/getAlertRules:getAlertRules', __args__, opts=opts, typ=GetAlertRulesResult).value

    return AwaitableGetAlertRulesResult(
        alert_rules=pulumi.get(__ret__, 'alert_rules'),
        budget_id=pulumi.get(__ret__, 'budget_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_alert_rules_output(budget_id: Optional[pulumi.Input[builtins.str]] = None,
                           display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAlertRulesFilterArgs', 'GetAlertRulesFilterArgsDict']]]]] = None,
                           state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertRulesResult]:
    """
    This data source provides the list of Alert Rules in Oracle Cloud Infrastructure Budget service.

    Returns a list of Alert Rules for a specified budget.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_rules = oci.Budget.get_alert_rules(budget_id=test_budget["id"],
        display_name=alert_rule_display_name,
        state=alert_rule_state)
    ```


    :param builtins.str budget_id: The unique budget OCID.
    :param builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
    :param builtins.str state: The current state of the resource to filter by.
    """
    __args__ = dict()
    __args__['budgetId'] = budget_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Budget/getAlertRules:getAlertRules', __args__, opts=opts, typ=GetAlertRulesResult)
    return __ret__.apply(lambda __response__: GetAlertRulesResult(
        alert_rules=pulumi.get(__response__, 'alert_rules'),
        budget_id=pulumi.get(__response__, 'budget_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
