# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetClusterPlacementGroupsResult',
    'AwaitableGetClusterPlacementGroupsResult',
    'get_cluster_placement_groups',
    'get_cluster_placement_groups_output',
]

@pulumi.output_type
class GetClusterPlacementGroupsResult:
    """
    A collection of values returned by getClusterPlacementGroups.
    """
    def __init__(__self__, ad=None, cluster_placement_group_collections=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, name=None, state=None):
        if ad and not isinstance(ad, str):
            raise TypeError("Expected argument 'ad' to be a str")
        pulumi.set(__self__, "ad", ad)
        if cluster_placement_group_collections and not isinstance(cluster_placement_group_collections, list):
            raise TypeError("Expected argument 'cluster_placement_group_collections' to be a list")
        pulumi.set(__self__, "cluster_placement_group_collections", cluster_placement_group_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def ad(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ad")

    @property
    @pulumi.getter(name="clusterPlacementGroupCollections")
    def cluster_placement_group_collections(self) -> Sequence['outputs.GetClusterPlacementGroupsClusterPlacementGroupCollectionResult']:
        """
        The list of cluster_placement_group_collection.
        """
        return pulumi.get(self, "cluster_placement_group_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the cluster placement group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetClusterPlacementGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The user-friendly name of the cluster placement group. The display name for a cluster placement must be unique and you cannot change it. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the ClusterPlacementGroup.
        """
        return pulumi.get(self, "state")


class AwaitableGetClusterPlacementGroupsResult(GetClusterPlacementGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterPlacementGroupsResult(
            ad=self.ad,
            cluster_placement_group_collections=self.cluster_placement_group_collections,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_cluster_placement_groups(ad: Optional[builtins.str] = None,
                                 compartment_id: Optional[builtins.str] = None,
                                 compartment_id_in_subtree: Optional[builtins.bool] = None,
                                 filters: Optional[Sequence[Union['GetClusterPlacementGroupsFilterArgs', 'GetClusterPlacementGroupsFilterArgsDict']]] = None,
                                 id: Optional[builtins.str] = None,
                                 name: Optional[builtins.str] = None,
                                 state: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterPlacementGroupsResult:
    """
    This data source provides the list of Cluster Placement Groups in Oracle Cloud Infrastructure Cluster Placement Groups service.

    Gets a list of all cluster placement groups in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_placement_groups = oci.ClusterPlacementGroups.get_cluster_placement_groups(ad=cluster_placement_group_ad,
        compartment_id=compartment_id,
        compartment_id_in_subtree=cluster_placement_group_compartment_id_in_subtree,
        id=cluster_placement_group_id,
        name=cluster_placement_group_name,
        state=cluster_placement_group_state)
    ```


    :param builtins.str ad: A filter to return only the resources that match the specified availability domain.
    :param builtins.str compartment_id: A filter to return only the resources that match the specified compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.bool compartment_id_in_subtree: When set to `true`, cluster placement groups in all compartments under the specified compartment are returned. The default is set to `false`.
    :param builtins.str id: A filter to return only the resources that match the specified unique cluster placement group identifier.
    :param builtins.str name: A filter to return only the resources that match the entire display name specified.
    :param builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['ad'] = ad
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ClusterPlacementGroups/getClusterPlacementGroups:getClusterPlacementGroups', __args__, opts=opts, typ=GetClusterPlacementGroupsResult).value

    return AwaitableGetClusterPlacementGroupsResult(
        ad=pulumi.get(__ret__, 'ad'),
        cluster_placement_group_collections=pulumi.get(__ret__, 'cluster_placement_group_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_cluster_placement_groups_output(ad: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetClusterPlacementGroupsFilterArgs', 'GetClusterPlacementGroupsFilterArgsDict']]]]] = None,
                                        id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterPlacementGroupsResult]:
    """
    This data source provides the list of Cluster Placement Groups in Oracle Cloud Infrastructure Cluster Placement Groups service.

    Gets a list of all cluster placement groups in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_placement_groups = oci.ClusterPlacementGroups.get_cluster_placement_groups(ad=cluster_placement_group_ad,
        compartment_id=compartment_id,
        compartment_id_in_subtree=cluster_placement_group_compartment_id_in_subtree,
        id=cluster_placement_group_id,
        name=cluster_placement_group_name,
        state=cluster_placement_group_state)
    ```


    :param builtins.str ad: A filter to return only the resources that match the specified availability domain.
    :param builtins.str compartment_id: A filter to return only the resources that match the specified compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.bool compartment_id_in_subtree: When set to `true`, cluster placement groups in all compartments under the specified compartment are returned. The default is set to `false`.
    :param builtins.str id: A filter to return only the resources that match the specified unique cluster placement group identifier.
    :param builtins.str name: A filter to return only the resources that match the entire display name specified.
    :param builtins.str state: A filter to return only the resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['ad'] = ad
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ClusterPlacementGroups/getClusterPlacementGroups:getClusterPlacementGroups', __args__, opts=opts, typ=GetClusterPlacementGroupsResult)
    return __ret__.apply(lambda __response__: GetClusterPlacementGroupsResult(
        ad=pulumi.get(__response__, 'ad'),
        cluster_placement_group_collections=pulumi.get(__response__, 'cluster_placement_group_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
