# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrgRouteDistributionStatementsResult',
    'AwaitableGetDrgRouteDistributionStatementsResult',
    'get_drg_route_distribution_statements',
    'get_drg_route_distribution_statements_output',
]

@pulumi.output_type
class GetDrgRouteDistributionStatementsResult:
    """
    A collection of values returned by getDrgRouteDistributionStatements.
    """
    def __init__(__self__, drg_route_distribution_id=None, drg_route_distribution_statements=None, filters=None, id=None):
        if drg_route_distribution_id and not isinstance(drg_route_distribution_id, str):
            raise TypeError("Expected argument 'drg_route_distribution_id' to be a str")
        pulumi.set(__self__, "drg_route_distribution_id", drg_route_distribution_id)
        if drg_route_distribution_statements and not isinstance(drg_route_distribution_statements, list):
            raise TypeError("Expected argument 'drg_route_distribution_statements' to be a list")
        pulumi.set(__self__, "drg_route_distribution_statements", drg_route_distribution_statements)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="drgRouteDistributionId")
    def drg_route_distribution_id(self) -> builtins.str:
        return pulumi.get(self, "drg_route_distribution_id")

    @property
    @pulumi.getter(name="drgRouteDistributionStatements")
    def drg_route_distribution_statements(self) -> Sequence['outputs.GetDrgRouteDistributionStatementsDrgRouteDistributionStatementResult']:
        """
        The list of drg_route_distribution_statements.
        """
        return pulumi.get(self, "drg_route_distribution_statements")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrgRouteDistributionStatementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDrgRouteDistributionStatementsResult(GetDrgRouteDistributionStatementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgRouteDistributionStatementsResult(
            drg_route_distribution_id=self.drg_route_distribution_id,
            drg_route_distribution_statements=self.drg_route_distribution_statements,
            filters=self.filters,
            id=self.id)


def get_drg_route_distribution_statements(drg_route_distribution_id: Optional[builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetDrgRouteDistributionStatementsFilterArgs', 'GetDrgRouteDistributionStatementsFilterArgsDict']]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgRouteDistributionStatementsResult:
    """
    This data source provides the list of Drg Route Distribution Statements in Oracle Cloud Infrastructure Core service.

    Lists the statements for the specified route distribution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distribution_statements = oci.Core.get_drg_route_distribution_statements(drg_route_distribution_id=test_drg_route_distribution["id"])
    ```


    :param builtins.str drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
    """
    __args__ = dict()
    __args__['drgRouteDistributionId'] = drg_route_distribution_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgRouteDistributionStatements:getDrgRouteDistributionStatements', __args__, opts=opts, typ=GetDrgRouteDistributionStatementsResult).value

    return AwaitableGetDrgRouteDistributionStatementsResult(
        drg_route_distribution_id=pulumi.get(__ret__, 'drg_route_distribution_id'),
        drg_route_distribution_statements=pulumi.get(__ret__, 'drg_route_distribution_statements'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_drg_route_distribution_statements_output(drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDrgRouteDistributionStatementsFilterArgs', 'GetDrgRouteDistributionStatementsFilterArgsDict']]]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDrgRouteDistributionStatementsResult]:
    """
    This data source provides the list of Drg Route Distribution Statements in Oracle Cloud Infrastructure Core service.

    Lists the statements for the specified route distribution.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_distribution_statements = oci.Core.get_drg_route_distribution_statements(drg_route_distribution_id=test_drg_route_distribution["id"])
    ```


    :param builtins.str drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
    """
    __args__ = dict()
    __args__['drgRouteDistributionId'] = drg_route_distribution_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getDrgRouteDistributionStatements:getDrgRouteDistributionStatements', __args__, opts=opts, typ=GetDrgRouteDistributionStatementsResult)
    return __ret__.apply(lambda __response__: GetDrgRouteDistributionStatementsResult(
        drg_route_distribution_id=pulumi.get(__response__, 'drg_route_distribution_id'),
        drg_route_distribution_statements=pulumi.get(__response__, 'drg_route_distribution_statements'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
