# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstancePoolLoadBalancerAttachmentResult',
    'AwaitableGetInstancePoolLoadBalancerAttachmentResult',
    'get_instance_pool_load_balancer_attachment',
    'get_instance_pool_load_balancer_attachment_output',
]

@pulumi.output_type
class GetInstancePoolLoadBalancerAttachmentResult:
    """
    A collection of values returned by getInstancePoolLoadBalancerAttachment.
    """
    def __init__(__self__, backend_set_name=None, id=None, instance_pool_id=None, instance_pool_load_balancer_attachment_id=None, load_balancer_id=None, port=None, state=None, vnic_selection=None):
        if backend_set_name and not isinstance(backend_set_name, str):
            raise TypeError("Expected argument 'backend_set_name' to be a str")
        pulumi.set(__self__, "backend_set_name", backend_set_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_pool_id and not isinstance(instance_pool_id, str):
            raise TypeError("Expected argument 'instance_pool_id' to be a str")
        pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if instance_pool_load_balancer_attachment_id and not isinstance(instance_pool_load_balancer_attachment_id, str):
            raise TypeError("Expected argument 'instance_pool_load_balancer_attachment_id' to be a str")
        pulumi.set(__self__, "instance_pool_load_balancer_attachment_id", instance_pool_load_balancer_attachment_id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vnic_selection and not isinstance(vnic_selection, str):
            raise TypeError("Expected argument 'vnic_selection' to be a str")
        pulumi.set(__self__, "vnic_selection", vnic_selection)

    @property
    @pulumi.getter(name="backendSetName")
    def backend_set_name(self) -> builtins.str:
        """
        The name of the backend set on the load balancer.
        """
        return pulumi.get(self, "backend_set_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool of the load balancer attachment.
        """
        return pulumi.get(self, "instance_pool_id")

    @property
    @pulumi.getter(name="instancePoolLoadBalancerAttachmentId")
    def instance_pool_load_balancer_attachment_id(self) -> builtins.str:
        return pulumi.get(self, "instance_pool_load_balancer_attachment_id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer attached to the instance pool.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port value used for the backends.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The status of the interaction between the instance pool and the load balancer.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vnicSelection")
    def vnic_selection(self) -> builtins.str:
        """
        Indicates which VNIC on each instance in the instance pool should be used to associate with the load balancer. Possible values are "PrimaryVnic" or the displayName of one of the secondary VNICs on the instance configuration that is associated with the instance pool.
        """
        return pulumi.get(self, "vnic_selection")


class AwaitableGetInstancePoolLoadBalancerAttachmentResult(GetInstancePoolLoadBalancerAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancePoolLoadBalancerAttachmentResult(
            backend_set_name=self.backend_set_name,
            id=self.id,
            instance_pool_id=self.instance_pool_id,
            instance_pool_load_balancer_attachment_id=self.instance_pool_load_balancer_attachment_id,
            load_balancer_id=self.load_balancer_id,
            port=self.port,
            state=self.state,
            vnic_selection=self.vnic_selection)


def get_instance_pool_load_balancer_attachment(instance_pool_id: Optional[builtins.str] = None,
                                               instance_pool_load_balancer_attachment_id: Optional[builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancePoolLoadBalancerAttachmentResult:
    """
    This data source provides details about a specific Instance Pool Load Balancer Attachment resource in Oracle Cloud Infrastructure Core service.

    Gets information about a load balancer that is attached to the specified instance pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_pool_load_balancer_attachment = oci.Core.get_instance_pool_load_balancer_attachment(instance_pool_id=test_instance_pool["id"],
        instance_pool_load_balancer_attachment_id=test_instance_pool_load_balancer_attachment_oci_core_instance_pool_load_balancer_attachment["id"])
    ```


    :param builtins.str instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
    :param builtins.str instance_pool_load_balancer_attachment_id: The OCID of the load balancer attachment.
    """
    __args__ = dict()
    __args__['instancePoolId'] = instance_pool_id
    __args__['instancePoolLoadBalancerAttachmentId'] = instance_pool_load_balancer_attachment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstancePoolLoadBalancerAttachment:getInstancePoolLoadBalancerAttachment', __args__, opts=opts, typ=GetInstancePoolLoadBalancerAttachmentResult).value

    return AwaitableGetInstancePoolLoadBalancerAttachmentResult(
        backend_set_name=pulumi.get(__ret__, 'backend_set_name'),
        id=pulumi.get(__ret__, 'id'),
        instance_pool_id=pulumi.get(__ret__, 'instance_pool_id'),
        instance_pool_load_balancer_attachment_id=pulumi.get(__ret__, 'instance_pool_load_balancer_attachment_id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        port=pulumi.get(__ret__, 'port'),
        state=pulumi.get(__ret__, 'state'),
        vnic_selection=pulumi.get(__ret__, 'vnic_selection'))
def get_instance_pool_load_balancer_attachment_output(instance_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      instance_pool_load_balancer_attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancePoolLoadBalancerAttachmentResult]:
    """
    This data source provides details about a specific Instance Pool Load Balancer Attachment resource in Oracle Cloud Infrastructure Core service.

    Gets information about a load balancer that is attached to the specified instance pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_pool_load_balancer_attachment = oci.Core.get_instance_pool_load_balancer_attachment(instance_pool_id=test_instance_pool["id"],
        instance_pool_load_balancer_attachment_id=test_instance_pool_load_balancer_attachment_oci_core_instance_pool_load_balancer_attachment["id"])
    ```


    :param builtins.str instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
    :param builtins.str instance_pool_load_balancer_attachment_id: The OCID of the load balancer attachment.
    """
    __args__ = dict()
    __args__['instancePoolId'] = instance_pool_id
    __args__['instancePoolLoadBalancerAttachmentId'] = instance_pool_load_balancer_attachment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstancePoolLoadBalancerAttachment:getInstancePoolLoadBalancerAttachment', __args__, opts=opts, typ=GetInstancePoolLoadBalancerAttachmentResult)
    return __ret__.apply(lambda __response__: GetInstancePoolLoadBalancerAttachmentResult(
        backend_set_name=pulumi.get(__response__, 'backend_set_name'),
        id=pulumi.get(__response__, 'id'),
        instance_pool_id=pulumi.get(__response__, 'instance_pool_id'),
        instance_pool_load_balancer_attachment_id=pulumi.get(__response__, 'instance_pool_load_balancer_attachment_id'),
        load_balancer_id=pulumi.get(__response__, 'load_balancer_id'),
        port=pulumi.get(__response__, 'port'),
        state=pulumi.get(__response__, 'state'),
        vnic_selection=pulumi.get(__response__, 'vnic_selection')))
