# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VcnArgs', 'Vcn']

@pulumi.input_type
class VcnArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 byoipv6cidr_details: Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ipv6private_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_ipv6enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_oracle_gua_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Vcn resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        :param pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]] byoipv6cidr_details: The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        :param pulumi.Input[builtins.str] cidr_block: **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
               * The CIDR blocks must be valid.
               * They must not overlap with each other or with the on-premises network CIDR block.
               * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
               **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_label: A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
               You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `vcn1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6private_cidr_blocks: The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
               * The CIDR blocks must be valid.
               * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
               * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.
               
               **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.bool] is_ipv6enabled: Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        :param pulumi.Input[builtins.bool] is_oracle_gua_allocation_enabled: Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if byoipv6cidr_details is not None:
            pulumi.set(__self__, "byoipv6cidr_details", byoipv6cidr_details)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_label is not None:
            pulumi.set(__self__, "dns_label", dns_label)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ipv6private_cidr_blocks is not None:
            pulumi.set(__self__, "ipv6private_cidr_blocks", ipv6private_cidr_blocks)
        if is_ipv6enabled is not None:
            pulumi.set(__self__, "is_ipv6enabled", is_ipv6enabled)
        if is_oracle_gua_allocation_enabled is not None:
            pulumi.set(__self__, "is_oracle_gua_allocation_enabled", is_oracle_gua_allocation_enabled)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="byoipv6cidrDetails")
    def byoipv6cidr_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]]:
        """
        The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        """
        return pulumi.get(self, "byoipv6cidr_details")

    @byoipv6cidr_details.setter
    def byoipv6cidr_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]]):
        pulumi.set(self, "byoipv6cidr_details", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
        * The CIDR blocks must be valid.
        * They must not overlap with each other or with the on-premises network CIDR block.
        * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
        **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidr_blocks", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
        You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `vcn1`
        """
        return pulumi.get(self, "dns_label")

    @dns_label.setter
    def dns_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_label", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipv6privateCidrBlocks")
    def ipv6private_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
        * The CIDR blocks must be valid.
        * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
        * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.

        **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "ipv6private_cidr_blocks")

    @ipv6private_cidr_blocks.setter
    def ipv6private_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6private_cidr_blocks", value)

    @property
    @pulumi.getter(name="isIpv6enabled")
    def is_ipv6enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        """
        return pulumi.get(self, "is_ipv6enabled")

    @is_ipv6enabled.setter
    def is_ipv6enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ipv6enabled", value)

    @property
    @pulumi.getter(name="isOracleGuaAllocationEnabled")
    def is_oracle_gua_allocation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        """
        return pulumi.get(self, "is_oracle_gua_allocation_enabled")

    @is_oracle_gua_allocation_enabled.setter
    def is_oracle_gua_allocation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_oracle_gua_allocation_enabled", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)


@pulumi.input_type
class _VcnState:
    def __init__(__self__, *,
                 byoipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 byoipv6cidr_details: Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_dhcp_options_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_security_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6private_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_ipv6enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_oracle_gua_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 vcn_domain_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Vcn resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] byoipv6cidr_blocks: The list of BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 ranges.
        :param pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]] byoipv6cidr_details: The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        :param pulumi.Input[builtins.str] cidr_block: **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
               * The CIDR blocks must be valid.
               * They must not overlap with each other or with the on-premises network CIDR block.
               * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
               **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        :param pulumi.Input[builtins.str] default_dhcp_options_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default set of DHCP options.
        :param pulumi.Input[builtins.str] default_route_table_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default route table.
        :param pulumi.Input[builtins.str] default_security_list_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default security list.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_label: A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
               You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `vcn1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6cidr_blocks: For an IPv6-enabled VCN, this is the list of IPv6 prefixes for the VCN's IP address space. The prefixes are provided by Oracle and the sizes are always /56.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6private_cidr_blocks: The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
               * The CIDR blocks must be valid.
               * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
               * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.
               
               **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.bool] is_ipv6enabled: Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        :param pulumi.Input[builtins.bool] is_oracle_gua_allocation_enabled: Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The VCN's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the VCN was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vcn_domain_name: The VCN's domain name, which consists of the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        if byoipv6cidr_blocks is not None:
            pulumi.set(__self__, "byoipv6cidr_blocks", byoipv6cidr_blocks)
        if byoipv6cidr_details is not None:
            pulumi.set(__self__, "byoipv6cidr_details", byoipv6cidr_details)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if default_dhcp_options_id is not None:
            pulumi.set(__self__, "default_dhcp_options_id", default_dhcp_options_id)
        if default_route_table_id is not None:
            pulumi.set(__self__, "default_route_table_id", default_route_table_id)
        if default_security_list_id is not None:
            pulumi.set(__self__, "default_security_list_id", default_security_list_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_label is not None:
            pulumi.set(__self__, "dns_label", dns_label)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ipv6cidr_blocks is not None:
            pulumi.set(__self__, "ipv6cidr_blocks", ipv6cidr_blocks)
        if ipv6private_cidr_blocks is not None:
            pulumi.set(__self__, "ipv6private_cidr_blocks", ipv6private_cidr_blocks)
        if is_ipv6enabled is not None:
            pulumi.set(__self__, "is_ipv6enabled", is_ipv6enabled)
        if is_oracle_gua_allocation_enabled is not None:
            pulumi.set(__self__, "is_oracle_gua_allocation_enabled", is_oracle_gua_allocation_enabled)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vcn_domain_name is not None:
            pulumi.set(__self__, "vcn_domain_name", vcn_domain_name)

    @property
    @pulumi.getter(name="byoipv6cidrBlocks")
    def byoipv6cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 ranges.
        """
        return pulumi.get(self, "byoipv6cidr_blocks")

    @byoipv6cidr_blocks.setter
    def byoipv6cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "byoipv6cidr_blocks", value)

    @property
    @pulumi.getter(name="byoipv6cidrDetails")
    def byoipv6cidr_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]]:
        """
        The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        """
        return pulumi.get(self, "byoipv6cidr_details")

    @byoipv6cidr_details.setter
    def byoipv6cidr_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VcnByoipv6cidrDetailArgs']]]]):
        pulumi.set(self, "byoipv6cidr_details", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
        * The CIDR blocks must be valid.
        * They must not overlap with each other or with the on-premises network CIDR block.
        * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
        **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cidr_blocks", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="defaultDhcpOptionsId")
    def default_dhcp_options_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default set of DHCP options.
        """
        return pulumi.get(self, "default_dhcp_options_id")

    @default_dhcp_options_id.setter
    def default_dhcp_options_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_dhcp_options_id", value)

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default route table.
        """
        return pulumi.get(self, "default_route_table_id")

    @default_route_table_id.setter
    def default_route_table_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_route_table_id", value)

    @property
    @pulumi.getter(name="defaultSecurityListId")
    def default_security_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default security list.
        """
        return pulumi.get(self, "default_security_list_id")

    @default_security_list_id.setter
    def default_security_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_security_list_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
        You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `vcn1`
        """
        return pulumi.get(self, "dns_label")

    @dns_label.setter
    def dns_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_label", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipv6cidrBlocks")
    def ipv6cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        For an IPv6-enabled VCN, this is the list of IPv6 prefixes for the VCN's IP address space. The prefixes are provided by Oracle and the sizes are always /56.
        """
        return pulumi.get(self, "ipv6cidr_blocks")

    @ipv6cidr_blocks.setter
    def ipv6cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6cidr_blocks", value)

    @property
    @pulumi.getter(name="ipv6privateCidrBlocks")
    def ipv6private_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
        * The CIDR blocks must be valid.
        * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
        * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.

        **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "ipv6private_cidr_blocks")

    @ipv6private_cidr_blocks.setter
    def ipv6private_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv6private_cidr_blocks", value)

    @property
    @pulumi.getter(name="isIpv6enabled")
    def is_ipv6enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        """
        return pulumi.get(self, "is_ipv6enabled")

    @is_ipv6enabled.setter
    def is_ipv6enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ipv6enabled", value)

    @property
    @pulumi.getter(name="isOracleGuaAllocationEnabled")
    def is_oracle_gua_allocation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        """
        return pulumi.get(self, "is_oracle_gua_allocation_enabled")

    @is_oracle_gua_allocation_enabled.setter
    def is_oracle_gua_allocation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_oracle_gua_allocation_enabled", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VCN's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the VCN was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vcnDomainName")
    def vcn_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VCN's domain name, which consists of the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        return pulumi.get(self, "vcn_domain_name")

    @vcn_domain_name.setter
    def vcn_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vcn_domain_name", value)


@pulumi.type_token("oci:Core/vcn:Vcn")
class Vcn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byoipv6cidr_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VcnByoipv6cidrDetailArgs', 'VcnByoipv6cidrDetailArgsDict']]]]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ipv6private_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_ipv6enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_oracle_gua_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Vcn resource in Oracle Cloud Infrastructure Core service.

        The VCN automatically comes with a default route table, default security list, and default set of DHCP options.
        For managing these resources, see [Managing Default VCN Resources](https://www.terraform.io/docs/providers/oci/guides/managing_default_resources.html)

        Creates a new Virtual Cloud Network (VCN). For more information, see
        [VCNs and Subnets](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVCNs.htm).

        For the VCN, you specify a list of one or more IPv4 CIDR blocks that meet the following criteria:

        - The CIDR blocks must be valid.
        - They must not overlap with each other or with the on-premises network CIDR block.
        - The number of CIDR blocks does not exceed the limit of CIDR blocks allowed per VCN.

        For a CIDR block, Oracle recommends that you use one of the private IP address ranges specified in [RFC 1918](https://tools.ietf.org/html/rfc1918) (10.0.0.0/8, 172.16/12, and 192.168/16). Example:
        172.16.0.0/16. The CIDR blocks can range from /16 to /30.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the VCN to
        reside. Consult an Oracle Cloud Infrastructure administrator in your organization if you're not sure which
        compartment to use. Notice that the VCN doesn't have to be in the same compartment as the subnets or other
        Networking Service components. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VCN, otherwise a default is provided. It does not have to
        be unique, and you can change it. Avoid entering confidential information.

        You can also add a DNS label for the VCN, which is required if you want the instances to use the
        Interent and VCN Resolver option for DNS in the VCN. For more information, see
        [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        The VCN automatically comes with a default route table, default security list, and default set of DHCP options.
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for each is returned in the response. You can't delete these default objects, but you can change their
        contents (that is, change the route rules, security list rules, and so on).

        The VCN and subnets you create are not accessible until you attach an internet gateway or set up a Site-to-Site VPN
        or FastConnect. For more information, see
        [Overview of the Networking Service](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/overview.htm).

        ## Supported Aliases

        * `Core.VirtualNetwork`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vcn = oci.core.Vcn("test_vcn",
            compartment_id=compartment_id,
            byoipv6cidr_details=[{
                "byoipv6range_id": test_byoipv6range["id"],
                "ipv6cidr_block": vcn_byoipv6cidr_details_ipv6cidr_block,
            }],
            cidr_block=vcn_cidr_block,
            cidr_blocks=vcn_cidr_blocks,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=vcn_display_name,
            dns_label=vcn_dns_label,
            freeform_tags={
                "Department": "Finance",
            },
            ipv6private_cidr_blocks=vcn_ipv6private_cidr_blocks,
            is_ipv6enabled=vcn_is_ipv6enabled,
            is_oracle_gua_allocation_enabled=vcn_is_oracle_gua_allocation_enabled,
            security_attributes=vcn_security_attributes)
        ```

        ## Import

        Vcns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/vcn:Vcn test_vcn "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VcnByoipv6cidrDetailArgs', 'VcnByoipv6cidrDetailArgsDict']]]] byoipv6cidr_details: The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        :param pulumi.Input[builtins.str] cidr_block: **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
               * The CIDR blocks must be valid.
               * They must not overlap with each other or with the on-premises network CIDR block.
               * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
               **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_label: A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
               You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `vcn1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6private_cidr_blocks: The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
               * The CIDR blocks must be valid.
               * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
               * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.
               
               **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.bool] is_ipv6enabled: Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        :param pulumi.Input[builtins.bool] is_oracle_gua_allocation_enabled: Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VcnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vcn resource in Oracle Cloud Infrastructure Core service.

        The VCN automatically comes with a default route table, default security list, and default set of DHCP options.
        For managing these resources, see [Managing Default VCN Resources](https://www.terraform.io/docs/providers/oci/guides/managing_default_resources.html)

        Creates a new Virtual Cloud Network (VCN). For more information, see
        [VCNs and Subnets](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVCNs.htm).

        For the VCN, you specify a list of one or more IPv4 CIDR blocks that meet the following criteria:

        - The CIDR blocks must be valid.
        - They must not overlap with each other or with the on-premises network CIDR block.
        - The number of CIDR blocks does not exceed the limit of CIDR blocks allowed per VCN.

        For a CIDR block, Oracle recommends that you use one of the private IP address ranges specified in [RFC 1918](https://tools.ietf.org/html/rfc1918) (10.0.0.0/8, 172.16/12, and 192.168/16). Example:
        172.16.0.0/16. The CIDR blocks can range from /16 to /30.

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the VCN to
        reside. Consult an Oracle Cloud Infrastructure administrator in your organization if you're not sure which
        compartment to use. Notice that the VCN doesn't have to be in the same compartment as the subnets or other
        Networking Service components. For more information about compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm). For information about OCIDs, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        You may optionally specify a *display name* for the VCN, otherwise a default is provided. It does not have to
        be unique, and you can change it. Avoid entering confidential information.

        You can also add a DNS label for the VCN, which is required if you want the instances to use the
        Interent and VCN Resolver option for DNS in the VCN. For more information, see
        [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        The VCN automatically comes with a default route table, default security list, and default set of DHCP options.
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for each is returned in the response. You can't delete these default objects, but you can change their
        contents (that is, change the route rules, security list rules, and so on).

        The VCN and subnets you create are not accessible until you attach an internet gateway or set up a Site-to-Site VPN
        or FastConnect. For more information, see
        [Overview of the Networking Service](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/overview.htm).

        ## Supported Aliases

        * `Core.VirtualNetwork`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vcn = oci.core.Vcn("test_vcn",
            compartment_id=compartment_id,
            byoipv6cidr_details=[{
                "byoipv6range_id": test_byoipv6range["id"],
                "ipv6cidr_block": vcn_byoipv6cidr_details_ipv6cidr_block,
            }],
            cidr_block=vcn_cidr_block,
            cidr_blocks=vcn_cidr_blocks,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=vcn_display_name,
            dns_label=vcn_dns_label,
            freeform_tags={
                "Department": "Finance",
            },
            ipv6private_cidr_blocks=vcn_ipv6private_cidr_blocks,
            is_ipv6enabled=vcn_is_ipv6enabled,
            is_oracle_gua_allocation_enabled=vcn_is_oracle_gua_allocation_enabled,
            security_attributes=vcn_security_attributes)
        ```

        ## Import

        Vcns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/vcn:Vcn test_vcn "id"
        ```

        :param str resource_name: The name of the resource.
        :param VcnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VcnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byoipv6cidr_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VcnByoipv6cidrDetailArgs', 'VcnByoipv6cidrDetailArgsDict']]]]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dns_label: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ipv6private_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_ipv6enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_oracle_gua_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VcnArgs.__new__(VcnArgs)

            __props__.__dict__["byoipv6cidr_details"] = byoipv6cidr_details
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["cidr_blocks"] = cidr_blocks
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dns_label"] = dns_label
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ipv6private_cidr_blocks"] = ipv6private_cidr_blocks
            __props__.__dict__["is_ipv6enabled"] = is_ipv6enabled
            __props__.__dict__["is_oracle_gua_allocation_enabled"] = is_oracle_gua_allocation_enabled
            __props__.__dict__["security_attributes"] = security_attributes
            __props__.__dict__["byoipv6cidr_blocks"] = None
            __props__.__dict__["default_dhcp_options_id"] = None
            __props__.__dict__["default_route_table_id"] = None
            __props__.__dict__["default_security_list_id"] = None
            __props__.__dict__["ipv6cidr_blocks"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vcn_domain_name"] = None
        super(Vcn, __self__).__init__(
            'oci:Core/vcn:Vcn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            byoipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            byoipv6cidr_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VcnByoipv6cidrDetailArgs', 'VcnByoipv6cidrDetailArgsDict']]]]] = None,
            cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            default_dhcp_options_id: Optional[pulumi.Input[builtins.str]] = None,
            default_route_table_id: Optional[pulumi.Input[builtins.str]] = None,
            default_security_list_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dns_label: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ipv6cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6private_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            is_ipv6enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_oracle_gua_allocation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            vcn_domain_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Vcn':
        """
        Get an existing Vcn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] byoipv6cidr_blocks: The list of BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 ranges.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VcnByoipv6cidrDetailArgs', 'VcnByoipv6cidrDetailArgsDict']]]] byoipv6cidr_details: The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        :param pulumi.Input[builtins.str] cidr_block: **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cidr_blocks: (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
               * The CIDR blocks must be valid.
               * They must not overlap with each other or with the on-premises network CIDR block.
               * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
               **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        :param pulumi.Input[builtins.str] default_dhcp_options_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default set of DHCP options.
        :param pulumi.Input[builtins.str] default_route_table_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default route table.
        :param pulumi.Input[builtins.str] default_security_list_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default security list.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] dns_label: A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
               You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `vcn1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6cidr_blocks: For an IPv6-enabled VCN, this is the list of IPv6 prefixes for the VCN's IP address space. The prefixes are provided by Oracle and the sizes are always /56.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv6private_cidr_blocks: The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
               * The CIDR blocks must be valid.
               * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
               * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.
               
               **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        :param pulumi.Input[builtins.bool] is_ipv6enabled: Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        :param pulumi.Input[builtins.bool] is_oracle_gua_allocation_enabled: Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The VCN's current state.
        :param pulumi.Input[builtins.str] time_created: The date and time the VCN was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] vcn_domain_name: The VCN's domain name, which consists of the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VcnState.__new__(_VcnState)

        __props__.__dict__["byoipv6cidr_blocks"] = byoipv6cidr_blocks
        __props__.__dict__["byoipv6cidr_details"] = byoipv6cidr_details
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["cidr_blocks"] = cidr_blocks
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["default_dhcp_options_id"] = default_dhcp_options_id
        __props__.__dict__["default_route_table_id"] = default_route_table_id
        __props__.__dict__["default_security_list_id"] = default_security_list_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_label"] = dns_label
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ipv6cidr_blocks"] = ipv6cidr_blocks
        __props__.__dict__["ipv6private_cidr_blocks"] = ipv6private_cidr_blocks
        __props__.__dict__["is_ipv6enabled"] = is_ipv6enabled
        __props__.__dict__["is_oracle_gua_allocation_enabled"] = is_oracle_gua_allocation_enabled
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vcn_domain_name"] = vcn_domain_name
        return Vcn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="byoipv6cidrBlocks")
    def byoipv6cidr_blocks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 ranges.
        """
        return pulumi.get(self, "byoipv6cidr_blocks")

    @property
    @pulumi.getter(name="byoipv6cidrDetails")
    def byoipv6cidr_details(self) -> pulumi.Output[Sequence['outputs.VcnByoipv6cidrDetail']]:
        """
        The list of BYOIPv6 OCIDs and BYOIPv6 prefixes required to create a VCN that uses BYOIPv6 address ranges.
        """
        return pulumi.get(self, "byoipv6cidr_details")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[builtins.str]:
        """
        **Deprecated.** Do *not* set this value. Use `cidr_blocks` instead. Example: `10.0.0.0/16`
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) The list of one or more IPv4 CIDR blocks for the VCN that meet the following criteria:
        * The CIDR blocks must be valid.
        * They must not overlap with each other or with the on-premises network CIDR block.
        * The number of CIDR blocks must not exceed the limit of CIDR blocks allowed per VCN. It is an error to set both cidr_block and cidr_blocks. Note: cidr_blocks update must be restricted to one operation at a time (either add/remove or modify one single cidr_block) or the operation will be declined. new cidr_block to be added must be placed at the end of the list. Once you migrate to using `cidr_blocks` from `cidr_block`, you will not be able to switch back.
        **Important:** Do *not* specify a value for `cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "cidr_blocks")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the VCN.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultDhcpOptionsId")
    def default_dhcp_options_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default set of DHCP options.
        """
        return pulumi.get(self, "default_dhcp_options_id")

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default route table.
        """
        return pulumi.get(self, "default_route_table_id")

    @property
    @pulumi.getter(name="defaultSecurityListId")
    def default_security_list_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the VCN's default security list.
        """
        return pulumi.get(self, "default_security_list_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsLabel")
    def dns_label(self) -> pulumi.Output[builtins.str]:
        """
        A DNS label for the VCN, used in conjunction with the VNIC's hostname and subnet's DNS label to form a fully qualified domain name (FQDN) for each VNIC within this subnet (for example, `bminstance1.subnet123.vcn1.oraclevcn.com`). Not required to be unique, but it's a best practice to set unique DNS labels for VCNs in your tenancy. Must be an alphanumeric string that begins with a letter. The value cannot be changed.
        You must set this value if you want instances to be able to use hostnames to resolve other instances in the VCN. Otherwise the Internet and VCN Resolver will not work.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `vcn1`
        """
        return pulumi.get(self, "dns_label")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ipv6cidrBlocks")
    def ipv6cidr_blocks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        For an IPv6-enabled VCN, this is the list of IPv6 prefixes for the VCN's IP address space. The prefixes are provided by Oracle and the sizes are always /56.
        """
        return pulumi.get(self, "ipv6cidr_blocks")

    @property
    @pulumi.getter(name="ipv6privateCidrBlocks")
    def ipv6private_cidr_blocks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of one or more ULA or Private IPv6 CIDR blocks for the vcn that meets the following criteria:
        * The CIDR blocks must be valid.
        * Multiple CIDR blocks must not overlap each other or the on-premises network prefix.
        * The number of CIDR blocks must not exceed the limit of IPv6 prefixes allowed to a VCN.

        **Important:** Do *not* specify a value for `ipv6cidr_block`. Use this parameter instead.
        """
        return pulumi.get(self, "ipv6private_cidr_blocks")

    @property
    @pulumi.getter(name="isIpv6enabled")
    def is_ipv6enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether IPv6 is enabled for the VCN. Default is `false`. If enabled, Oracle will assign the VCN a IPv6 /56 CIDR block. You may skip having Oracle allocate the VCN a IPv6 /56 CIDR block by setting isOracleGuaAllocationEnabled to `false`. For important details about IPv6 addressing in a VCN, see [IPv6 Addresses](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/ipv6.htm).  Example: `true`
        """
        return pulumi.get(self, "is_ipv6enabled")

    @property
    @pulumi.getter(name="isOracleGuaAllocationEnabled")
    def is_oracle_gua_allocation_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether to skip Oracle allocated IPv6 GUA. By default, Oracle will allocate one GUA of /56 size for an IPv6 enabled VCN.
        """
        return pulumi.get(self, "is_oracle_gua_allocation_enabled")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Security Attributes for this resource. This is unique to ZPR, and helps identify which resources are allowed to be accessed by what permission controls.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The VCN's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the VCN was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnDomainName")
    def vcn_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The VCN's domain name, which consists of the VCN's DNS label, and the `oraclevcn.com` domain.
        """
        return pulumi.get(self, "vcn_domain_name")

