# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseRefreshableClonesResult',
    'AwaitableGetAutonomousDatabaseRefreshableClonesResult',
    'get_autonomous_database_refreshable_clones',
    'get_autonomous_database_refreshable_clones_output',
]

@pulumi.output_type
class GetAutonomousDatabaseRefreshableClonesResult:
    """
    A collection of values returned by getAutonomousDatabaseRefreshableClones.
    """
    def __init__(__self__, autonomous_database_id=None, filters=None, id=None, refreshable_clone_collections=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if refreshable_clone_collections and not isinstance(refreshable_clone_collections, list):
            raise TypeError("Expected argument 'refreshable_clone_collections' to be a list")
        pulumi.set(__self__, "refreshable_clone_collections", refreshable_clone_collections)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> builtins.str:
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseRefreshableClonesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="refreshableCloneCollections")
    def refreshable_clone_collections(self) -> Sequence['outputs.GetAutonomousDatabaseRefreshableClonesRefreshableCloneCollectionResult']:
        """
        The list of refreshable_clone_collection.
        """
        return pulumi.get(self, "refreshable_clone_collections")


class AwaitableGetAutonomousDatabaseRefreshableClonesResult(GetAutonomousDatabaseRefreshableClonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseRefreshableClonesResult(
            autonomous_database_id=self.autonomous_database_id,
            filters=self.filters,
            id=self.id,
            refreshable_clone_collections=self.refreshable_clone_collections)


def get_autonomous_database_refreshable_clones(autonomous_database_id: Optional[builtins.str] = None,
                                               filters: Optional[Sequence[Union['GetAutonomousDatabaseRefreshableClonesFilterArgs', 'GetAutonomousDatabaseRefreshableClonesFilterArgsDict']]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseRefreshableClonesResult:
    """
    This data source provides the list of Autonomous Database Refreshable Clones in Oracle Cloud Infrastructure Database service.

    Lists the OCIDs of the Autonomous Database local and connected remote refreshable clones with the region where they exist for the specified source database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_refreshable_clones = oci.Database.get_autonomous_database_refreshable_clones(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseRefreshableClones:getAutonomousDatabaseRefreshableClones', __args__, opts=opts, typ=GetAutonomousDatabaseRefreshableClonesResult).value

    return AwaitableGetAutonomousDatabaseRefreshableClonesResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        refreshable_clone_collections=pulumi.get(__ret__, 'refreshable_clone_collections'))
def get_autonomous_database_refreshable_clones_output(autonomous_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabaseRefreshableClonesFilterArgs', 'GetAutonomousDatabaseRefreshableClonesFilterArgsDict']]]]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseRefreshableClonesResult]:
    """
    This data source provides the list of Autonomous Database Refreshable Clones in Oracle Cloud Infrastructure Database service.

    Lists the OCIDs of the Autonomous Database local and connected remote refreshable clones with the region where they exist for the specified source database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_refreshable_clones = oci.Database.get_autonomous_database_refreshable_clones(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param builtins.str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseRefreshableClones:getAutonomousDatabaseRefreshableClones', __args__, opts=opts, typ=GetAutonomousDatabaseRefreshableClonesResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseRefreshableClonesResult(
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        refreshable_clone_collections=pulumi.get(__response__, 'refreshable_clone_collections')))
