# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudAutonomousVmClusterResult',
    'AwaitableGetCloudAutonomousVmClusterResult',
    'get_cloud_autonomous_vm_cluster',
    'get_cloud_autonomous_vm_cluster_output',
]

@pulumi.output_type
class GetCloudAutonomousVmClusterResult:
    """
    A collection of values returned by getCloudAutonomousVmCluster.
    """
    def __init__(__self__, autonomous_data_storage_percentage=None, autonomous_data_storage_size_in_tbs=None, availability_domain=None, available_autonomous_data_storage_size_in_tbs=None, available_container_databases=None, available_cpus=None, cloud_autonomous_vm_cluster_id=None, cloud_exadata_infrastructure_id=None, cluster_time_zone=None, compartment_id=None, compute_model=None, cpu_core_count=None, cpu_core_count_per_node=None, cpu_percentage=None, data_storage_size_in_gb=None, data_storage_size_in_tbs=None, db_node_storage_size_in_gbs=None, db_servers=None, defined_tags=None, description=None, display_name=None, domain=None, exadata_storage_in_tbs_lowest_scaled_value=None, freeform_tags=None, hostname=None, id=None, is_mtls_enabled_vm_cluster=None, last_maintenance_run_id=None, last_update_history_entry_id=None, license_model=None, lifecycle_details=None, maintenance_window_details=None, maintenance_windows=None, max_acds_lowest_scaled_value=None, memory_per_oracle_compute_unit_in_gbs=None, memory_size_in_gbs=None, next_maintenance_run_id=None, node_count=None, non_provisionable_autonomous_container_databases=None, nsg_ids=None, ocpu_count=None, ocpus_lowest_scaled_value=None, opc_dry_run=None, provisionable_autonomous_container_databases=None, provisioned_autonomous_container_databases=None, provisioned_cpus=None, reclaimable_cpus=None, reserved_cpus=None, scan_listener_port_non_tls=None, scan_listener_port_tls=None, security_attributes=None, shape=None, state=None, subnet_id=None, subscription_id=None, system_tags=None, time_created=None, time_database_ssl_certificate_expires=None, time_ords_certificate_expires=None, time_updated=None, total_autonomous_data_storage_in_tbs=None, total_container_databases=None, total_cpus=None):
        if autonomous_data_storage_percentage and not isinstance(autonomous_data_storage_percentage, float):
            raise TypeError("Expected argument 'autonomous_data_storage_percentage' to be a float")
        pulumi.set(__self__, "autonomous_data_storage_percentage", autonomous_data_storage_percentage)
        if autonomous_data_storage_size_in_tbs and not isinstance(autonomous_data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'autonomous_data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if available_autonomous_data_storage_size_in_tbs and not isinstance(available_autonomous_data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'available_autonomous_data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "available_autonomous_data_storage_size_in_tbs", available_autonomous_data_storage_size_in_tbs)
        if available_container_databases and not isinstance(available_container_databases, int):
            raise TypeError("Expected argument 'available_container_databases' to be a int")
        pulumi.set(__self__, "available_container_databases", available_container_databases)
        if available_cpus and not isinstance(available_cpus, float):
            raise TypeError("Expected argument 'available_cpus' to be a float")
        pulumi.set(__self__, "available_cpus", available_cpus)
        if cloud_autonomous_vm_cluster_id and not isinstance(cloud_autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_time_zone and not isinstance(cluster_time_zone, str):
            raise TypeError("Expected argument 'cluster_time_zone' to be a str")
        pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model and not isinstance(compute_model, str):
            raise TypeError("Expected argument 'compute_model' to be a str")
        pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpu_core_count_per_node and not isinstance(cpu_core_count_per_node, int):
            raise TypeError("Expected argument 'cpu_core_count_per_node' to be a int")
        pulumi.set(__self__, "cpu_core_count_per_node", cpu_core_count_per_node)
        if cpu_percentage and not isinstance(cpu_percentage, float):
            raise TypeError("Expected argument 'cpu_percentage' to be a float")
        pulumi.set(__self__, "cpu_percentage", cpu_percentage)
        if data_storage_size_in_gb and not isinstance(data_storage_size_in_gb, float):
            raise TypeError("Expected argument 'data_storage_size_in_gb' to be a float")
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if exadata_storage_in_tbs_lowest_scaled_value and not isinstance(exadata_storage_in_tbs_lowest_scaled_value, float):
            raise TypeError("Expected argument 'exadata_storage_in_tbs_lowest_scaled_value' to be a float")
        pulumi.set(__self__, "exadata_storage_in_tbs_lowest_scaled_value", exadata_storage_in_tbs_lowest_scaled_value)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_mtls_enabled_vm_cluster and not isinstance(is_mtls_enabled_vm_cluster, bool):
            raise TypeError("Expected argument 'is_mtls_enabled_vm_cluster' to be a bool")
        pulumi.set(__self__, "is_mtls_enabled_vm_cluster", is_mtls_enabled_vm_cluster)
        if last_maintenance_run_id and not isinstance(last_maintenance_run_id, str):
            raise TypeError("Expected argument 'last_maintenance_run_id' to be a str")
        pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if last_update_history_entry_id and not isinstance(last_update_history_entry_id, str):
            raise TypeError("Expected argument 'last_update_history_entry_id' to be a str")
        pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window_details and not isinstance(maintenance_window_details, list):
            raise TypeError("Expected argument 'maintenance_window_details' to be a list")
        pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_acds_lowest_scaled_value and not isinstance(max_acds_lowest_scaled_value, int):
            raise TypeError("Expected argument 'max_acds_lowest_scaled_value' to be a int")
        pulumi.set(__self__, "max_acds_lowest_scaled_value", max_acds_lowest_scaled_value)
        if memory_per_oracle_compute_unit_in_gbs and not isinstance(memory_per_oracle_compute_unit_in_gbs, int):
            raise TypeError("Expected argument 'memory_per_oracle_compute_unit_in_gbs' to be a int")
        pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if next_maintenance_run_id and not isinstance(next_maintenance_run_id, str):
            raise TypeError("Expected argument 'next_maintenance_run_id' to be a str")
        pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if non_provisionable_autonomous_container_databases and not isinstance(non_provisionable_autonomous_container_databases, int):
            raise TypeError("Expected argument 'non_provisionable_autonomous_container_databases' to be a int")
        pulumi.set(__self__, "non_provisionable_autonomous_container_databases", non_provisionable_autonomous_container_databases)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count and not isinstance(ocpu_count, float):
            raise TypeError("Expected argument 'ocpu_count' to be a float")
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        if ocpus_lowest_scaled_value and not isinstance(ocpus_lowest_scaled_value, int):
            raise TypeError("Expected argument 'ocpus_lowest_scaled_value' to be a int")
        pulumi.set(__self__, "ocpus_lowest_scaled_value", ocpus_lowest_scaled_value)
        if opc_dry_run and not isinstance(opc_dry_run, bool):
            raise TypeError("Expected argument 'opc_dry_run' to be a bool")
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if provisionable_autonomous_container_databases and not isinstance(provisionable_autonomous_container_databases, int):
            raise TypeError("Expected argument 'provisionable_autonomous_container_databases' to be a int")
        pulumi.set(__self__, "provisionable_autonomous_container_databases", provisionable_autonomous_container_databases)
        if provisioned_autonomous_container_databases and not isinstance(provisioned_autonomous_container_databases, int):
            raise TypeError("Expected argument 'provisioned_autonomous_container_databases' to be a int")
        pulumi.set(__self__, "provisioned_autonomous_container_databases", provisioned_autonomous_container_databases)
        if provisioned_cpus and not isinstance(provisioned_cpus, float):
            raise TypeError("Expected argument 'provisioned_cpus' to be a float")
        pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus and not isinstance(reclaimable_cpus, float):
            raise TypeError("Expected argument 'reclaimable_cpus' to be a float")
        pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if reserved_cpus and not isinstance(reserved_cpus, float):
            raise TypeError("Expected argument 'reserved_cpus' to be a float")
        pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if scan_listener_port_non_tls and not isinstance(scan_listener_port_non_tls, int):
            raise TypeError("Expected argument 'scan_listener_port_non_tls' to be a int")
        pulumi.set(__self__, "scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls and not isinstance(scan_listener_port_tls, int):
            raise TypeError("Expected argument 'scan_listener_port_tls' to be a int")
        pulumi.set(__self__, "scan_listener_port_tls", scan_listener_port_tls)
        if security_attributes and not isinstance(security_attributes, dict):
            raise TypeError("Expected argument 'security_attributes' to be a dict")
        pulumi.set(__self__, "security_attributes", security_attributes)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_database_ssl_certificate_expires and not isinstance(time_database_ssl_certificate_expires, str):
            raise TypeError("Expected argument 'time_database_ssl_certificate_expires' to be a str")
        pulumi.set(__self__, "time_database_ssl_certificate_expires", time_database_ssl_certificate_expires)
        if time_ords_certificate_expires and not isinstance(time_ords_certificate_expires, str):
            raise TypeError("Expected argument 'time_ords_certificate_expires' to be a str")
        pulumi.set(__self__, "time_ords_certificate_expires", time_ords_certificate_expires)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if total_autonomous_data_storage_in_tbs and not isinstance(total_autonomous_data_storage_in_tbs, float):
            raise TypeError("Expected argument 'total_autonomous_data_storage_in_tbs' to be a float")
        pulumi.set(__self__, "total_autonomous_data_storage_in_tbs", total_autonomous_data_storage_in_tbs)
        if total_container_databases and not isinstance(total_container_databases, int):
            raise TypeError("Expected argument 'total_container_databases' to be a int")
        pulumi.set(__self__, "total_container_databases", total_container_databases)
        if total_cpus and not isinstance(total_cpus, float):
            raise TypeError("Expected argument 'total_cpus' to be a float")
        pulumi.set(__self__, "total_cpus", total_cpus)

    @property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> builtins.float:
        """
        The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> builtins.float:
        """
        The data disk group size allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain that the cloud Autonomous VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> builtins.float:
        """
        The data disk group size available for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> builtins.int:
        """
        The number of Autonomous Container Databases that can be created with the currently available local storage.
        """
        return pulumi.get(self, "available_container_databases")

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> builtins.float:
        """
        CPU cores available for allocation to Autonomous Databases.
        """
        return pulumi.get(self, "available_cpus")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> builtins.str:
        """
        The time zone of the Cloud Autonomous VM Cluster.
        """
        return pulumi.get(self, "cluster_time_zone")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> builtins.str:
        """
        The compute model of the Cloud Autonomous VM Cluster. ECPU compute model is the recommended model and OCPU compute model is legacy. See [Compute Models in Autonomous Database on Dedicated Exadata #Infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak) for more details.
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> builtins.int:
        """
        The number of CPU cores on the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> builtins.int:
        """
        The number of CPU cores enabled per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> builtins.float:
        """
        The percentage of total number of CPUs used in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "cpu_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> builtins.float:
        """
        The total data storage allocated, in gigabytes (GB).
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> builtins.float:
        """
        The total data storage allocated, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> builtins.int:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        User defined description of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The domain name for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="exadataStorageInTbsLowestScaledValue")
    def exadata_storage_in_tbs_lowest_scaled_value(self) -> builtins.float:
        """
        The lowest value to which exadataStorage (in TBs) can be scaled down.
        """
        return pulumi.get(self, "exadata_storage_in_tbs_lowest_scaled_value")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> builtins.bool:
        """
        Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        """
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> builtins.str:
        """
        The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowDetailResult']:
        return pulumi.get(self, "maintenance_window_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="maxAcdsLowestScaledValue")
    def max_acds_lowest_scaled_value(self) -> builtins.int:
        """
        The lowest value to which maximum number of ACDs can be scaled down.
        """
        return pulumi.get(self, "max_acds_lowest_scaled_value")

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> builtins.int:
        """
        The amount of memory (in GBs) enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> builtins.int:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> builtins.int:
        """
        The number of database servers in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> builtins.int:
        """
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> builtins.float:
        """
        The number of CPU cores on the cloud Autonomous VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="ocpusLowestScaledValue")
    def ocpus_lowest_scaled_value(self) -> builtins.int:
        """
        The lowest value to which ocpus can be scaled down.
        """
        return pulumi.get(self, "ocpus_lowest_scaled_value")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> builtins.bool:
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="provisionableAutonomousContainerDatabases")
    def provisionable_autonomous_container_databases(self) -> builtins.int:
        """
        The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisionable_autonomous_container_databases")

    @property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> builtins.int:
        """
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> builtins.float:
        """
        The number of CPUs provisioned in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_cpus")

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> builtins.float:
        """
        For Autonomous Databases on Dedicated Exadata Infrastructure:
        * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> builtins.float:
        """
        The number of CPUs reserved in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "reserved_cpus")

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> builtins.int:
        """
        The SCAN Listener Non TLS port. Default is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> builtins.int:
        """
        The SCAN Listenenr TLS port. Default is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Mapping[str, builtins.str]:
        """
        Security Attributes for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "audit"}}}`
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The model name of the Exadata hardware running the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time that the cloud Autonomous VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDatabaseSslCertificateExpires")
    def time_database_ssl_certificate_expires(self) -> builtins.str:
        """
        The date and time of Database SSL certificate expiration.
        """
        return pulumi.get(self, "time_database_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeOrdsCertificateExpires")
    def time_ords_certificate_expires(self) -> builtins.str:
        """
        The date and time of ORDS certificate expiration.
        """
        return pulumi.get(self, "time_ords_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The last date and time that the cloud Autonomous VM cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalAutonomousDataStorageInTbs")
    def total_autonomous_data_storage_in_tbs(self) -> builtins.float:
        """
        The total data disk group size for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "total_autonomous_data_storage_in_tbs")

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> builtins.int:
        """
        The total number of Autonomous Container Databases that can be created with the allocated local storage.
        """
        return pulumi.get(self, "total_container_databases")

    @property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> builtins.float:
        """
        The total number of CPUs in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "total_cpus")


class AwaitableGetCloudAutonomousVmClusterResult(GetCloudAutonomousVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAutonomousVmClusterResult(
            autonomous_data_storage_percentage=self.autonomous_data_storage_percentage,
            autonomous_data_storage_size_in_tbs=self.autonomous_data_storage_size_in_tbs,
            availability_domain=self.availability_domain,
            available_autonomous_data_storage_size_in_tbs=self.available_autonomous_data_storage_size_in_tbs,
            available_container_databases=self.available_container_databases,
            available_cpus=self.available_cpus,
            cloud_autonomous_vm_cluster_id=self.cloud_autonomous_vm_cluster_id,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            cluster_time_zone=self.cluster_time_zone,
            compartment_id=self.compartment_id,
            compute_model=self.compute_model,
            cpu_core_count=self.cpu_core_count,
            cpu_core_count_per_node=self.cpu_core_count_per_node,
            cpu_percentage=self.cpu_percentage,
            data_storage_size_in_gb=self.data_storage_size_in_gb,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_servers=self.db_servers,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            domain=self.domain,
            exadata_storage_in_tbs_lowest_scaled_value=self.exadata_storage_in_tbs_lowest_scaled_value,
            freeform_tags=self.freeform_tags,
            hostname=self.hostname,
            id=self.id,
            is_mtls_enabled_vm_cluster=self.is_mtls_enabled_vm_cluster,
            last_maintenance_run_id=self.last_maintenance_run_id,
            last_update_history_entry_id=self.last_update_history_entry_id,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            maintenance_window_details=self.maintenance_window_details,
            maintenance_windows=self.maintenance_windows,
            max_acds_lowest_scaled_value=self.max_acds_lowest_scaled_value,
            memory_per_oracle_compute_unit_in_gbs=self.memory_per_oracle_compute_unit_in_gbs,
            memory_size_in_gbs=self.memory_size_in_gbs,
            next_maintenance_run_id=self.next_maintenance_run_id,
            node_count=self.node_count,
            non_provisionable_autonomous_container_databases=self.non_provisionable_autonomous_container_databases,
            nsg_ids=self.nsg_ids,
            ocpu_count=self.ocpu_count,
            ocpus_lowest_scaled_value=self.ocpus_lowest_scaled_value,
            opc_dry_run=self.opc_dry_run,
            provisionable_autonomous_container_databases=self.provisionable_autonomous_container_databases,
            provisioned_autonomous_container_databases=self.provisioned_autonomous_container_databases,
            provisioned_cpus=self.provisioned_cpus,
            reclaimable_cpus=self.reclaimable_cpus,
            reserved_cpus=self.reserved_cpus,
            scan_listener_port_non_tls=self.scan_listener_port_non_tls,
            scan_listener_port_tls=self.scan_listener_port_tls,
            security_attributes=self.security_attributes,
            shape=self.shape,
            state=self.state,
            subnet_id=self.subnet_id,
            subscription_id=self.subscription_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_database_ssl_certificate_expires=self.time_database_ssl_certificate_expires,
            time_ords_certificate_expires=self.time_ords_certificate_expires,
            time_updated=self.time_updated,
            total_autonomous_data_storage_in_tbs=self.total_autonomous_data_storage_in_tbs,
            total_container_databases=self.total_container_databases,
            total_cpus=self.total_cpus)


def get_cloud_autonomous_vm_cluster(cloud_autonomous_vm_cluster_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAutonomousVmClusterResult:
    """
    This data source provides details about a specific Cloud Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Exadata VM cluster in the Oracle cloud. For Exadata Cloud@Custustomer systems, see [GetAutonomousVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/GetAutonomousVmCluster).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_autonomous_vm_cluster = oci.Database.get_cloud_autonomous_vm_cluster(cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster_oci_database_cloud_autonomous_vm_cluster["id"])
    ```


    :param builtins.str cloud_autonomous_vm_cluster_id: The Cloud VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['cloudAutonomousVmClusterId'] = cloud_autonomous_vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudAutonomousVmCluster:getCloudAutonomousVmCluster', __args__, opts=opts, typ=GetCloudAutonomousVmClusterResult).value

    return AwaitableGetCloudAutonomousVmClusterResult(
        autonomous_data_storage_percentage=pulumi.get(__ret__, 'autonomous_data_storage_percentage'),
        autonomous_data_storage_size_in_tbs=pulumi.get(__ret__, 'autonomous_data_storage_size_in_tbs'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        available_autonomous_data_storage_size_in_tbs=pulumi.get(__ret__, 'available_autonomous_data_storage_size_in_tbs'),
        available_container_databases=pulumi.get(__ret__, 'available_container_databases'),
        available_cpus=pulumi.get(__ret__, 'available_cpus'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__ret__, 'cloud_autonomous_vm_cluster_id'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        cluster_time_zone=pulumi.get(__ret__, 'cluster_time_zone'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_model=pulumi.get(__ret__, 'compute_model'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        cpu_core_count_per_node=pulumi.get(__ret__, 'cpu_core_count_per_node'),
        cpu_percentage=pulumi.get(__ret__, 'cpu_percentage'),
        data_storage_size_in_gb=pulumi.get(__ret__, 'data_storage_size_in_gb'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        exadata_storage_in_tbs_lowest_scaled_value=pulumi.get(__ret__, 'exadata_storage_in_tbs_lowest_scaled_value'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        is_mtls_enabled_vm_cluster=pulumi.get(__ret__, 'is_mtls_enabled_vm_cluster'),
        last_maintenance_run_id=pulumi.get(__ret__, 'last_maintenance_run_id'),
        last_update_history_entry_id=pulumi.get(__ret__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_window_details=pulumi.get(__ret__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        max_acds_lowest_scaled_value=pulumi.get(__ret__, 'max_acds_lowest_scaled_value'),
        memory_per_oracle_compute_unit_in_gbs=pulumi.get(__ret__, 'memory_per_oracle_compute_unit_in_gbs'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        next_maintenance_run_id=pulumi.get(__ret__, 'next_maintenance_run_id'),
        node_count=pulumi.get(__ret__, 'node_count'),
        non_provisionable_autonomous_container_databases=pulumi.get(__ret__, 'non_provisionable_autonomous_container_databases'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        ocpu_count=pulumi.get(__ret__, 'ocpu_count'),
        ocpus_lowest_scaled_value=pulumi.get(__ret__, 'ocpus_lowest_scaled_value'),
        opc_dry_run=pulumi.get(__ret__, 'opc_dry_run'),
        provisionable_autonomous_container_databases=pulumi.get(__ret__, 'provisionable_autonomous_container_databases'),
        provisioned_autonomous_container_databases=pulumi.get(__ret__, 'provisioned_autonomous_container_databases'),
        provisioned_cpus=pulumi.get(__ret__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__ret__, 'reclaimable_cpus'),
        reserved_cpus=pulumi.get(__ret__, 'reserved_cpus'),
        scan_listener_port_non_tls=pulumi.get(__ret__, 'scan_listener_port_non_tls'),
        scan_listener_port_tls=pulumi.get(__ret__, 'scan_listener_port_tls'),
        security_attributes=pulumi.get(__ret__, 'security_attributes'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_database_ssl_certificate_expires=pulumi.get(__ret__, 'time_database_ssl_certificate_expires'),
        time_ords_certificate_expires=pulumi.get(__ret__, 'time_ords_certificate_expires'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        total_autonomous_data_storage_in_tbs=pulumi.get(__ret__, 'total_autonomous_data_storage_in_tbs'),
        total_container_databases=pulumi.get(__ret__, 'total_container_databases'),
        total_cpus=pulumi.get(__ret__, 'total_cpus'))
def get_cloud_autonomous_vm_cluster_output(cloud_autonomous_vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAutonomousVmClusterResult]:
    """
    This data source provides details about a specific Cloud Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified Autonomous Exadata VM cluster in the Oracle cloud. For Exadata Cloud@Custustomer systems, see [GetAutonomousVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/GetAutonomousVmCluster).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_autonomous_vm_cluster = oci.Database.get_cloud_autonomous_vm_cluster(cloud_autonomous_vm_cluster_id=test_cloud_autonomous_vm_cluster_oci_database_cloud_autonomous_vm_cluster["id"])
    ```


    :param builtins.str cloud_autonomous_vm_cluster_id: The Cloud VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['cloudAutonomousVmClusterId'] = cloud_autonomous_vm_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getCloudAutonomousVmCluster:getCloudAutonomousVmCluster', __args__, opts=opts, typ=GetCloudAutonomousVmClusterResult)
    return __ret__.apply(lambda __response__: GetCloudAutonomousVmClusterResult(
        autonomous_data_storage_percentage=pulumi.get(__response__, 'autonomous_data_storage_percentage'),
        autonomous_data_storage_size_in_tbs=pulumi.get(__response__, 'autonomous_data_storage_size_in_tbs'),
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        available_autonomous_data_storage_size_in_tbs=pulumi.get(__response__, 'available_autonomous_data_storage_size_in_tbs'),
        available_container_databases=pulumi.get(__response__, 'available_container_databases'),
        available_cpus=pulumi.get(__response__, 'available_cpus'),
        cloud_autonomous_vm_cluster_id=pulumi.get(__response__, 'cloud_autonomous_vm_cluster_id'),
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        cluster_time_zone=pulumi.get(__response__, 'cluster_time_zone'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_model=pulumi.get(__response__, 'compute_model'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        cpu_core_count_per_node=pulumi.get(__response__, 'cpu_core_count_per_node'),
        cpu_percentage=pulumi.get(__response__, 'cpu_percentage'),
        data_storage_size_in_gb=pulumi.get(__response__, 'data_storage_size_in_gb'),
        data_storage_size_in_tbs=pulumi.get(__response__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__response__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        exadata_storage_in_tbs_lowest_scaled_value=pulumi.get(__response__, 'exadata_storage_in_tbs_lowest_scaled_value'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        is_mtls_enabled_vm_cluster=pulumi.get(__response__, 'is_mtls_enabled_vm_cluster'),
        last_maintenance_run_id=pulumi.get(__response__, 'last_maintenance_run_id'),
        last_update_history_entry_id=pulumi.get(__response__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__response__, 'license_model'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        maintenance_window_details=pulumi.get(__response__, 'maintenance_window_details'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        max_acds_lowest_scaled_value=pulumi.get(__response__, 'max_acds_lowest_scaled_value'),
        memory_per_oracle_compute_unit_in_gbs=pulumi.get(__response__, 'memory_per_oracle_compute_unit_in_gbs'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        next_maintenance_run_id=pulumi.get(__response__, 'next_maintenance_run_id'),
        node_count=pulumi.get(__response__, 'node_count'),
        non_provisionable_autonomous_container_databases=pulumi.get(__response__, 'non_provisionable_autonomous_container_databases'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        ocpu_count=pulumi.get(__response__, 'ocpu_count'),
        ocpus_lowest_scaled_value=pulumi.get(__response__, 'ocpus_lowest_scaled_value'),
        opc_dry_run=pulumi.get(__response__, 'opc_dry_run'),
        provisionable_autonomous_container_databases=pulumi.get(__response__, 'provisionable_autonomous_container_databases'),
        provisioned_autonomous_container_databases=pulumi.get(__response__, 'provisioned_autonomous_container_databases'),
        provisioned_cpus=pulumi.get(__response__, 'provisioned_cpus'),
        reclaimable_cpus=pulumi.get(__response__, 'reclaimable_cpus'),
        reserved_cpus=pulumi.get(__response__, 'reserved_cpus'),
        scan_listener_port_non_tls=pulumi.get(__response__, 'scan_listener_port_non_tls'),
        scan_listener_port_tls=pulumi.get(__response__, 'scan_listener_port_tls'),
        security_attributes=pulumi.get(__response__, 'security_attributes'),
        shape=pulumi.get(__response__, 'shape'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_database_ssl_certificate_expires=pulumi.get(__response__, 'time_database_ssl_certificate_expires'),
        time_ords_certificate_expires=pulumi.get(__response__, 'time_ords_certificate_expires'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        total_autonomous_data_storage_in_tbs=pulumi.get(__response__, 'total_autonomous_data_storage_in_tbs'),
        total_container_databases=pulumi.get(__response__, 'total_container_databases'),
        total_cpus=pulumi.get(__response__, 'total_cpus')))
