# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseUpgradeHistoryEntriesResult',
    'AwaitableGetDatabaseUpgradeHistoryEntriesResult',
    'get_database_upgrade_history_entries',
    'get_database_upgrade_history_entries_output',
]

@pulumi.output_type
class GetDatabaseUpgradeHistoryEntriesResult:
    """
    A collection of values returned by getDatabaseUpgradeHistoryEntries.
    """
    def __init__(__self__, database_id=None, database_upgrade_history_entries=None, filters=None, id=None, state=None, upgrade_action=None):
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_upgrade_history_entries and not isinstance(database_upgrade_history_entries, list):
            raise TypeError("Expected argument 'database_upgrade_history_entries' to be a list")
        pulumi.set(__self__, "database_upgrade_history_entries", database_upgrade_history_entries)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if upgrade_action and not isinstance(upgrade_action, str):
            raise TypeError("Expected argument 'upgrade_action' to be a str")
        pulumi.set(__self__, "upgrade_action", upgrade_action)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> builtins.str:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseUpgradeHistoryEntries")
    def database_upgrade_history_entries(self) -> Sequence['outputs.GetDatabaseUpgradeHistoryEntriesDatabaseUpgradeHistoryEntryResult']:
        """
        The list of database_upgrade_history_entries.
        """
        return pulumi.get(self, "database_upgrade_history_entries")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseUpgradeHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Status of database upgrade history SUCCEEDED|IN_PROGRESS|FAILED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="upgradeAction")
    def upgrade_action(self) -> Optional[builtins.str]:
        return pulumi.get(self, "upgrade_action")


class AwaitableGetDatabaseUpgradeHistoryEntriesResult(GetDatabaseUpgradeHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseUpgradeHistoryEntriesResult(
            database_id=self.database_id,
            database_upgrade_history_entries=self.database_upgrade_history_entries,
            filters=self.filters,
            id=self.id,
            state=self.state,
            upgrade_action=self.upgrade_action)


def get_database_upgrade_history_entries(database_id: Optional[builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetDatabaseUpgradeHistoryEntriesFilterArgs', 'GetDatabaseUpgradeHistoryEntriesFilterArgsDict']]] = None,
                                         state: Optional[builtins.str] = None,
                                         upgrade_action: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseUpgradeHistoryEntriesResult:
    """
    This data source provides the list of Database Upgrade History Entries in Oracle Cloud Infrastructure Database service.

    Gets the upgrade history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_upgrade_history_entries = oci.Database.get_database_upgrade_history_entries(database_id=test_database["id"],
        state=database_upgrade_history_entry_state,
        upgrade_action=database_upgrade_history_entry_upgrade_action)
    ```


    :param builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str state: A filter to return only upgradeHistoryEntries that match the given lifecycle state exactly.
    :param builtins.str upgrade_action: A filter to return only upgradeHistoryEntries that match the specified Upgrade Action.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['upgradeAction'] = upgrade_action
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabaseUpgradeHistoryEntries:getDatabaseUpgradeHistoryEntries', __args__, opts=opts, typ=GetDatabaseUpgradeHistoryEntriesResult).value

    return AwaitableGetDatabaseUpgradeHistoryEntriesResult(
        database_id=pulumi.get(__ret__, 'database_id'),
        database_upgrade_history_entries=pulumi.get(__ret__, 'database_upgrade_history_entries'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        upgrade_action=pulumi.get(__ret__, 'upgrade_action'))
def get_database_upgrade_history_entries_output(database_id: Optional[pulumi.Input[builtins.str]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabaseUpgradeHistoryEntriesFilterArgs', 'GetDatabaseUpgradeHistoryEntriesFilterArgsDict']]]]] = None,
                                                state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                upgrade_action: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseUpgradeHistoryEntriesResult]:
    """
    This data source provides the list of Database Upgrade History Entries in Oracle Cloud Infrastructure Database service.

    Gets the upgrade history for a specified database in a bare metal or virtual machine DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_upgrade_history_entries = oci.Database.get_database_upgrade_history_entries(database_id=test_database["id"],
        state=database_upgrade_history_entry_state,
        upgrade_action=database_upgrade_history_entry_upgrade_action)
    ```


    :param builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str state: A filter to return only upgradeHistoryEntries that match the given lifecycle state exactly.
    :param builtins.str upgrade_action: A filter to return only upgradeHistoryEntries that match the specified Upgrade Action.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['upgradeAction'] = upgrade_action
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDatabaseUpgradeHistoryEntries:getDatabaseUpgradeHistoryEntries', __args__, opts=opts, typ=GetDatabaseUpgradeHistoryEntriesResult)
    return __ret__.apply(lambda __response__: GetDatabaseUpgradeHistoryEntriesResult(
        database_id=pulumi.get(__response__, 'database_id'),
        database_upgrade_history_entries=pulumi.get(__response__, 'database_upgrade_history_entries'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        upgrade_action=pulumi.get(__response__, 'upgrade_action')))
