# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSystemVersionMinorVersionsResult',
    'AwaitableGetSystemVersionMinorVersionsResult',
    'get_system_version_minor_versions',
    'get_system_version_minor_versions_output',
]

@pulumi.output_type
class GetSystemVersionMinorVersionsResult:
    """
    A collection of values returned by getSystemVersionMinorVersions.
    """
    def __init__(__self__, compartment_id=None, filters=None, gi_version=None, id=None, is_latest=None, major_version=None, resource_id=None, shape=None, system_version_minor_version_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if major_version and not isinstance(major_version, str):
            raise TypeError("Expected argument 'major_version' to be a str")
        pulumi.set(__self__, "major_version", major_version)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if system_version_minor_version_collections and not isinstance(system_version_minor_version_collections, list):
            raise TypeError("Expected argument 'system_version_minor_version_collections' to be a list")
        pulumi.set(__self__, "system_version_minor_version_collections", system_version_minor_version_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSystemVersionMinorVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> builtins.str:
        return pulumi.get(self, "gi_version")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> builtins.str:
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def shape(self) -> Optional[builtins.str]:
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="systemVersionMinorVersionCollections")
    def system_version_minor_version_collections(self) -> Sequence['outputs.GetSystemVersionMinorVersionsSystemVersionMinorVersionCollectionResult']:
        """
        The list of system_version_minor_version_collection.
        """
        return pulumi.get(self, "system_version_minor_version_collections")


class AwaitableGetSystemVersionMinorVersionsResult(GetSystemVersionMinorVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSystemVersionMinorVersionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            gi_version=self.gi_version,
            id=self.id,
            is_latest=self.is_latest,
            major_version=self.major_version,
            resource_id=self.resource_id,
            shape=self.shape,
            system_version_minor_version_collections=self.system_version_minor_version_collections)


def get_system_version_minor_versions(compartment_id: Optional[builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetSystemVersionMinorVersionsFilterArgs', 'GetSystemVersionMinorVersionsFilterArgsDict']]] = None,
                                      gi_version: Optional[builtins.str] = None,
                                      is_latest: Optional[builtins.bool] = None,
                                      major_version: Optional[builtins.str] = None,
                                      resource_id: Optional[builtins.str] = None,
                                      shape: Optional[builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSystemVersionMinorVersionsResult:
    """
    This data source provides the list of System Version Minor Versions in Oracle Cloud Infrastructure Database service.

    Retrieves a list of supported minor versions for the specified Exadata System Software major version. You must provide either a `shape` or `resourceId` value.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_version_minor_versions = oci.Database.get_system_version_minor_versions(compartment_id=compartment_id,
        gi_version=system_version_minor_version_gi_version,
        major_version=system_version_minor_version_major_version,
        is_latest=system_version_minor_version_is_latest,
        resource_id=test_resource["id"],
        shape=system_version_minor_version_shape)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str gi_version: Specifies gi version query parameter.
    :param builtins.bool is_latest: If provided, return highest versions from each major version family.
    :param builtins.str major_version: The System major version.
    :param builtins.str resource_id: If provided, filters the results for the specified resource Id.
    :param builtins.str shape: If provided, filters the results for the given shape.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['giVersion'] = gi_version
    __args__['isLatest'] = is_latest
    __args__['majorVersion'] = major_version
    __args__['resourceId'] = resource_id
    __args__['shape'] = shape
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getSystemVersionMinorVersions:getSystemVersionMinorVersions', __args__, opts=opts, typ=GetSystemVersionMinorVersionsResult).value

    return AwaitableGetSystemVersionMinorVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        major_version=pulumi.get(__ret__, 'major_version'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        shape=pulumi.get(__ret__, 'shape'),
        system_version_minor_version_collections=pulumi.get(__ret__, 'system_version_minor_version_collections'))
def get_system_version_minor_versions_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSystemVersionMinorVersionsFilterArgs', 'GetSystemVersionMinorVersionsFilterArgsDict']]]]] = None,
                                             gi_version: Optional[pulumi.Input[builtins.str]] = None,
                                             is_latest: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                             major_version: Optional[pulumi.Input[builtins.str]] = None,
                                             resource_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             shape: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSystemVersionMinorVersionsResult]:
    """
    This data source provides the list of System Version Minor Versions in Oracle Cloud Infrastructure Database service.

    Retrieves a list of supported minor versions for the specified Exadata System Software major version. You must provide either a `shape` or `resourceId` value.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_system_version_minor_versions = oci.Database.get_system_version_minor_versions(compartment_id=compartment_id,
        gi_version=system_version_minor_version_gi_version,
        major_version=system_version_minor_version_major_version,
        is_latest=system_version_minor_version_is_latest,
        resource_id=test_resource["id"],
        shape=system_version_minor_version_shape)
    ```


    :param builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param builtins.str gi_version: Specifies gi version query parameter.
    :param builtins.bool is_latest: If provided, return highest versions from each major version family.
    :param builtins.str major_version: The System major version.
    :param builtins.str resource_id: If provided, filters the results for the specified resource Id.
    :param builtins.str shape: If provided, filters the results for the given shape.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['giVersion'] = gi_version
    __args__['isLatest'] = is_latest
    __args__['majorVersion'] = major_version
    __args__['resourceId'] = resource_id
    __args__['shape'] = shape
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getSystemVersionMinorVersions:getSystemVersionMinorVersions', __args__, opts=opts, typ=GetSystemVersionMinorVersionsResult)
    return __ret__.apply(lambda __response__: GetSystemVersionMinorVersionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        gi_version=pulumi.get(__response__, 'gi_version'),
        id=pulumi.get(__response__, 'id'),
        is_latest=pulumi.get(__response__, 'is_latest'),
        major_version=pulumi.get(__response__, 'major_version'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        shape=pulumi.get(__response__, 'shape'),
        system_version_minor_version_collections=pulumi.get(__response__, 'system_version_minor_version_collections')))
