# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataStorageConnectorResult',
    'AwaitableGetExternalExadataStorageConnectorResult',
    'get_external_exadata_storage_connector',
    'get_external_exadata_storage_connector_output',
]

@pulumi.output_type
class GetExternalExadataStorageConnectorResult:
    """
    A collection of values returned by getExternalExadataStorageConnector.
    """
    def __init__(__self__, additional_details=None, agent_id=None, connection_uri=None, connector_name=None, credential_infos=None, defined_tags=None, display_name=None, exadata_infrastructure_id=None, external_exadata_storage_connector_id=None, freeform_tags=None, id=None, internal_id=None, lifecycle_details=None, state=None, status=None, storage_server_id=None, system_tags=None, time_created=None, time_updated=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if connection_uri and not isinstance(connection_uri, str):
            raise TypeError("Expected argument 'connection_uri' to be a str")
        pulumi.set(__self__, "connection_uri", connection_uri)
        if connector_name and not isinstance(connector_name, str):
            raise TypeError("Expected argument 'connector_name' to be a str")
        pulumi.set(__self__, "connector_name", connector_name)
        if credential_infos and not isinstance(credential_infos, list):
            raise TypeError("Expected argument 'credential_infos' to be a list")
        pulumi.set(__self__, "credential_infos", credential_infos)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if external_exadata_storage_connector_id and not isinstance(external_exadata_storage_connector_id, str):
            raise TypeError("Expected argument 'external_exadata_storage_connector_id' to be a str")
        pulumi.set(__self__, "external_exadata_storage_connector_id", external_exadata_storage_connector_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_id and not isinstance(internal_id, str):
            raise TypeError("Expected argument 'internal_id' to be a str")
        pulumi.set(__self__, "internal_id", internal_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_server_id and not isinstance(storage_server_id, str):
            raise TypeError("Expected argument 'storage_server_id' to be a str")
        pulumi.set(__self__, "storage_server_id", storage_server_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, builtins.str]:
        """
        The additional details of the resource defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the agent for the Exadata storage server.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> builtins.str:
        """
        The unique string of the connection. For example, "https://<storage-server-name>/MS/RESTService/".
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> builtins.str:
        return pulumi.get(self, "connector_name")

    @property
    @pulumi.getter(name="credentialInfos")
    def credential_infos(self) -> Sequence['outputs.GetExternalExadataStorageConnectorCredentialInfoResult']:
        return pulumi.get(self, "credential_infos")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="externalExadataStorageConnectorId")
    def external_exadata_storage_connector_id(self) -> builtins.str:
        return pulumi.get(self, "external_exadata_storage_connector_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> builtins.str:
        """
        The internal ID of the Exadata resource.
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The details of the lifecycle state of the Exadata resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the Exadata resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageServerId")
    def storage_server_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
        """
        return pulumi.get(self, "storage_server_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The timestamp of the creation of the Exadata resource.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The timestamp of the last update of the Exadata resource.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the Exadata resource.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalExadataStorageConnectorResult(GetExternalExadataStorageConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageConnectorResult(
            additional_details=self.additional_details,
            agent_id=self.agent_id,
            connection_uri=self.connection_uri,
            connector_name=self.connector_name,
            credential_infos=self.credential_infos,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            external_exadata_storage_connector_id=self.external_exadata_storage_connector_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            internal_id=self.internal_id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            status=self.status,
            storage_server_id=self.storage_server_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            version=self.version)


def get_external_exadata_storage_connector(external_exadata_storage_connector_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageConnectorResult:
    """
    This data source provides details about a specific External Exadata Storage Connector resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata storage server connector specified by exadataStorageConnectorId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_connector = oci.DatabaseManagement.get_external_exadata_storage_connector(external_exadata_storage_connector_id=test_external_exadata_storage_connector_oci_database_management_external_exadata_storage_connector["id"])
    ```


    :param builtins.str external_exadata_storage_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector to the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageConnectorId'] = external_exadata_storage_connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageConnector:getExternalExadataStorageConnector', __args__, opts=opts, typ=GetExternalExadataStorageConnectorResult).value

    return AwaitableGetExternalExadataStorageConnectorResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        agent_id=pulumi.get(__ret__, 'agent_id'),
        connection_uri=pulumi.get(__ret__, 'connection_uri'),
        connector_name=pulumi.get(__ret__, 'connector_name'),
        credential_infos=pulumi.get(__ret__, 'credential_infos'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        external_exadata_storage_connector_id=pulumi.get(__ret__, 'external_exadata_storage_connector_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        internal_id=pulumi.get(__ret__, 'internal_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        storage_server_id=pulumi.get(__ret__, 'storage_server_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))
def get_external_exadata_storage_connector_output(external_exadata_storage_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalExadataStorageConnectorResult]:
    """
    This data source provides details about a specific External Exadata Storage Connector resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the Exadata storage server connector specified by exadataStorageConnectorId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_connector = oci.DatabaseManagement.get_external_exadata_storage_connector(external_exadata_storage_connector_id=test_external_exadata_storage_connector_oci_database_management_external_exadata_storage_connector["id"])
    ```


    :param builtins.str external_exadata_storage_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connector to the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageConnectorId'] = external_exadata_storage_connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalExadataStorageConnector:getExternalExadataStorageConnector', __args__, opts=opts, typ=GetExternalExadataStorageConnectorResult)
    return __ret__.apply(lambda __response__: GetExternalExadataStorageConnectorResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        agent_id=pulumi.get(__response__, 'agent_id'),
        connection_uri=pulumi.get(__response__, 'connection_uri'),
        connector_name=pulumi.get(__response__, 'connector_name'),
        credential_infos=pulumi.get(__response__, 'credential_infos'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        external_exadata_storage_connector_id=pulumi.get(__response__, 'external_exadata_storage_connector_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        internal_id=pulumi.get(__response__, 'internal_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        storage_server_id=pulumi.get(__response__, 'storage_server_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        version=pulumi.get(__response__, 'version')))
