# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalMySqlDatabaseConnectorResult',
    'AwaitableGetExternalMySqlDatabaseConnectorResult',
    'get_external_my_sql_database_connector',
    'get_external_my_sql_database_connector_output',
]

@pulumi.output_type
class GetExternalMySqlDatabaseConnectorResult:
    """
    A collection of values returned by getExternalMySqlDatabaseConnector.
    """
    def __init__(__self__, associated_services=None, check_connection_status_trigger=None, compartment_id=None, connection_status=None, connector_details=None, connector_type=None, credential_type=None, external_database_id=None, external_my_sql_database_connector_id=None, host_name=None, id=None, is_test_connection_param=None, macs_agent_id=None, name=None, network_protocol=None, port=None, source_database=None, source_database_type=None, ssl_secret_id=None, ssl_secret_name=None, state=None, time_connection_status_updated=None, time_created=None, time_updated=None):
        if associated_services and not isinstance(associated_services, str):
            raise TypeError("Expected argument 'associated_services' to be a str")
        pulumi.set(__self__, "associated_services", associated_services)
        if check_connection_status_trigger and not isinstance(check_connection_status_trigger, int):
            raise TypeError("Expected argument 'check_connection_status_trigger' to be a int")
        pulumi.set(__self__, "check_connection_status_trigger", check_connection_status_trigger)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_status and not isinstance(connection_status, str):
            raise TypeError("Expected argument 'connection_status' to be a str")
        pulumi.set(__self__, "connection_status", connection_status)
        if connector_details and not isinstance(connector_details, list):
            raise TypeError("Expected argument 'connector_details' to be a list")
        pulumi.set(__self__, "connector_details", connector_details)
        if connector_type and not isinstance(connector_type, str):
            raise TypeError("Expected argument 'connector_type' to be a str")
        pulumi.set(__self__, "connector_type", connector_type)
        if credential_type and not isinstance(credential_type, str):
            raise TypeError("Expected argument 'credential_type' to be a str")
        pulumi.set(__self__, "credential_type", credential_type)
        if external_database_id and not isinstance(external_database_id, str):
            raise TypeError("Expected argument 'external_database_id' to be a str")
        pulumi.set(__self__, "external_database_id", external_database_id)
        if external_my_sql_database_connector_id and not isinstance(external_my_sql_database_connector_id, str):
            raise TypeError("Expected argument 'external_my_sql_database_connector_id' to be a str")
        pulumi.set(__self__, "external_my_sql_database_connector_id", external_my_sql_database_connector_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_test_connection_param and not isinstance(is_test_connection_param, bool):
            raise TypeError("Expected argument 'is_test_connection_param' to be a bool")
        pulumi.set(__self__, "is_test_connection_param", is_test_connection_param)
        if macs_agent_id and not isinstance(macs_agent_id, str):
            raise TypeError("Expected argument 'macs_agent_id' to be a str")
        pulumi.set(__self__, "macs_agent_id", macs_agent_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_protocol and not isinstance(network_protocol, str):
            raise TypeError("Expected argument 'network_protocol' to be a str")
        pulumi.set(__self__, "network_protocol", network_protocol)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if source_database and not isinstance(source_database, str):
            raise TypeError("Expected argument 'source_database' to be a str")
        pulumi.set(__self__, "source_database", source_database)
        if source_database_type and not isinstance(source_database_type, str):
            raise TypeError("Expected argument 'source_database_type' to be a str")
        pulumi.set(__self__, "source_database_type", source_database_type)
        if ssl_secret_id and not isinstance(ssl_secret_id, str):
            raise TypeError("Expected argument 'ssl_secret_id' to be a str")
        pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)
        if ssl_secret_name and not isinstance(ssl_secret_name, str):
            raise TypeError("Expected argument 'ssl_secret_name' to be a str")
        pulumi.set(__self__, "ssl_secret_name", ssl_secret_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_connection_status_updated and not isinstance(time_connection_status_updated, str):
            raise TypeError("Expected argument 'time_connection_status_updated' to be a str")
        pulumi.set(__self__, "time_connection_status_updated", time_connection_status_updated)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="associatedServices")
    def associated_services(self) -> builtins.str:
        """
        Oracle Cloud Infrastructure Services associated with this connector.
        """
        return pulumi.get(self, "associated_services")

    @property
    @pulumi.getter(name="checkConnectionStatusTrigger")
    def check_connection_status_trigger(self) -> builtins.int:
        return pulumi.get(self, "check_connection_status_trigger")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of compartment for the External MySQL connector.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> builtins.str:
        """
        Connection Status
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="connectorDetails")
    def connector_details(self) -> Sequence['outputs.GetExternalMySqlDatabaseConnectorConnectorDetailResult']:
        return pulumi.get(self, "connector_details")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> builtins.str:
        """
        Connector Type.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> builtins.str:
        """
        Credential type used to connect to database.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="externalDatabaseId")
    def external_database_id(self) -> builtins.str:
        """
        OCID of MySQL Database resource
        """
        return pulumi.get(self, "external_database_id")

    @property
    @pulumi.getter(name="externalMySqlDatabaseConnectorId")
    def external_my_sql_database_connector_id(self) -> builtins.str:
        return pulumi.get(self, "external_my_sql_database_connector_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        Host name for Connector.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID of MySQL Database Connector.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isTestConnectionParam")
    def is_test_connection_param(self) -> builtins.bool:
        return pulumi.get(self, "is_test_connection_param")

    @property
    @pulumi.getter(name="macsAgentId")
    def macs_agent_id(self) -> builtins.str:
        """
        Agent Id of the MACS agent.
        """
        return pulumi.get(self, "macs_agent_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        External MySQL Database Connector Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProtocol")
    def network_protocol(self) -> builtins.str:
        """
        Network Protocol.
        """
        return pulumi.get(self, "network_protocol")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Connector port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceDatabase")
    def source_database(self) -> builtins.str:
        """
        Name of MySQL Database.
        """
        return pulumi.get(self, "source_database")

    @property
    @pulumi.getter(name="sourceDatabaseType")
    def source_database_type(self) -> builtins.str:
        """
        Type of MySQL Database.
        """
        return pulumi.get(self, "source_database_type")

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> builtins.str:
        """
        OCID of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_id")

    @property
    @pulumi.getter(name="sslSecretName")
    def ssl_secret_name(self) -> builtins.str:
        """
        Name of the SSL secret, if TCPS with SSL is used to connect to database.
        """
        return pulumi.get(self, "ssl_secret_name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Indicates lifecycle  state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeConnectionStatusUpdated")
    def time_connection_status_updated(self) -> builtins.str:
        """
        Time when connection status was last updated.
        """
        return pulumi.get(self, "time_connection_status_updated")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Connector creation time.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Connector update time.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetExternalMySqlDatabaseConnectorResult(GetExternalMySqlDatabaseConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalMySqlDatabaseConnectorResult(
            associated_services=self.associated_services,
            check_connection_status_trigger=self.check_connection_status_trigger,
            compartment_id=self.compartment_id,
            connection_status=self.connection_status,
            connector_details=self.connector_details,
            connector_type=self.connector_type,
            credential_type=self.credential_type,
            external_database_id=self.external_database_id,
            external_my_sql_database_connector_id=self.external_my_sql_database_connector_id,
            host_name=self.host_name,
            id=self.id,
            is_test_connection_param=self.is_test_connection_param,
            macs_agent_id=self.macs_agent_id,
            name=self.name,
            network_protocol=self.network_protocol,
            port=self.port,
            source_database=self.source_database,
            source_database_type=self.source_database_type,
            ssl_secret_id=self.ssl_secret_id,
            ssl_secret_name=self.ssl_secret_name,
            state=self.state,
            time_connection_status_updated=self.time_connection_status_updated,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_external_my_sql_database_connector(external_my_sql_database_connector_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalMySqlDatabaseConnectorResult:
    """
    This data source provides details about a specific External My Sql Database Connector resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves the MySQL database connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database_connector = oci.DatabaseManagement.get_external_my_sql_database_connector(external_my_sql_database_connector_id=test_external_my_sql_database_connector_oci_database_management_external_my_sql_database_connector["id"])
    ```


    :param builtins.str external_my_sql_database_connector_id: The OCID of the External MySQL Database Connector.
    """
    __args__ = dict()
    __args__['externalMySqlDatabaseConnectorId'] = external_my_sql_database_connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalMySqlDatabaseConnector:getExternalMySqlDatabaseConnector', __args__, opts=opts, typ=GetExternalMySqlDatabaseConnectorResult).value

    return AwaitableGetExternalMySqlDatabaseConnectorResult(
        associated_services=pulumi.get(__ret__, 'associated_services'),
        check_connection_status_trigger=pulumi.get(__ret__, 'check_connection_status_trigger'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_status=pulumi.get(__ret__, 'connection_status'),
        connector_details=pulumi.get(__ret__, 'connector_details'),
        connector_type=pulumi.get(__ret__, 'connector_type'),
        credential_type=pulumi.get(__ret__, 'credential_type'),
        external_database_id=pulumi.get(__ret__, 'external_database_id'),
        external_my_sql_database_connector_id=pulumi.get(__ret__, 'external_my_sql_database_connector_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        is_test_connection_param=pulumi.get(__ret__, 'is_test_connection_param'),
        macs_agent_id=pulumi.get(__ret__, 'macs_agent_id'),
        name=pulumi.get(__ret__, 'name'),
        network_protocol=pulumi.get(__ret__, 'network_protocol'),
        port=pulumi.get(__ret__, 'port'),
        source_database=pulumi.get(__ret__, 'source_database'),
        source_database_type=pulumi.get(__ret__, 'source_database_type'),
        ssl_secret_id=pulumi.get(__ret__, 'ssl_secret_id'),
        ssl_secret_name=pulumi.get(__ret__, 'ssl_secret_name'),
        state=pulumi.get(__ret__, 'state'),
        time_connection_status_updated=pulumi.get(__ret__, 'time_connection_status_updated'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_external_my_sql_database_connector_output(external_my_sql_database_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalMySqlDatabaseConnectorResult]:
    """
    This data source provides details about a specific External My Sql Database Connector resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves the MySQL database connector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_database_connector = oci.DatabaseManagement.get_external_my_sql_database_connector(external_my_sql_database_connector_id=test_external_my_sql_database_connector_oci_database_management_external_my_sql_database_connector["id"])
    ```


    :param builtins.str external_my_sql_database_connector_id: The OCID of the External MySQL Database Connector.
    """
    __args__ = dict()
    __args__['externalMySqlDatabaseConnectorId'] = external_my_sql_database_connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalMySqlDatabaseConnector:getExternalMySqlDatabaseConnector', __args__, opts=opts, typ=GetExternalMySqlDatabaseConnectorResult)
    return __ret__.apply(lambda __response__: GetExternalMySqlDatabaseConnectorResult(
        associated_services=pulumi.get(__response__, 'associated_services'),
        check_connection_status_trigger=pulumi.get(__response__, 'check_connection_status_trigger'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_status=pulumi.get(__response__, 'connection_status'),
        connector_details=pulumi.get(__response__, 'connector_details'),
        connector_type=pulumi.get(__response__, 'connector_type'),
        credential_type=pulumi.get(__response__, 'credential_type'),
        external_database_id=pulumi.get(__response__, 'external_database_id'),
        external_my_sql_database_connector_id=pulumi.get(__response__, 'external_my_sql_database_connector_id'),
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        is_test_connection_param=pulumi.get(__response__, 'is_test_connection_param'),
        macs_agent_id=pulumi.get(__response__, 'macs_agent_id'),
        name=pulumi.get(__response__, 'name'),
        network_protocol=pulumi.get(__response__, 'network_protocol'),
        port=pulumi.get(__response__, 'port'),
        source_database=pulumi.get(__response__, 'source_database'),
        source_database_type=pulumi.get(__response__, 'source_database_type'),
        ssl_secret_id=pulumi.get(__response__, 'ssl_secret_id'),
        ssl_secret_name=pulumi.get(__response__, 'ssl_secret_name'),
        state=pulumi.get(__response__, 'state'),
        time_connection_status_updated=pulumi.get(__response__, 'time_connection_status_updated'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
