# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedMySqlDatabaseQueryDetailResult',
    'AwaitableGetManagedMySqlDatabaseQueryDetailResult',
    'get_managed_my_sql_database_query_detail',
    'get_managed_my_sql_database_query_detail_output',
]

@pulumi.output_type
class GetManagedMySqlDatabaseQueryDetailResult:
    """
    A collection of values returned by getManagedMySqlDatabaseQueryDetail.
    """
    def __init__(__self__, digest=None, id=None, managed_my_sql_database_id=None, query_explain_plans=None, query_messages=None, query_sample_details=None):
        if digest and not isinstance(digest, str):
            raise TypeError("Expected argument 'digest' to be a str")
        pulumi.set(__self__, "digest", digest)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_my_sql_database_id and not isinstance(managed_my_sql_database_id, str):
            raise TypeError("Expected argument 'managed_my_sql_database_id' to be a str")
        pulumi.set(__self__, "managed_my_sql_database_id", managed_my_sql_database_id)
        if query_explain_plans and not isinstance(query_explain_plans, list):
            raise TypeError("Expected argument 'query_explain_plans' to be a list")
        pulumi.set(__self__, "query_explain_plans", query_explain_plans)
        if query_messages and not isinstance(query_messages, list):
            raise TypeError("Expected argument 'query_messages' to be a list")
        pulumi.set(__self__, "query_messages", query_messages)
        if query_sample_details and not isinstance(query_sample_details, list):
            raise TypeError("Expected argument 'query_sample_details' to be a list")
        pulumi.set(__self__, "query_sample_details", query_sample_details)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedMySqlDatabaseId")
    def managed_my_sql_database_id(self) -> builtins.str:
        return pulumi.get(self, "managed_my_sql_database_id")

    @property
    @pulumi.getter(name="queryExplainPlans")
    def query_explain_plans(self) -> Sequence['outputs.GetManagedMySqlDatabaseQueryDetailQueryExplainPlanResult']:
        """
        The explain plan for a given MySQL query.
        """
        return pulumi.get(self, "query_explain_plans")

    @property
    @pulumi.getter(name="queryMessages")
    def query_messages(self) -> Sequence['outputs.GetManagedMySqlDatabaseQueryDetailQueryMessageResult']:
        """
        The errors, warnings and notes that could be raised by the execution of the query.
        """
        return pulumi.get(self, "query_messages")

    @property
    @pulumi.getter(name="querySampleDetails")
    def query_sample_details(self) -> Sequence['outputs.GetManagedMySqlDatabaseQueryDetailQuerySampleDetailResult']:
        """
        The details of a query sample including the query text, execution time and other details.
        """
        return pulumi.get(self, "query_sample_details")


class AwaitableGetManagedMySqlDatabaseQueryDetailResult(GetManagedMySqlDatabaseQueryDetailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedMySqlDatabaseQueryDetailResult(
            digest=self.digest,
            id=self.id,
            managed_my_sql_database_id=self.managed_my_sql_database_id,
            query_explain_plans=self.query_explain_plans,
            query_messages=self.query_messages,
            query_sample_details=self.query_sample_details)


def get_managed_my_sql_database_query_detail(digest: Optional[builtins.str] = None,
                                             managed_my_sql_database_id: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedMySqlDatabaseQueryDetailResult:
    """
    This data source provides details about a specific Managed My Sql Database Query Detail resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves query sample details, explain plan and potential warnings for a given digest.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database_query_detail = oci.DatabaseManagement.get_managed_my_sql_database_query_detail(digest=managed_my_sql_database_query_detail_digest,
        managed_my_sql_database_id=test_managed_my_sql_database["id"])
    ```


    :param builtins.str digest: The digest of a MySQL normalized query.
    :param builtins.str managed_my_sql_database_id: The OCID of the Managed MySQL Database.
    """
    __args__ = dict()
    __args__['digest'] = digest
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedMySqlDatabaseQueryDetail:getManagedMySqlDatabaseQueryDetail', __args__, opts=opts, typ=GetManagedMySqlDatabaseQueryDetailResult).value

    return AwaitableGetManagedMySqlDatabaseQueryDetailResult(
        digest=pulumi.get(__ret__, 'digest'),
        id=pulumi.get(__ret__, 'id'),
        managed_my_sql_database_id=pulumi.get(__ret__, 'managed_my_sql_database_id'),
        query_explain_plans=pulumi.get(__ret__, 'query_explain_plans'),
        query_messages=pulumi.get(__ret__, 'query_messages'),
        query_sample_details=pulumi.get(__ret__, 'query_sample_details'))
def get_managed_my_sql_database_query_detail_output(digest: Optional[pulumi.Input[builtins.str]] = None,
                                                    managed_my_sql_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedMySqlDatabaseQueryDetailResult]:
    """
    This data source provides details about a specific Managed My Sql Database Query Detail resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves query sample details, explain plan and potential warnings for a given digest.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database_query_detail = oci.DatabaseManagement.get_managed_my_sql_database_query_detail(digest=managed_my_sql_database_query_detail_digest,
        managed_my_sql_database_id=test_managed_my_sql_database["id"])
    ```


    :param builtins.str digest: The digest of a MySQL normalized query.
    :param builtins.str managed_my_sql_database_id: The OCID of the Managed MySQL Database.
    """
    __args__ = dict()
    __args__['digest'] = digest
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedMySqlDatabaseQueryDetail:getManagedMySqlDatabaseQueryDetail', __args__, opts=opts, typ=GetManagedMySqlDatabaseQueryDetailResult)
    return __ret__.apply(lambda __response__: GetManagedMySqlDatabaseQueryDetailResult(
        digest=pulumi.get(__response__, 'digest'),
        id=pulumi.get(__response__, 'id'),
        managed_my_sql_database_id=pulumi.get(__response__, 'managed_my_sql_database_id'),
        query_explain_plans=pulumi.get(__response__, 'query_explain_plans'),
        query_messages=pulumi.get(__response__, 'query_messages'),
        query_sample_details=pulumi.get(__response__, 'query_sample_details')))
