# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobAdvisorReportResult',
    'AwaitableGetJobAdvisorReportResult',
    'get_job_advisor_report',
    'get_job_advisor_report_output',
]

@pulumi.output_type
class GetJobAdvisorReportResult:
    """
    A collection of values returned by getJobAdvisorReport.
    """
    def __init__(__self__, id=None, job_id=None, number_of_fatal=None, number_of_fatal_blockers=None, number_of_informational_results=None, number_of_warnings=None, report_location_details=None, result=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if number_of_fatal and not isinstance(number_of_fatal, int):
            raise TypeError("Expected argument 'number_of_fatal' to be a int")
        pulumi.set(__self__, "number_of_fatal", number_of_fatal)
        if number_of_fatal_blockers and not isinstance(number_of_fatal_blockers, int):
            raise TypeError("Expected argument 'number_of_fatal_blockers' to be a int")
        pulumi.set(__self__, "number_of_fatal_blockers", number_of_fatal_blockers)
        if number_of_informational_results and not isinstance(number_of_informational_results, int):
            raise TypeError("Expected argument 'number_of_informational_results' to be a int")
        pulumi.set(__self__, "number_of_informational_results", number_of_informational_results)
        if number_of_warnings and not isinstance(number_of_warnings, int):
            raise TypeError("Expected argument 'number_of_warnings' to be a int")
        pulumi.set(__self__, "number_of_warnings", number_of_warnings)
        if report_location_details and not isinstance(report_location_details, list):
            raise TypeError("Expected argument 'report_location_details' to be a list")
        pulumi.set(__self__, "report_location_details", report_location_details)
        if result and not isinstance(result, str):
            raise TypeError("Expected argument 'result' to be a str")
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> builtins.str:
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="numberOfFatal")
    def number_of_fatal(self) -> builtins.int:
        """
        Number of Fatal results in the advisor report.
        """
        return pulumi.get(self, "number_of_fatal")

    @property
    @pulumi.getter(name="numberOfFatalBlockers")
    def number_of_fatal_blockers(self) -> builtins.int:
        """
        Number of Fatal Blocker results in the advisor report.
        """
        return pulumi.get(self, "number_of_fatal_blockers")

    @property
    @pulumi.getter(name="numberOfInformationalResults")
    def number_of_informational_results(self) -> builtins.int:
        """
        Number of Informational results in the advisor report.
        """
        return pulumi.get(self, "number_of_informational_results")

    @property
    @pulumi.getter(name="numberOfWarnings")
    def number_of_warnings(self) -> builtins.int:
        """
        Number of Warning results in the advisor report.
        """
        return pulumi.get(self, "number_of_warnings")

    @property
    @pulumi.getter(name="reportLocationDetails")
    def report_location_details(self) -> Sequence['outputs.GetJobAdvisorReportReportLocationDetailResult']:
        """
        Details to access Premigration Advisor report.
        """
        return pulumi.get(self, "report_location_details")

    @property
    @pulumi.getter
    def result(self) -> builtins.str:
        """
        Premigration Advisor result.
        """
        return pulumi.get(self, "result")


class AwaitableGetJobAdvisorReportResult(GetJobAdvisorReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobAdvisorReportResult(
            id=self.id,
            job_id=self.job_id,
            number_of_fatal=self.number_of_fatal,
            number_of_fatal_blockers=self.number_of_fatal_blockers,
            number_of_informational_results=self.number_of_informational_results,
            number_of_warnings=self.number_of_warnings,
            report_location_details=self.report_location_details,
            result=self.result)


def get_job_advisor_report(job_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobAdvisorReportResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_advisor_report = oci.DatabaseMigration.get_job_advisor_report(job_id=test_job["id"])
    ```


    :param builtins.str job_id: The OCID of the job
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseMigration/getJobAdvisorReport:getJobAdvisorReport', __args__, opts=opts, typ=GetJobAdvisorReportResult).value

    return AwaitableGetJobAdvisorReportResult(
        id=pulumi.get(__ret__, 'id'),
        job_id=pulumi.get(__ret__, 'job_id'),
        number_of_fatal=pulumi.get(__ret__, 'number_of_fatal'),
        number_of_fatal_blockers=pulumi.get(__ret__, 'number_of_fatal_blockers'),
        number_of_informational_results=pulumi.get(__ret__, 'number_of_informational_results'),
        number_of_warnings=pulumi.get(__ret__, 'number_of_warnings'),
        report_location_details=pulumi.get(__ret__, 'report_location_details'),
        result=pulumi.get(__ret__, 'result'))
def get_job_advisor_report_output(job_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobAdvisorReportResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_advisor_report = oci.DatabaseMigration.get_job_advisor_report(job_id=test_job["id"])
    ```


    :param builtins.str job_id: The OCID of the job
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseMigration/getJobAdvisorReport:getJobAdvisorReport', __args__, opts=opts, typ=GetJobAdvisorReportResult)
    return __ret__.apply(lambda __response__: GetJobAdvisorReportResult(
        id=pulumi.get(__response__, 'id'),
        job_id=pulumi.get(__response__, 'job_id'),
        number_of_fatal=pulumi.get(__response__, 'number_of_fatal'),
        number_of_fatal_blockers=pulumi.get(__response__, 'number_of_fatal_blockers'),
        number_of_informational_results=pulumi.get(__response__, 'number_of_informational_results'),
        number_of_warnings=pulumi.get(__response__, 'number_of_warnings'),
        report_location_details=pulumi.get(__response__, 'report_location_details'),
        result=pulumi.get(__response__, 'result')))
