# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCatalogPrivateEndpointResult',
    'AwaitableGetCatalogPrivateEndpointResult',
    'get_catalog_private_endpoint',
    'get_catalog_private_endpoint_output',
]

@pulumi.output_type
class GetCatalogPrivateEndpointResult:
    """
    A collection of values returned by getCatalogPrivateEndpoint.
    """
    def __init__(__self__, attached_catalogs=None, catalog_private_endpoint_id=None, compartment_id=None, defined_tags=None, display_name=None, dns_zones=None, freeform_tags=None, id=None, lifecycle_details=None, locks=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None):
        if attached_catalogs and not isinstance(attached_catalogs, list):
            raise TypeError("Expected argument 'attached_catalogs' to be a list")
        pulumi.set(__self__, "attached_catalogs", attached_catalogs)
        if catalog_private_endpoint_id and not isinstance(catalog_private_endpoint_id, str):
            raise TypeError("Expected argument 'catalog_private_endpoint_id' to be a str")
        pulumi.set(__self__, "catalog_private_endpoint_id", catalog_private_endpoint_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns_zones and not isinstance(dns_zones, list):
            raise TypeError("Expected argument 'dns_zones' to be a list")
        pulumi.set(__self__, "dns_zones", dns_zones)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedCatalogs")
    def attached_catalogs(self) -> Sequence[builtins.str]:
        """
        The list of catalogs using the private reverse connection endpoint
        """
        return pulumi.get(self, "attached_catalogs")

    @property
    @pulumi.getter(name="catalogPrivateEndpointId")
    def catalog_private_endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "catalog_private_endpoint_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Identifier of the compartment this private endpoint belongs to
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Mutable name of the Private Reverse Connection Endpoint
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[builtins.str]:
        """
        List of DNS zones to be used by the data assets to be harvested. Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier that is immutable
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetCatalogPrivateEndpointLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the private endpoint resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCatalogPrivateEndpointResult(GetCatalogPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogPrivateEndpointResult(
            attached_catalogs=self.attached_catalogs,
            catalog_private_endpoint_id=self.catalog_private_endpoint_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dns_zones=self.dns_zones,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            locks=self.locks,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_catalog_private_endpoint(catalog_private_endpoint_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogPrivateEndpointResult:
    """
    This data source provides details about a specific Catalog Private Endpoint resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific private reverse connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_private_endpoint = oci.DataCatalog.get_catalog_private_endpoint(catalog_private_endpoint_id=test_catalog_private_endpoint_oci_datacatalog_catalog_private_endpoint["id"])
    ```


    :param builtins.str catalog_private_endpoint_id: Unique private reverse connection identifier.
    """
    __args__ = dict()
    __args__['catalogPrivateEndpointId'] = catalog_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getCatalogPrivateEndpoint:getCatalogPrivateEndpoint', __args__, opts=opts, typ=GetCatalogPrivateEndpointResult).value

    return AwaitableGetCatalogPrivateEndpointResult(
        attached_catalogs=pulumi.get(__ret__, 'attached_catalogs'),
        catalog_private_endpoint_id=pulumi.get(__ret__, 'catalog_private_endpoint_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns_zones=pulumi.get(__ret__, 'dns_zones'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_catalog_private_endpoint_output(catalog_private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogPrivateEndpointResult]:
    """
    This data source provides details about a specific Catalog Private Endpoint resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific private reverse connection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_private_endpoint = oci.DataCatalog.get_catalog_private_endpoint(catalog_private_endpoint_id=test_catalog_private_endpoint_oci_datacatalog_catalog_private_endpoint["id"])
    ```


    :param builtins.str catalog_private_endpoint_id: Unique private reverse connection identifier.
    """
    __args__ = dict()
    __args__['catalogPrivateEndpointId'] = catalog_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataCatalog/getCatalogPrivateEndpoint:getCatalogPrivateEndpoint', __args__, opts=opts, typ=GetCatalogPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetCatalogPrivateEndpointResult(
        attached_catalogs=pulumi.get(__response__, 'attached_catalogs'),
        catalog_private_endpoint_id=pulumi.get(__response__, 'catalog_private_endpoint_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        dns_zones=pulumi.get(__response__, 'dns_zones'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        locks=pulumi.get(__response__, 'locks'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
