# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationApplicationLogConfig',
    'ApplicationDriverShapeConfig',
    'ApplicationExecutorShapeConfig',
    'ApplicationParameter',
    'InvokeRunApplicationLogConfig',
    'InvokeRunDriverShapeConfig',
    'InvokeRunExecutorShapeConfig',
    'InvokeRunParameter',
    'PoolConfiguration',
    'PoolConfigurationShapeConfig',
    'PoolPoolMetric',
    'PoolPoolMetricActivelyUsedNodeCount',
    'PoolSchedule',
    'PrivateEndpointScanDetail',
    'RunStatementOutput',
    'RunStatementOutputData',
    'SqlEndpointDriverShapeConfig',
    'SqlEndpointExecutorShapeConfig',
    'SqlEndpointNetworkConfiguration',
    'SqlEndpointNetworkConfigurationAccessControlRule',
    'GetApplicationApplicationLogConfigResult',
    'GetApplicationDriverShapeConfigResult',
    'GetApplicationExecutorShapeConfigResult',
    'GetApplicationParameterResult',
    'GetApplicationsApplicationResult',
    'GetApplicationsApplicationApplicationLogConfigResult',
    'GetApplicationsApplicationDriverShapeConfigResult',
    'GetApplicationsApplicationExecutorShapeConfigResult',
    'GetApplicationsApplicationParameterResult',
    'GetApplicationsFilterResult',
    'GetInvokeRunApplicationLogConfigResult',
    'GetInvokeRunDriverShapeConfigResult',
    'GetInvokeRunExecutorShapeConfigResult',
    'GetInvokeRunParameterResult',
    'GetInvokeRunsFilterResult',
    'GetInvokeRunsRunResult',
    'GetInvokeRunsRunApplicationLogConfigResult',
    'GetInvokeRunsRunDriverShapeConfigResult',
    'GetInvokeRunsRunExecutorShapeConfigResult',
    'GetInvokeRunsRunParameterResult',
    'GetPoolConfigurationResult',
    'GetPoolConfigurationShapeConfigResult',
    'GetPoolPoolMetricResult',
    'GetPoolPoolMetricActivelyUsedNodeCountResult',
    'GetPoolScheduleResult',
    'GetPoolsFilterResult',
    'GetPoolsPoolCollectionResult',
    'GetPoolsPoolCollectionItemResult',
    'GetPoolsPoolCollectionItemConfigurationResult',
    'GetPoolsPoolCollectionItemConfigurationShapeConfigResult',
    'GetPoolsPoolCollectionItemPoolMetricResult',
    'GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult',
    'GetPoolsPoolCollectionItemScheduleResult',
    'GetPrivateEndpointScanDetailResult',
    'GetPrivateEndpointsFilterResult',
    'GetPrivateEndpointsPrivateEndpointCollectionResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult',
    'GetRunLogsFilterResult',
    'GetRunLogsRunLogResult',
    'GetRunStatementOutputResult',
    'GetRunStatementOutputDataResult',
    'GetRunStatementsFilterResult',
    'GetRunStatementsStatementCollectionResult',
    'GetRunStatementsStatementCollectionItemResult',
    'GetRunStatementsStatementCollectionItemOutputResult',
    'GetRunStatementsStatementCollectionItemOutputDataResult',
    'GetSqlEndpointDriverShapeConfigResult',
    'GetSqlEndpointExecutorShapeConfigResult',
    'GetSqlEndpointNetworkConfigurationResult',
    'GetSqlEndpointNetworkConfigurationAccessControlRuleResult',
    'GetSqlEndpointsFilterResult',
    'GetSqlEndpointsSqlEndpointCollectionResult',
    'GetSqlEndpointsSqlEndpointCollectionItemResult',
    'GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult',
    'GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult',
]

@pulumi.output_type
class ApplicationApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: (Updatable) The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class ApplicationDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class ApplicationParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InvokeRunApplicationLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupId":
            suggest = "log_group_id"
        elif key == "logId":
            suggest = "log_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunApplicationLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunApplicationLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class InvokeRunDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvokeRunExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvokeRunExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class InvokeRunParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PoolConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shapeConfig":
            suggest = "shape_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max: Optional[builtins.int] = None,
                 min: Optional[builtins.int] = None,
                 shape: Optional[builtins.str] = None,
                 shape_config: Optional['outputs.PoolConfigurationShapeConfig'] = None):
        """
        :param builtins.int max: (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        :param builtins.int min: (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        :param builtins.str shape: (Updatable) The compute shape of the resources you would like to provision.
        :param 'PoolConfigurationShapeConfigArgs' shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)

    @property
    @pulumi.getter
    def max(self) -> Optional[builtins.int]:
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[builtins.int]:
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> Optional[builtins.str]:
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional['outputs.PoolConfigurationShapeConfig']:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_config")


@pulumi.output_type
class PoolConfigurationShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolConfigurationShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolConfigurationShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param builtins.float ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class PoolPoolMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRunsCount":
            suggest = "active_runs_count"
        elif key == "activelyUsedNodeCounts":
            suggest = "actively_used_node_counts"
        elif key == "timeLastMetricsUpdated":
            suggest = "time_last_metrics_updated"
        elif key == "timeLastStarted":
            suggest = "time_last_started"
        elif key == "timeLastStopped":
            suggest = "time_last_stopped"
        elif key == "timeLastUsed":
            suggest = "time_last_used"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_runs_count: Optional[builtins.str] = None,
                 actively_used_node_counts: Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']] = None,
                 time_last_metrics_updated: Optional[builtins.str] = None,
                 time_last_started: Optional[builtins.str] = None,
                 time_last_stopped: Optional[builtins.str] = None,
                 time_last_used: Optional[builtins.str] = None):
        """
        :param builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['PoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param builtins.str time_last_started: The last time this pool was started.
        :param builtins.str time_last_stopped: The last time this pool was stopped.
        :param builtins.str time_last_used: The last time a run used this pool.
        """
        if active_runs_count is not None:
            pulumi.set(__self__, "active_runs_count", active_runs_count)
        if actively_used_node_counts is not None:
            pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        if time_last_metrics_updated is not None:
            pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        if time_last_started is not None:
            pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped is not None:
            pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_last_used is not None:
            pulumi.set(__self__, "time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> Optional[builtins.str]:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Optional[Sequence['outputs.PoolPoolMetricActivelyUsedNodeCount']]:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> Optional[builtins.str]:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[builtins.str]:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[builtins.str]:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[builtins.str]:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class PoolPoolMetricActivelyUsedNodeCount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicalShape":
            suggest = "logical_shape"
        elif key == "poolCount":
            suggest = "pool_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPoolMetricActivelyUsedNodeCount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPoolMetricActivelyUsedNodeCount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logical_shape: Optional[builtins.str] = None,
                 pool_count: Optional[builtins.int] = None):
        """
        :param builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param builtins.int pool_count: The node count of this compute shape.
        """
        if logical_shape is not None:
            pulumi.set(__self__, "logical_shape", logical_shape)
        if pool_count is not None:
            pulumi.set(__self__, "pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> Optional[builtins.str]:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[builtins.int]:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class PoolSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "stopTime":
            suggest = "stop_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[builtins.str] = None,
                 start_time: Optional[builtins.int] = None,
                 stop_time: Optional[builtins.int] = None):
        """
        :param builtins.str day_of_week: (Updatable) Day of the week SUN-SAT
        :param builtins.int start_time: (Updatable) Hour of the day to start or stop pool.
        :param builtins.int stop_time: (Updatable) Hour of the day to stop the pool.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if stop_time is not None:
            pulumi.set(__self__, "stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[builtins.str]:
        """
        (Updatable) Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[builtins.int]:
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[builtins.int]:
        """
        (Updatable) Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class PrivateEndpointScanDetail(dict):
    def __init__(__self__, *,
                 fqdn: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None):
        """
        :param builtins.str fqdn: (Updatable) A fully-qualified domain name (FQDN).
        :param builtins.str port: (Updatable) The port number of the FQDN
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        (Updatable) The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class RunStatementOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorName":
            suggest = "error_name"
        elif key == "errorValue":
            suggest = "error_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunStatementOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunStatementOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datas: Optional[Sequence['outputs.RunStatementOutputData']] = None,
                 error_name: Optional[builtins.str] = None,
                 error_value: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 tracebacks: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence['RunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param builtins.str error_name: The name of the error in the statement output.
        :param builtins.str error_value: The value of the error in the statement output.
        :param builtins.str status: Status of the statement output.
        :param Sequence[builtins.str] tracebacks: The traceback of the statement output.
        """
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if error_name is not None:
            pulumi.set(__self__, "error_name", error_name)
        if error_value is not None:
            pulumi.set(__self__, "error_value", error_value)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tracebacks is not None:
            pulumi.set(__self__, "tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Optional[Sequence['outputs.RunStatementOutputData']]:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> Optional[builtins.str]:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> Optional[builtins.str]:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Optional[Sequence[builtins.str]]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class RunStatementOutputData(dict):
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param builtins.str value: The statement code execution output in html format.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SqlEndpointDriverShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointDriverShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointDriverShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointExecutorShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointExecutorShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointExecutorShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[builtins.float] = None,
                 ocpus: Optional[builtins.float] = None):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[builtins.float]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[builtins.float]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class SqlEndpointNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkType":
            suggest = "network_type"
        elif key == "accessControlRules":
            suggest = "access_control_rules"
        elif key == "hostNamePrefix":
            suggest = "host_name_prefix"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "publicEndpointIp":
            suggest = "public_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_type: builtins.str,
                 access_control_rules: Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']] = None,
                 host_name_prefix: Optional[builtins.str] = None,
                 nsg_ids: Optional[Sequence[builtins.str]] = None,
                 private_endpoint_ip: Optional[builtins.str] = None,
                 public_endpoint_ip: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 vcn_id: Optional[builtins.str] = None):
        """
        :param builtins.str network_type: The type of network configuration.
        :param Sequence['SqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param builtins.str host_name_prefix: The host name prefix.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param builtins.str subnet_id: The VCN Subnet OCID.
        :param builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "network_type", network_type)
        if access_control_rules is not None:
            pulumi.set(__self__, "access_control_rules", access_control_rules)
        if host_name_prefix is not None:
            pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if public_endpoint_ip is not None:
            pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Optional[Sequence['outputs.SqlEndpointNetworkConfigurationAccessControlRule']]:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[builtins.str]:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[builtins.str]:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> Optional[builtins.str]:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[builtins.str]:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class SqlEndpointNetworkConfigurationAccessControlRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipNotation":
            suggest = "ip_notation"
        elif key == "vcnIps":
            suggest = "vcn_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlEndpointNetworkConfigurationAccessControlRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlEndpointNetworkConfigurationAccessControlRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_notation: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None,
                 vcn_ips: Optional[builtins.str] = None):
        """
        :param builtins.str ip_notation: The type of IP notation.
        :param builtins.str value: The associated value of the selected IP notation.
        :param builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        if ip_notation is not None:
            pulumi.set(__self__, "ip_notation", ip_notation)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vcn_ips is not None:
            pulumi.set(__self__, "vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> Optional[builtins.str]:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> Optional[builtins.str]:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 application_log_configs: Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult'],
                 archive_uri: builtins.str,
                 arguments: Sequence[builtins.str],
                 class_name: builtins.str,
                 compartment_id: builtins.str,
                 configuration: Mapping[str, builtins.str],
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 driver_shape: builtins.str,
                 driver_shape_configs: Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult'],
                 execute: builtins.str,
                 executor_shape: builtins.str,
                 executor_shape_configs: Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult'],
                 file_uri: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 idle_timeout_in_minutes: builtins.str,
                 language: builtins.str,
                 logs_bucket_uri: builtins.str,
                 max_duration_in_minutes: builtins.str,
                 metastore_id: builtins.str,
                 num_executors: builtins.int,
                 owner_principal_id: builtins.str,
                 owner_user_name: builtins.str,
                 parameters: Sequence['outputs.GetApplicationsApplicationParameterResult'],
                 pool_id: builtins.str,
                 private_endpoint_id: builtins.str,
                 spark_version: builtins.str,
                 state: builtins.str,
                 terminate_runs_on_deletion: builtins.bool,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str,
                 warehouse_bucket_uri: builtins.str):
        """
        :param Sequence['GetApplicationsApplicationApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param builtins.str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[builtins.str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param builtins.str class_name: The class for the application.
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: A user-friendly description.
        :param builtins.str display_name: The query parameter for the Spark application name.
        :param builtins.str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetApplicationsApplicationDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param builtins.str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param builtins.str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetApplicationsApplicationExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param builtins.str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The application ID.
        :param builtins.str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param builtins.str language: The Spark language.
        :param builtins.str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param builtins.str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param builtins.int num_executors: The number of executor VMs requested.
        :param builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetApplicationsApplicationParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param builtins.str pool_id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param builtins.str private_endpoint_id: The OCID of a private endpoint.
        :param builtins.str spark_version: The Spark version utilized to run the application.
        :param builtins.str state: The current state of this application.
        :param builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.str type: The Spark application processing type.
        :param builtins.str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        pulumi.set(__self__, "application_log_configs", application_log_configs)
        pulumi.set(__self__, "archive_uri", archive_uri)
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "execute", execute)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "file_uri", file_uri)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "num_executors", num_executors)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "spark_version", spark_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "terminate_runs_on_deletion", terminate_runs_on_deletion)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetApplicationsApplicationApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> builtins.str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[builtins.str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> builtins.str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> Mapping[str, builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> builtins.str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter
    def execute(self) -> builtins.str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> builtins.str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetApplicationsApplicationExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The application ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> builtins.str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> builtins.str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> builtins.int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetApplicationsApplicationParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> builtins.str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> builtins.str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of this application.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminateRunsOnDeletion")
    def terminate_runs_on_deletion(self) -> builtins.bool:
        return pulumi.get(self, "terminate_runs_on_deletion")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetApplicationsApplicationApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetApplicationsApplicationDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetApplicationsApplicationParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetApplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInvokeRunsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetInvokeRunsRunResult(dict):
    def __init__(__self__, *,
                 application_id: builtins.str,
                 application_log_configs: Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult'],
                 archive_uri: builtins.str,
                 arguments: Sequence[builtins.str],
                 asynchronous: builtins.bool,
                 class_name: builtins.str,
                 compartment_id: builtins.str,
                 configuration: Mapping[str, builtins.str],
                 data_read_in_bytes: builtins.str,
                 data_written_in_bytes: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 driver_shape: builtins.str,
                 driver_shape_configs: Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult'],
                 execute: builtins.str,
                 executor_shape: builtins.str,
                 executor_shape_configs: Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult'],
                 file_uri: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 idle_timeout_in_minutes: builtins.str,
                 language: builtins.str,
                 lifecycle_details: builtins.str,
                 logs_bucket_uri: builtins.str,
                 max_duration_in_minutes: builtins.str,
                 metastore_id: builtins.str,
                 num_executors: builtins.int,
                 opc_parent_rpt_url: builtins.str,
                 opc_request_id: builtins.str,
                 owner_principal_id: builtins.str,
                 owner_user_name: builtins.str,
                 parameters: Sequence['outputs.GetInvokeRunsRunParameterResult'],
                 pool_id: builtins.str,
                 private_endpoint_dns_zones: Sequence[builtins.str],
                 private_endpoint_id: builtins.str,
                 private_endpoint_max_host_count: builtins.int,
                 private_endpoint_nsg_ids: Sequence[builtins.str],
                 private_endpoint_subnet_id: builtins.str,
                 run_duration_in_milliseconds: builtins.str,
                 spark_version: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 total_ocpu: builtins.int,
                 type: builtins.str,
                 warehouse_bucket_uri: builtins.str):
        """
        :param builtins.str application_id: The ID of the application.
        :param Sequence['GetInvokeRunsRunApplicationLogConfigArgs'] application_log_configs: Logging details of Application logs for Data Flow Run.
        :param builtins.str archive_uri: A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Sequence[builtins.str] arguments: The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        :param builtins.str class_name: The class for the application.
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] configuration: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param builtins.str data_read_in_bytes: The data read by the run in bytes.
        :param builtins.str data_written_in_bytes: The data written by the run in bytes.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: The query parameter for the Spark application name.
        :param builtins.str driver_shape: The VM shape for the driver. Sets the driver cores and memory.
        :param Sequence['GetInvokeRunsRunDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param builtins.str execute: The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        :param builtins.str executor_shape: The VM shape for the executors. Sets the executor cores and memory.
        :param Sequence['GetInvokeRunsRunExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param builtins.str file_uri: An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The ID of a run.
        :param builtins.str idle_timeout_in_minutes: The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        :param builtins.str language: The Spark language.
        :param builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param builtins.str logs_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        :param builtins.str max_duration_in_minutes: The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        :param builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param builtins.int num_executors: The number of executor VMs requested.
        :param builtins.str opc_request_id: Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        :param builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetInvokeRunsRunParameterArgs'] parameters: An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        :param builtins.str pool_id: The ID of the pool.
        :param Sequence[builtins.str] private_endpoint_dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param builtins.str private_endpoint_id: The OCID of a private endpoint.
        :param builtins.int private_endpoint_max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[builtins.str] private_endpoint_nsg_ids: An array of network security group OCIDs.
        :param builtins.str private_endpoint_subnet_id: The OCID of a subnet.
        :param builtins.str run_duration_in_milliseconds: The duration of the run in milliseconds.
        :param builtins.str spark_version: The Spark version utilized to run the application.
        :param builtins.str state: The LifecycleState of the run.
        :param builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.int total_ocpu: The total number of oCPU requested by the run.
        :param builtins.str type: The Spark application processing type.
        :param builtins.str warehouse_bucket_uri: An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_log_configs", application_log_configs)
        pulumi.set(__self__, "archive_uri", archive_uri)
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "asynchronous", asynchronous)
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "data_read_in_bytes", data_read_in_bytes)
        pulumi.set(__self__, "data_written_in_bytes", data_written_in_bytes)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "execute", execute)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "file_uri", file_uri)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "logs_bucket_uri", logs_bucket_uri)
        pulumi.set(__self__, "max_duration_in_minutes", max_duration_in_minutes)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "num_executors", num_executors)
        pulumi.set(__self__, "opc_parent_rpt_url", opc_parent_rpt_url)
        pulumi.set(__self__, "opc_request_id", opc_request_id)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "private_endpoint_dns_zones", private_endpoint_dns_zones)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        pulumi.set(__self__, "private_endpoint_max_host_count", private_endpoint_max_host_count)
        pulumi.set(__self__, "private_endpoint_nsg_ids", private_endpoint_nsg_ids)
        pulumi.set(__self__, "private_endpoint_subnet_id", private_endpoint_subnet_id)
        pulumi.set(__self__, "run_duration_in_milliseconds", run_duration_in_milliseconds)
        pulumi.set(__self__, "spark_version", spark_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_ocpu", total_ocpu)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> builtins.str:
        """
        The ID of the application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationLogConfigs")
    def application_log_configs(self) -> Sequence['outputs.GetInvokeRunsRunApplicationLogConfigResult']:
        """
        Logging details of Application logs for Data Flow Run.
        """
        return pulumi.get(self, "application_log_configs")

    @property
    @pulumi.getter(name="archiveUri")
    def archive_uri(self) -> builtins.str:
        """
        A comma separated list of one or more archive files as Oracle Cloud Infrastructure URIs. For example, ``oci://path/to/a.zip,oci://path/to/b.zip``. An Oracle Cloud Infrastructure URI of an archive.zip file containing custom dependencies that may be used to support the execution of a Python, Java, or Scala application. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "archive_uri")

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[builtins.str]:
        """
        The arguments passed to the running application as command line arguments.  An argument is either a plain text or a placeholder. Placeholders are replaced using values from the parameters map.  Each placeholder specified must be represented in the parameters map else the request (POST or PUT) will fail with a HTTP 400 status code.  Placeholders are specified as `Service Api Spec`, where `name` is the name of the parameter. Example:  `[ "--input", "${input_file}", "--name", "John Doe" ]` If "input_file" has a value of "mydata.xml", then the value above will be translated to `--input mydata.xml --name "John Doe"`
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def asynchronous(self) -> builtins.bool:
        return pulumi.get(self, "asynchronous")

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> builtins.str:
        """
        The class for the application.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configuration(self) -> Mapping[str, builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="dataReadInBytes")
    def data_read_in_bytes(self) -> builtins.str:
        """
        The data read by the run in bytes.
        """
        return pulumi.get(self, "data_read_in_bytes")

    @property
    @pulumi.getter(name="dataWrittenInBytes")
    def data_written_in_bytes(self) -> builtins.str:
        """
        The data written by the run in bytes.
        """
        return pulumi.get(self, "data_written_in_bytes")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> builtins.str:
        """
        The VM shape for the driver. Sets the driver cores and memory.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter
    def execute(self) -> builtins.str:
        """
        The input used for spark-submit command. For more details see https://spark.apache.org/docs/latest/submitting-applications.html#launching-applications-with-spark-submit. Supported options include ``--class``, ``--file``, ``--jars``, ``--conf``, ``--py-files``, and main application file with arguments. Example: ``--jars oci://path/to/a.jar,oci://path/to/b.jar --files oci://path/to/a.json,oci://path/to/b.csv --py-files oci://path/to/a.py,oci://path/to/b.py --conf spark.sql.crossJoin.enabled=true --class org.apache.spark.examples.SparkPi oci://path/to/main.jar 10`` Note: If execute is specified together with applicationId, className, configuration, fileUri, language, arguments, parameters during application create/update, or run create/submit, Data Flow service will use derived information from execute input only.
        """
        return pulumi.get(self, "execute")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> builtins.str:
        """
        The VM shape for the executors. Sets the executor cores and memory.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetInvokeRunsRunExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the file containing the application to execute. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "file_uri")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of a run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> builtins.str:
        """
        The timeout value in minutes used to manage Runs. A Run would be stopped after inactivity for this amount of time period. Note: This parameter is currently only applicable for Runs of type `SESSION`. Default value is 2880 minutes (2 days)
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        The Spark language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logsBucketUri")
    def logs_bucket_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket where the Spark job logs are to be uploaded. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "logs_bucket_uri")

    @property
    @pulumi.getter(name="maxDurationInMinutes")
    def max_duration_in_minutes(self) -> builtins.str:
        """
        The maximum duration in minutes for which an Application should run. Data Flow Run would be terminated once it reaches this duration from the time it transitions to `IN_PROGRESS` state.
        """
        return pulumi.get(self, "max_duration_in_minutes")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="numExecutors")
    def num_executors(self) -> builtins.int:
        """
        The number of executor VMs requested.
        """
        return pulumi.get(self, "num_executors")

    @property
    @pulumi.getter(name="opcParentRptUrl")
    def opc_parent_rpt_url(self) -> builtins.str:
        return pulumi.get(self, "opc_parent_rpt_url")

    @property
    @pulumi.getter(name="opcRequestId")
    def opc_request_id(self) -> builtins.str:
        """
        Unique Oracle assigned identifier for the request. If you need to contact Oracle about a particular request, please provide the request ID.
        """
        return pulumi.get(self, "opc_request_id")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetInvokeRunsRunParameterResult']:
        """
        An array of name/value pairs used to fill placeholders found in properties like `Application.arguments`.  The name must be a string of one or more word characters (a-z, A-Z, 0-9, _).  The value can be a string of 0 or more characters of any kind. Example:  [ { name: "iterations", value: "10"}, { name: "input_file", value: "mydata.xml" }, { name: "variable_x", value: "${x}"} ]
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> builtins.str:
        """
        The ID of the pool.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="privateEndpointDnsZones")
    def private_endpoint_dns_zones(self) -> Sequence[builtins.str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "private_endpoint_dns_zones")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="privateEndpointMaxHostCount")
    def private_endpoint_max_host_count(self) -> builtins.int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "private_endpoint_max_host_count")

    @property
    @pulumi.getter(name="privateEndpointNsgIds")
    def private_endpoint_nsg_ids(self) -> Sequence[builtins.str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "private_endpoint_nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointSubnetId")
    def private_endpoint_subnet_id(self) -> builtins.str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "private_endpoint_subnet_id")

    @property
    @pulumi.getter(name="runDurationInMilliseconds")
    def run_duration_in_milliseconds(self) -> builtins.str:
        """
        The duration of the run in milliseconds.
        """
        return pulumi.get(self, "run_duration_in_milliseconds")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> builtins.str:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The LifecycleState of the run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpu")
    def total_ocpu(self) -> builtins.int:
        """
        The total number of oCPU requested by the run.
        """
        return pulumi.get(self, "total_ocpu")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The Spark application processing type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> builtins.str:
        """
        An Oracle Cloud Infrastructure URI of the bucket to be used as default warehouse directory for BATCH SQL runs. See https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/hdfsconnector.htm#uriformat.
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetInvokeRunsRunApplicationLogConfigResult(dict):
    def __init__(__self__, *,
                 log_group_id: builtins.str,
                 log_id: builtins.str):
        """
        :param builtins.str log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param builtins.str log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> builtins.str:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> builtins.str:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")


@pulumi.output_type
class GetInvokeRunsRunDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetInvokeRunsRunParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param builtins.str value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetPoolConfigurationResult(dict):
    def __init__(__self__, *,
                 max: builtins.int,
                 min: builtins.int,
                 shape: builtins.str,
                 shape_configs: Sequence['outputs.GetPoolConfigurationShapeConfigResult']):
        """
        :param builtins.int max: Maximum number of compute instances in the pool for a given compute shape.
        :param builtins.int min: Minimum number of compute instances in the pool for a given compute shape.
        :param builtins.str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_configs", shape_configs)

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: builtins.str,
                 actively_used_node_counts: Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: builtins.str,
                 time_last_started: builtins.str,
                 time_last_stopped: builtins.str,
                 time_last_used: builtins.str):
        """
        :param builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param builtins.str time_last_started: The last time this pool was started.
        :param builtins.str time_last_stopped: The last time this pool was stopped.
        :param builtins.str time_last_used: The last time a run used this pool.
        """
        pulumi.set(__self__, "active_runs_count", active_runs_count)
        pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        pulumi.set(__self__, "time_last_started", time_last_started)
        pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        pulumi.set(__self__, "time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> builtins.str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> builtins.str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> builtins.str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> builtins.str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> builtins.str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: builtins.str,
                 pool_count: builtins.int):
        """
        :param builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param builtins.int pool_count: The node count of this compute shape.
        """
        pulumi.set(__self__, "logical_shape", logical_shape)
        pulumi.set(__self__, "pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> builtins.str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> builtins.int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 start_time: builtins.int,
                 stop_time: builtins.int):
        """
        :param builtins.str day_of_week: Day of the week SUN-SAT
        :param builtins.int start_time: Hour of the day to start or stop pool.
        :param builtins.int stop_time: Hour of the day to stop the pool.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> builtins.int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPoolsPoolCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPoolsPoolCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPoolsPoolCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPoolsPoolCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 configurations: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult'],
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 idle_timeout_in_minutes: builtins.int,
                 lifecycle_details: builtins.str,
                 owner_principal_id: builtins.str,
                 owner_user_name: builtins.str,
                 pool_metrics: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult'],
                 schedules: Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult'],
                 state: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationArgs'] configurations: List of PoolConfig items.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: A user-friendly description. Avoid entering confidential information.
        :param builtins.str display_name: The query parameter for the Spark application name.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        :param builtins.int idle_timeout_in_minutes: Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        :param builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricArgs'] pool_metrics: A collection of metrics related to a particular pool.
        :param Sequence['GetPoolsPoolCollectionItemScheduleArgs'] schedules: A list of schedules for pool to auto start and stop.
        :param builtins.str state: The LifecycleState of the pool.
        :param builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "pool_metrics", pool_metrics)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationResult']:
        """
        List of PoolConfig items.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of a pool. Unique Id to indentify a dataflow pool resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> builtins.int:
        """
        Optional timeout value in minutes used to auto stop Pools. A Pool will be auto stopped after inactivity for this amount of time period. If value not set, pool will not be auto stopped auto.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter(name="poolMetrics")
    def pool_metrics(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricResult']:
        """
        A collection of metrics related to a particular pool.
        """
        return pulumi.get(self, "pool_metrics")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetPoolsPoolCollectionItemScheduleResult']:
        """
        A list of schedules for pool to auto start and stop.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The LifecycleState of the pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationResult(dict):
    def __init__(__self__, *,
                 max: builtins.int,
                 min: builtins.int,
                 shape: builtins.str,
                 shape_configs: Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']):
        """
        :param builtins.int max: Maximum number of compute instances in the pool for a given compute shape.
        :param builtins.int min: Minimum number of compute instances in the pool for a given compute shape.
        :param builtins.str shape: The compute shape of the resources you would like to provision.
        :param Sequence['GetPoolsPoolCollectionItemConfigurationShapeConfigArgs'] shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "shape_configs", shape_configs)

    @property
    @pulumi.getter
    def max(self) -> builtins.int:
        """
        Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> builtins.int:
        """
        Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter
    def shape(self) -> builtins.str:
        """
        The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfigs")
    def shape_configs(self) -> Sequence['outputs.GetPoolsPoolCollectionItemConfigurationShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_configs")


@pulumi.output_type
class GetPoolsPoolCollectionItemConfigurationShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricResult(dict):
    def __init__(__self__, *,
                 active_runs_count: builtins.str,
                 actively_used_node_counts: Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult'],
                 time_last_metrics_updated: builtins.str,
                 time_last_started: builtins.str,
                 time_last_stopped: builtins.str,
                 time_last_used: builtins.str):
        """
        :param builtins.str active_runs_count: The number of runs that are currently running that are using this pool.
        :param Sequence['GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountArgs'] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param builtins.str time_last_metrics_updated: The last time the mertics were updated for this.
        :param builtins.str time_last_started: The last time this pool was started.
        :param builtins.str time_last_stopped: The last time this pool was stopped.
        :param builtins.str time_last_used: The last time a run used this pool.
        """
        pulumi.set(__self__, "active_runs_count", active_runs_count)
        pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        pulumi.set(__self__, "time_last_started", time_last_started)
        pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        pulumi.set(__self__, "time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> builtins.str:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Sequence['outputs.GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult']:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> builtins.str:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> builtins.str:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> builtins.str:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> builtins.str:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")


@pulumi.output_type
class GetPoolsPoolCollectionItemPoolMetricActivelyUsedNodeCountResult(dict):
    def __init__(__self__, *,
                 logical_shape: builtins.str,
                 pool_count: builtins.int):
        """
        :param builtins.str logical_shape: The compute shape of the nodes that the count is for.
        :param builtins.int pool_count: The node count of this compute shape.
        """
        pulumi.set(__self__, "logical_shape", logical_shape)
        pulumi.set(__self__, "pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> builtins.str:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> builtins.int:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")


@pulumi.output_type
class GetPoolsPoolCollectionItemScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: builtins.str,
                 start_time: builtins.int,
                 stop_time: builtins.int):
        """
        :param builtins.str day_of_week: Day of the week SUN-SAT
        :param builtins.int start_time: Hour of the day to start or stop pool.
        :param builtins.int stop_time: Hour of the day to stop the pool.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.int:
        """
        Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> builtins.int:
        """
        Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetPrivateEndpointScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str fqdn: A fully-qualified domain name (FQDN).
        :param builtins.str port: The port number of the FQDN
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 dns_zones: Sequence[builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 max_host_count: builtins.int,
                 nsg_ids: Sequence[builtins.str],
                 owner_principal_id: builtins.str,
                 owner_user_name: builtins.str,
                 scan_details: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult'],
                 state: builtins.str,
                 subnet_id: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: A user-friendly description. Avoid entering confidential information.
        :param builtins.str display_name: The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        :param Sequence[builtins.str] dns_zones: An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of a private endpoint.
        :param builtins.str lifecycle_details: The detailed messages about the lifecycle state.
        :param builtins.int max_host_count: The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        :param Sequence[builtins.str] nsg_ids: An array of network security group OCIDs.
        :param builtins.str owner_principal_id: The OCID of the user who created the resource.
        :param builtins.str owner_user_name: The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        :param Sequence['GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailArgs'] scan_details: An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        :param builtins.str state: The LifecycleState of the private endpoint.
        :param builtins.str subnet_id: The OCID of a subnet.
        :param builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_zones", dns_zones)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_host_count", max_host_count)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        pulumi.set(__self__, "owner_user_name", owner_user_name)
        pulumi.set(__self__, "scan_details", scan_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The query parameter for the Spark application name. Note: At a time only one optional filter can be used with `compartment_id` to get the list of Private Endpoint resources.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsZones")
    def dns_zones(self) -> Sequence[builtins.str]:
        """
        An array of DNS zone names. Example: `[ "app.examplecorp.com", "app.examplecorp2.com" ]`
        """
        return pulumi.get(self, "dns_zones")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of a private endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        The detailed messages about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxHostCount")
    def max_host_count(self) -> builtins.int:
        """
        The maximum number of hosts to be accessed through the private endpoint. This value is used to calculate the relevant CIDR block and should be a multiple of 256.  If the value is not a multiple of 256, it is rounded up to the next multiple of 256. For example, 300 is rounded up to 512.
        """
        return pulumi.get(self, "max_host_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        An array of network security group OCIDs.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> builtins.str:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="ownerUserName")
    def owner_user_name(self) -> builtins.str:
        """
        The username of the user who created the resource.  If the username of the owner does not exist, `null` will be returned and the caller should refer to the ownerPrincipalId value instead.
        """
        return pulumi.get(self, "owner_user_name")

    @property
    @pulumi.getter(name="scanDetails")
    def scan_details(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult']:
        """
        An array of fqdn/port pairs used to create private endpoint. Each object is a simple key-value pair with FQDN as key and port number as value. [ { fqdn: "scan1.oracle.com", port: "1521"}, { fqdn: "scan2.oracle.com", port: "1521" } ]
        """
        return pulumi.get(self, "scan_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The LifecycleState of the private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The OCID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemScanDetailResult(dict):
    def __init__(__self__, *,
                 fqdn: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str fqdn: A fully-qualified domain name (FQDN).
        :param builtins.str port: The port number of the FQDN
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        The port number of the FQDN
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetRunLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunLogsRunLogResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 run_id: builtins.str,
                 size_in_bytes: builtins.str,
                 source: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str run_id: The unique ID for the run
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "run_id", run_id)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> builtins.str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> builtins.str:
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRunStatementOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementOutputDataResult'],
                 error_name: builtins.str,
                 error_value: builtins.str,
                 status: builtins.str,
                 tracebacks: Sequence[builtins.str]):
        """
        :param Sequence['GetRunStatementOutputDataArgs'] datas: An object representing execution output of a statement.
        :param builtins.str error_name: The name of the error in the statement output.
        :param builtins.str error_value: The value of the error in the statement output.
        :param builtins.str status: Status of the statement output.
        :param Sequence[builtins.str] tracebacks: The traceback of the statement output.
        """
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "error_name", error_name)
        pulumi.set(__self__, "error_value", error_value)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> builtins.str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> builtins.str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Sequence[builtins.str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementOutputDataResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param builtins.str value: The statement code execution output in html format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRunStatementsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRunStatementsStatementCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRunStatementsStatementCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 id: builtins.str,
                 outputs: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult'],
                 progress: builtins.float,
                 run_id: builtins.str,
                 state: builtins.str,
                 time_completed: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str code: The statement code to execute. Example: `println(sc.version)`
        :param builtins.str id: The statement ID.
        :param Sequence['GetRunStatementsStatementCollectionItemOutputArgs'] outputs: The execution output of a statement.
        :param builtins.float progress: The execution progress.
        :param builtins.str run_id: The unique ID for the run
        :param builtins.str state: The LifecycleState of the statement.
        :param builtins.str time_completed: The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        :param builtins.str time_created: The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "outputs", outputs)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "run_id", run_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_completed", time_completed)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The statement ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def outputs(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputResult']:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def progress(self) -> builtins.float:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> builtins.str:
        """
        The unique ID for the run
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The LifecycleState of the statement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> builtins.str:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputResult(dict):
    def __init__(__self__, *,
                 datas: Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult'],
                 error_name: builtins.str,
                 error_value: builtins.str,
                 status: builtins.str,
                 tracebacks: Sequence[builtins.str]):
        """
        :param Sequence['GetRunStatementsStatementCollectionItemOutputDataArgs'] datas: An object representing execution output of a statement.
        :param builtins.str error_name: The name of the error in the statement output.
        :param builtins.str error_value: The value of the error in the statement output.
        :param builtins.str status: Status of the statement output.
        :param Sequence[builtins.str] tracebacks: The traceback of the statement output.
        """
        pulumi.set(__self__, "datas", datas)
        pulumi.set(__self__, "error_name", error_name)
        pulumi.set(__self__, "error_value", error_value)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.GetRunStatementsStatementCollectionItemOutputDataResult']:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> builtins.str:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> builtins.str:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tracebacks(self) -> Sequence[builtins.str]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")


@pulumi.output_type
class GetRunStatementsStatementCollectionItemOutputDataResult(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param builtins.str value: The statement code execution output in html format.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSqlEndpointDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: builtins.str,
                 network_type: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 private_endpoint_ip: builtins.str,
                 public_endpoint_ip: builtins.str,
                 subnet_id: builtins.str,
                 vcn_id: builtins.str):
        """
        :param Sequence['GetSqlEndpointNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param builtins.str host_name_prefix: The host name prefix.
        :param builtins.str network_type: The type of network configuration.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param builtins.str subnet_id: The VCN Subnet OCID.
        :param builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "access_control_rules", access_control_rules)
        pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> builtins.str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> builtins.str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> builtins.str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: builtins.str,
                 value: builtins.str,
                 vcn_ips: builtins.str):
        """
        :param builtins.str ip_notation: The type of IP notation.
        :param builtins.str value: The associated value of the selected IP notation.
        :param builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        pulumi.set(__self__, "ip_notation", ip_notation)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> builtins.str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> builtins.str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


@pulumi.output_type
class GetSqlEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 driver_shape: builtins.str,
                 driver_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult'],
                 executor_shape: builtins.str,
                 executor_shape_configs: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 jdbc_endpoint_url: builtins.str,
                 lake_id: builtins.str,
                 max_executor_count: builtins.int,
                 metastore_id: builtins.str,
                 min_executor_count: builtins.int,
                 network_configurations: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult'],
                 spark_advanced_configurations: Mapping[str, builtins.str],
                 sql_endpoint_version: builtins.str,
                 state: builtins.str,
                 state_message: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 warehouse_bucket_uri: builtins.str):
        """
        :param builtins.str compartment_id: The OCID of the compartment in which to query resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: The description of the SQL Endpoint.
        :param builtins.str display_name: The query parameter for the Spark application name.
        :param builtins.str driver_shape: The shape of the SQL Endpoint driver instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigArgs'] driver_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param builtins.str executor_shape: The shape of the SQL Endpoint executor instance.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigArgs'] executor_shape_configs: This is used to configure the shape of the driver or executor if a flexible shape is used.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: The provision identifier that is immutable on creation.
        :param builtins.str jdbc_endpoint_url: The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        :param builtins.str lake_id: The OCID of Oracle Cloud Infrastructure Lake.
        :param builtins.int max_executor_count: The maximum number of executors.
        :param builtins.str metastore_id: The OCID of Oracle Cloud Infrastructure Hive Metastore.
        :param builtins.int min_executor_count: The minimum number of executors.
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationArgs'] network_configurations: The network configuration of a SQL Endpoint.
        :param Mapping[str, builtins.str] spark_advanced_configurations: The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        :param builtins.str sql_endpoint_version: The version of SQL Endpoint.
        :param builtins.str state: A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        :param builtins.str state_message: A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        :param Mapping[str, builtins.str] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param builtins.str time_created: The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        :param builtins.str warehouse_bucket_uri: The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "driver_shape", driver_shape)
        pulumi.set(__self__, "driver_shape_configs", driver_shape_configs)
        pulumi.set(__self__, "executor_shape", executor_shape)
        pulumi.set(__self__, "executor_shape_configs", executor_shape_configs)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "jdbc_endpoint_url", jdbc_endpoint_url)
        pulumi.set(__self__, "lake_id", lake_id)
        pulumi.set(__self__, "max_executor_count", max_executor_count)
        pulumi.set(__self__, "metastore_id", metastore_id)
        pulumi.set(__self__, "min_executor_count", min_executor_count)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "spark_advanced_configurations", spark_advanced_configurations)
        pulumi.set(__self__, "sql_endpoint_version", sql_endpoint_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "warehouse_bucket_uri", warehouse_bucket_uri)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment in which to query resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the SQL Endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The query parameter for the Spark application name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="driverShape")
    def driver_shape(self) -> builtins.str:
        """
        The shape of the SQL Endpoint driver instance.
        """
        return pulumi.get(self, "driver_shape")

    @property
    @pulumi.getter(name="driverShapeConfigs")
    def driver_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "driver_shape_configs")

    @property
    @pulumi.getter(name="executorShape")
    def executor_shape(self) -> builtins.str:
        """
        The shape of the SQL Endpoint executor instance.
        """
        return pulumi.get(self, "executor_shape")

    @property
    @pulumi.getter(name="executorShapeConfigs")
    def executor_shape_configs(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult']:
        """
        This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "executor_shape_configs")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provision identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jdbcEndpointUrl")
    def jdbc_endpoint_url(self) -> builtins.str:
        """
        The JDBC URL field. For example, jdbc:spark://{serviceFQDN}:443/default;SparkServerType=DFI
        """
        return pulumi.get(self, "jdbc_endpoint_url")

    @property
    @pulumi.getter(name="lakeId")
    def lake_id(self) -> builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Lake.
        """
        return pulumi.get(self, "lake_id")

    @property
    @pulumi.getter(name="maxExecutorCount")
    def max_executor_count(self) -> builtins.int:
        """
        The maximum number of executors.
        """
        return pulumi.get(self, "max_executor_count")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> builtins.str:
        """
        The OCID of Oracle Cloud Infrastructure Hive Metastore.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="minExecutorCount")
    def min_executor_count(self) -> builtins.int:
        """
        The minimum number of executors.
        """
        return pulumi.get(self, "min_executor_count")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult']:
        """
        The network configuration of a SQL Endpoint.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="sparkAdvancedConfigurations")
    def spark_advanced_configurations(self) -> Mapping[str, builtins.str]:
        """
        The Spark configuration passed to the running process. See https://spark.apache.org/docs/latest/configuration.html#available-properties. Example: { "spark.app.name" : "My App Name", "spark.shuffle.io.maxRetries" : "4" } Note: Not all Spark properties are permitted to be set.  Attempting to set a property that is not allowed to be overwritten will cause a 400 status to be returned.
        """
        return pulumi.get(self, "spark_advanced_configurations")

    @property
    @pulumi.getter(name="sqlEndpointVersion")
    def sql_endpoint_version(self) -> builtins.str:
        """
        The version of SQL Endpoint.
        """
        return pulumi.get(self, "sql_endpoint_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> builtins.str:
        """
        A message describing the reason why the resource is in it's current state. Helps bubble up errors in state changes. For example, it can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Sql Endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sql Endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="warehouseBucketUri")
    def warehouse_bucket_uri(self) -> builtins.str:
        """
        The warehouse bucket URI. It is a Oracle Cloud Infrastructure Object Storage bucket URI as defined here https://docs.oracle.com/en/cloud/paas/atp-cloud/atpud/object-storage-uris.html
        """
        return pulumi.get(self, "warehouse_bucket_uri")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemDriverShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemExecutorShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: builtins.float,
                 ocpus: builtins.float):
        """
        :param builtins.float memory_in_gbs: The amount of memory used for the driver or executors.
        :param builtins.float ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> builtins.float:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> builtins.float:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 access_control_rules: Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult'],
                 host_name_prefix: builtins.str,
                 network_type: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 private_endpoint_ip: builtins.str,
                 public_endpoint_ip: builtins.str,
                 subnet_id: builtins.str,
                 vcn_id: builtins.str):
        """
        :param Sequence['GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleArgs'] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param builtins.str host_name_prefix: The host name prefix.
        :param builtins.str network_type: The type of network configuration.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of Network Security Groups (NSGs).
        :param builtins.str private_endpoint_ip: Ip Address of private endpoint
        :param builtins.str public_endpoint_ip: Ip Address of public endpoint
        :param builtins.str subnet_id: The VCN Subnet OCID.
        :param builtins.str vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "access_control_rules", access_control_rules)
        pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult']:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> builtins.str:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> builtins.str:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of Network Security Groups (NSGs).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> builtins.str:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> builtins.str:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetSqlEndpointsSqlEndpointCollectionItemNetworkConfigurationAccessControlRuleResult(dict):
    def __init__(__self__, *,
                 ip_notation: builtins.str,
                 value: builtins.str,
                 vcn_ips: builtins.str):
        """
        :param builtins.str ip_notation: The type of IP notation.
        :param builtins.str value: The associated value of the selected IP notation.
        :param builtins.str vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        pulumi.set(__self__, "ip_notation", ip_notation)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> builtins.str:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> builtins.str:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")


