# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlertPolicyRuleArgs', 'AlertPolicyRule']

@pulumi.input_type
class AlertPolicyRuleArgs:
    def __init__(__self__, *,
                 alert_policy_id: pulumi.Input[builtins.str],
                 expression: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AlertPolicyRule resource.
        :param pulumi.Input[builtins.str] alert_policy_id: The OCID of the alert policy.
        :param pulumi.Input[builtins.str] expression: (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] description: (Updatable) Describes the alert policy rule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the alert policy rule.
        """
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the alert policy.
        """
        return pulumi.get(self, "alert_policy_id")

    @alert_policy_id.setter
    def alert_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alert_policy_id", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Describes the alert policy rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the alert policy rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _AlertPolicyRuleState:
    def __init__(__self__, *,
                 alert_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlertPolicyRule resources.
        :param pulumi.Input[builtins.str] alert_policy_id: The OCID of the alert policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Describes the alert policy rule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the alert policy rule.
        :param pulumi.Input[builtins.str] expression: (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] key: The unique key of the alert policy rule.
        :param pulumi.Input[builtins.str] state: The current state of the alert policy rule.
        :param pulumi.Input[builtins.str] time_created: Creation date and time of the alert policy rule, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if alert_policy_id is not None:
            pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the alert policy.
        """
        return pulumi.get(self, "alert_policy_id")

    @alert_policy_id.setter
    def alert_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_policy_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Describes the alert policy rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The display name of the alert policy rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique key of the alert policy rule.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the alert policy rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date and time of the alert policy rule, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:DataSafe/alertPolicyRule:AlertPolicyRule")
class AlertPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new rule for the alert policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alert_policy_rule = oci.data_safe.AlertPolicyRule("test_alert_policy_rule",
            alert_policy_id=test_alert_policy["id"],
            expression=alert_policy_rule_expression,
            description=alert_policy_rule_description,
            display_name=alert_policy_rule_display_name)
        ```

        ## Import

        AlertPolicyRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alertPolicyRule:AlertPolicyRule test_alert_policy_rule "alertPolicies/{alertPolicyId}/rules/{ruleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_policy_id: The OCID of the alert policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Describes the alert policy rule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the alert policy rule.
        :param pulumi.Input[builtins.str] expression: (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alert Policy Rule resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new rule for the alert policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alert_policy_rule = oci.data_safe.AlertPolicyRule("test_alert_policy_rule",
            alert_policy_id=test_alert_policy["id"],
            expression=alert_policy_rule_expression,
            description=alert_policy_rule_description,
            display_name=alert_policy_rule_display_name)
        ```

        ## Import

        AlertPolicyRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/alertPolicyRule:AlertPolicyRule test_alert_policy_rule "alertPolicies/{alertPolicyId}/rules/{ruleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param AlertPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertPolicyRuleArgs.__new__(AlertPolicyRuleArgs)

            if alert_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'alert_policy_id'")
            __props__.__dict__["alert_policy_id"] = alert_policy_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            __props__.__dict__["key"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(AlertPolicyRule, __self__).__init__(
            'oci:DataSafe/alertPolicyRule:AlertPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            expression: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'AlertPolicyRule':
        """
        Get an existing AlertPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_policy_id: The OCID of the alert policy.
        :param pulumi.Input[builtins.str] description: (Updatable) Describes the alert policy rule.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The display name of the alert policy rule.
        :param pulumi.Input[builtins.str] expression: (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] key: The unique key of the alert policy rule.
        :param pulumi.Input[builtins.str] state: The current state of the alert policy rule.
        :param pulumi.Input[builtins.str] time_created: Creation date and time of the alert policy rule, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertPolicyRuleState.__new__(_AlertPolicyRuleState)

        __props__.__dict__["alert_policy_id"] = alert_policy_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expression"] = expression
        __props__.__dict__["key"] = key
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return AlertPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the alert policy.
        """
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Describes the alert policy rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The display name of the alert policy rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The conditional expression of the alert policy rule which evaluates to boolean value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The unique key of the alert policy rule.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the alert policy rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Creation date and time of the alert policy rule, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

