# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAuditProfileCollectedAuditVolumesResult',
    'AwaitableGetAuditProfileCollectedAuditVolumesResult',
    'get_audit_profile_collected_audit_volumes',
    'get_audit_profile_collected_audit_volumes_output',
]

@pulumi.output_type
class GetAuditProfileCollectedAuditVolumesResult:
    """
    A collection of values returned by getAuditProfileCollectedAuditVolumes.
    """
    def __init__(__self__, audit_profile_id=None, collected_audit_volume_collections=None, filters=None, id=None, month_in_consideration_greater_than=None, month_in_consideration_less_than=None, work_request_id=None):
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if collected_audit_volume_collections and not isinstance(collected_audit_volume_collections, list):
            raise TypeError("Expected argument 'collected_audit_volume_collections' to be a list")
        pulumi.set(__self__, "collected_audit_volume_collections", collected_audit_volume_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if month_in_consideration_greater_than and not isinstance(month_in_consideration_greater_than, str):
            raise TypeError("Expected argument 'month_in_consideration_greater_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_greater_than", month_in_consideration_greater_than)
        if month_in_consideration_less_than and not isinstance(month_in_consideration_less_than, str):
            raise TypeError("Expected argument 'month_in_consideration_less_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_less_than", month_in_consideration_less_than)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> builtins.str:
        """
        The OCID of the audit profile resource.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="collectedAuditVolumeCollections")
    def collected_audit_volume_collections(self) -> Sequence['outputs.GetAuditProfileCollectedAuditVolumesCollectedAuditVolumeCollectionResult']:
        """
        The list of collected_audit_volume_collection.
        """
        return pulumi.get(self, "collected_audit_volume_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAuditProfileCollectedAuditVolumesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monthInConsiderationGreaterThan")
    def month_in_consideration_greater_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "month_in_consideration_greater_than")

    @property
    @pulumi.getter(name="monthInConsiderationLessThan")
    def month_in_consideration_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "month_in_consideration_less_than")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> builtins.str:
        return pulumi.get(self, "work_request_id")


class AwaitableGetAuditProfileCollectedAuditVolumesResult(GetAuditProfileCollectedAuditVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditProfileCollectedAuditVolumesResult(
            audit_profile_id=self.audit_profile_id,
            collected_audit_volume_collections=self.collected_audit_volume_collections,
            filters=self.filters,
            id=self.id,
            month_in_consideration_greater_than=self.month_in_consideration_greater_than,
            month_in_consideration_less_than=self.month_in_consideration_less_than,
            work_request_id=self.work_request_id)


def get_audit_profile_collected_audit_volumes(audit_profile_id: Optional[builtins.str] = None,
                                              filters: Optional[Sequence[Union['GetAuditProfileCollectedAuditVolumesFilterArgs', 'GetAuditProfileCollectedAuditVolumesFilterArgsDict']]] = None,
                                              month_in_consideration_greater_than: Optional[builtins.str] = None,
                                              month_in_consideration_less_than: Optional[builtins.str] = None,
                                              work_request_id: Optional[builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditProfileCollectedAuditVolumesResult:
    """
    This data source provides the list of Audit Profile Collected Audit Volumes in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all collected audit volume data points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_collected_audit_volumes = oci.DataSafe.get_audit_profile_collected_audit_volumes(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_collected_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_collected_audit_volume_month_in_consideration_less_than)
    ```


    :param builtins.str audit_profile_id: The OCID of the audit.
    :param builtins.str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param builtins.str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param builtins.str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    __args__['filters'] = filters
    __args__['monthInConsiderationGreaterThan'] = month_in_consideration_greater_than
    __args__['monthInConsiderationLessThan'] = month_in_consideration_less_than
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditProfileCollectedAuditVolumes:getAuditProfileCollectedAuditVolumes', __args__, opts=opts, typ=GetAuditProfileCollectedAuditVolumesResult).value

    return AwaitableGetAuditProfileCollectedAuditVolumesResult(
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        collected_audit_volume_collections=pulumi.get(__ret__, 'collected_audit_volume_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        month_in_consideration_greater_than=pulumi.get(__ret__, 'month_in_consideration_greater_than'),
        month_in_consideration_less_than=pulumi.get(__ret__, 'month_in_consideration_less_than'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_audit_profile_collected_audit_volumes_output(audit_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAuditProfileCollectedAuditVolumesFilterArgs', 'GetAuditProfileCollectedAuditVolumesFilterArgsDict']]]]] = None,
                                                     month_in_consideration_greater_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     month_in_consideration_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                     work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuditProfileCollectedAuditVolumesResult]:
    """
    This data source provides the list of Audit Profile Collected Audit Volumes in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all collected audit volume data points.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_collected_audit_volumes = oci.DataSafe.get_audit_profile_collected_audit_volumes(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_collected_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_collected_audit_volume_month_in_consideration_less_than)
    ```


    :param builtins.str audit_profile_id: The OCID of the audit.
    :param builtins.str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param builtins.str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param builtins.str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    __args__['filters'] = filters
    __args__['monthInConsiderationGreaterThan'] = month_in_consideration_greater_than
    __args__['monthInConsiderationLessThan'] = month_in_consideration_less_than
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAuditProfileCollectedAuditVolumes:getAuditProfileCollectedAuditVolumes', __args__, opts=opts, typ=GetAuditProfileCollectedAuditVolumesResult)
    return __ret__.apply(lambda __response__: GetAuditProfileCollectedAuditVolumesResult(
        audit_profile_id=pulumi.get(__response__, 'audit_profile_id'),
        collected_audit_volume_collections=pulumi.get(__response__, 'collected_audit_volume_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        month_in_consideration_greater_than=pulumi.get(__response__, 'month_in_consideration_greater_than'),
        month_in_consideration_less_than=pulumi.get(__response__, 'month_in_consideration_less_than'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
