# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAuditTrailResult',
    'AwaitableGetAuditTrailResult',
    'get_audit_trail',
    'get_audit_trail_output',
]

@pulumi.output_type
class GetAuditTrailResult:
    """
    A collection of values returned by getAuditTrail.
    """
    def __init__(__self__, audit_collection_start_time=None, audit_profile_id=None, audit_trail_id=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, is_auto_purge_enabled=None, lifecycle_details=None, peer_target_database_key=None, purge_job_details=None, purge_job_status=None, purge_job_time=None, resume_trigger=None, state=None, status=None, system_tags=None, target_id=None, time_created=None, time_last_collected=None, time_updated=None, trail_location=None, trail_source=None, work_request_id=None):
        if audit_collection_start_time and not isinstance(audit_collection_start_time, str):
            raise TypeError("Expected argument 'audit_collection_start_time' to be a str")
        pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if audit_trail_id and not isinstance(audit_trail_id, str):
            raise TypeError("Expected argument 'audit_trail_id' to be a str")
        pulumi.set(__self__, "audit_trail_id", audit_trail_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_purge_enabled and not isinstance(is_auto_purge_enabled, bool):
            raise TypeError("Expected argument 'is_auto_purge_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_purge_enabled", is_auto_purge_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if peer_target_database_key and not isinstance(peer_target_database_key, int):
            raise TypeError("Expected argument 'peer_target_database_key' to be a int")
        pulumi.set(__self__, "peer_target_database_key", peer_target_database_key)
        if purge_job_details and not isinstance(purge_job_details, str):
            raise TypeError("Expected argument 'purge_job_details' to be a str")
        pulumi.set(__self__, "purge_job_details", purge_job_details)
        if purge_job_status and not isinstance(purge_job_status, str):
            raise TypeError("Expected argument 'purge_job_status' to be a str")
        pulumi.set(__self__, "purge_job_status", purge_job_status)
        if purge_job_time and not isinstance(purge_job_time, str):
            raise TypeError("Expected argument 'purge_job_time' to be a str")
        pulumi.set(__self__, "purge_job_time", purge_job_time)
        if resume_trigger and not isinstance(resume_trigger, int):
            raise TypeError("Expected argument 'resume_trigger' to be a int")
        pulumi.set(__self__, "resume_trigger", resume_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_collected and not isinstance(time_last_collected, str):
            raise TypeError("Expected argument 'time_last_collected' to be a str")
        pulumi.set(__self__, "time_last_collected", time_last_collected)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if trail_location and not isinstance(trail_location, str):
            raise TypeError("Expected argument 'trail_location' to be a str")
        pulumi.set(__self__, "trail_location", trail_location)
        if trail_source and not isinstance(trail_source, str):
            raise TypeError("Expected argument 'trail_source' to be a str")
        pulumi.set(__self__, "trail_source", trail_source)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> builtins.str:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> builtins.str:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="auditTrailId")
    def audit_trail_id(self) -> builtins.str:
        return pulumi.get(self, "audit_trail_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the audit trail.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the audit trail.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> builtins.bool:
        """
        Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the current state of the audit trail in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="peerTargetDatabaseKey")
    def peer_target_database_key(self) -> builtins.int:
        """
        The secondary id assigned for the peer database registered with Data Safe.
        """
        return pulumi.get(self, "peer_target_database_key")

    @property
    @pulumi.getter(name="purgeJobDetails")
    def purge_job_details(self) -> builtins.str:
        """
        The details of the audit trail purge job that ran on the "purgeJobTime".
        """
        return pulumi.get(self, "purge_job_details")

    @property
    @pulumi.getter(name="purgeJobStatus")
    def purge_job_status(self) -> builtins.str:
        """
        The current status of the audit trail purge job.
        """
        return pulumi.get(self, "purge_job_status")

    @property
    @pulumi.getter(name="purgeJobTime")
    def purge_job_time(self) -> builtins.str:
        """
        The date and time of the last purge job, which deletes audit data in the target database every seven days so that the database's audit trail does not become too large. In the format defined by RFC3339.
        """
        return pulumi.get(self, "purge_job_time")

    @property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> builtins.int:
        return pulumi.get(self, "resume_trigger")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the audit trail.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The OCID of the Data Safe target for which the audit trail is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the audit trail was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastCollected")
    def time_last_collected(self) -> builtins.str:
        """
        The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_collected")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the audit trail was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> builtins.str:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @property
    @pulumi.getter(name="trailSource")
    def trail_source(self) -> builtins.str:
        """
        The underlying source of unified audit trail.
        """
        return pulumi.get(self, "trail_source")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> builtins.str:
        """
        The OCID of the workrequest for audit trail which collects audit records.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetAuditTrailResult(GetAuditTrailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditTrailResult(
            audit_collection_start_time=self.audit_collection_start_time,
            audit_profile_id=self.audit_profile_id,
            audit_trail_id=self.audit_trail_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_purge_enabled=self.is_auto_purge_enabled,
            lifecycle_details=self.lifecycle_details,
            peer_target_database_key=self.peer_target_database_key,
            purge_job_details=self.purge_job_details,
            purge_job_status=self.purge_job_status,
            purge_job_time=self.purge_job_time,
            resume_trigger=self.resume_trigger,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_created=self.time_created,
            time_last_collected=self.time_last_collected,
            time_updated=self.time_updated,
            trail_location=self.trail_location,
            trail_source=self.trail_source,
            work_request_id=self.work_request_id)


def get_audit_trail(audit_trail_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditTrailResult:
    """
    This data source provides details about a specific Audit Trail resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of audit trail.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_trail = oci.DataSafe.get_audit_trail(audit_trail_id=test_audit_trail_oci_data_safe_audit_trail["id"])
    ```


    :param builtins.str audit_trail_id: The OCID of the audit trail.
    """
    __args__ = dict()
    __args__['auditTrailId'] = audit_trail_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditTrail:getAuditTrail', __args__, opts=opts, typ=GetAuditTrailResult).value

    return AwaitableGetAuditTrailResult(
        audit_collection_start_time=pulumi.get(__ret__, 'audit_collection_start_time'),
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        audit_trail_id=pulumi.get(__ret__, 'audit_trail_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_purge_enabled=pulumi.get(__ret__, 'is_auto_purge_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        peer_target_database_key=pulumi.get(__ret__, 'peer_target_database_key'),
        purge_job_details=pulumi.get(__ret__, 'purge_job_details'),
        purge_job_status=pulumi.get(__ret__, 'purge_job_status'),
        purge_job_time=pulumi.get(__ret__, 'purge_job_time'),
        resume_trigger=pulumi.get(__ret__, 'resume_trigger'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_collected=pulumi.get(__ret__, 'time_last_collected'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        trail_location=pulumi.get(__ret__, 'trail_location'),
        trail_source=pulumi.get(__ret__, 'trail_source'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))
def get_audit_trail_output(audit_trail_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuditTrailResult]:
    """
    This data source provides details about a specific Audit Trail resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of audit trail.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_trail = oci.DataSafe.get_audit_trail(audit_trail_id=test_audit_trail_oci_data_safe_audit_trail["id"])
    ```


    :param builtins.str audit_trail_id: The OCID of the audit trail.
    """
    __args__ = dict()
    __args__['auditTrailId'] = audit_trail_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAuditTrail:getAuditTrail', __args__, opts=opts, typ=GetAuditTrailResult)
    return __ret__.apply(lambda __response__: GetAuditTrailResult(
        audit_collection_start_time=pulumi.get(__response__, 'audit_collection_start_time'),
        audit_profile_id=pulumi.get(__response__, 'audit_profile_id'),
        audit_trail_id=pulumi.get(__response__, 'audit_trail_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_auto_purge_enabled=pulumi.get(__response__, 'is_auto_purge_enabled'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        peer_target_database_key=pulumi.get(__response__, 'peer_target_database_key'),
        purge_job_details=pulumi.get(__response__, 'purge_job_details'),
        purge_job_status=pulumi.get(__response__, 'purge_job_status'),
        purge_job_time=pulumi.get(__response__, 'purge_job_time'),
        resume_trigger=pulumi.get(__response__, 'resume_trigger'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_collected=pulumi.get(__response__, 'time_last_collected'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        trail_location=pulumi.get(__response__, 'trail_location'),
        trail_source=pulumi.get(__response__, 'trail_source'),
        work_request_id=pulumi.get(__response__, 'work_request_id')))
