# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMaskingPolicyResult',
    'AwaitableGetMaskingPolicyResult',
    'get_masking_policy',
    'get_masking_policy_output',
]

@pulumi.output_type
class GetMaskingPolicyResult:
    """
    A collection of values returned by getMaskingPolicy.
    """
    def __init__(__self__, add_masking_columns_from_sdm_trigger=None, column_sources=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, generate_health_report_trigger=None, id=None, is_drop_temp_tables_enabled=None, is_redo_logging_enabled=None, is_refresh_stats_enabled=None, masking_policy_id=None, parallel_degree=None, post_masking_script=None, pre_masking_script=None, recompile=None, state=None, time_created=None, time_updated=None):
        if add_masking_columns_from_sdm_trigger and not isinstance(add_masking_columns_from_sdm_trigger, int):
            raise TypeError("Expected argument 'add_masking_columns_from_sdm_trigger' to be a int")
        pulumi.set(__self__, "add_masking_columns_from_sdm_trigger", add_masking_columns_from_sdm_trigger)
        if column_sources and not isinstance(column_sources, list):
            raise TypeError("Expected argument 'column_sources' to be a list")
        pulumi.set(__self__, "column_sources", column_sources)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_health_report_trigger and not isinstance(generate_health_report_trigger, int):
            raise TypeError("Expected argument 'generate_health_report_trigger' to be a int")
        pulumi.set(__self__, "generate_health_report_trigger", generate_health_report_trigger)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_drop_temp_tables_enabled and not isinstance(is_drop_temp_tables_enabled, bool):
            raise TypeError("Expected argument 'is_drop_temp_tables_enabled' to be a bool")
        pulumi.set(__self__, "is_drop_temp_tables_enabled", is_drop_temp_tables_enabled)
        if is_redo_logging_enabled and not isinstance(is_redo_logging_enabled, bool):
            raise TypeError("Expected argument 'is_redo_logging_enabled' to be a bool")
        pulumi.set(__self__, "is_redo_logging_enabled", is_redo_logging_enabled)
        if is_refresh_stats_enabled and not isinstance(is_refresh_stats_enabled, bool):
            raise TypeError("Expected argument 'is_refresh_stats_enabled' to be a bool")
        pulumi.set(__self__, "is_refresh_stats_enabled", is_refresh_stats_enabled)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if parallel_degree and not isinstance(parallel_degree, str):
            raise TypeError("Expected argument 'parallel_degree' to be a str")
        pulumi.set(__self__, "parallel_degree", parallel_degree)
        if post_masking_script and not isinstance(post_masking_script, str):
            raise TypeError("Expected argument 'post_masking_script' to be a str")
        pulumi.set(__self__, "post_masking_script", post_masking_script)
        if pre_masking_script and not isinstance(pre_masking_script, str):
            raise TypeError("Expected argument 'pre_masking_script' to be a str")
        pulumi.set(__self__, "pre_masking_script", pre_masking_script)
        if recompile and not isinstance(recompile, str):
            raise TypeError("Expected argument 'recompile' to be a str")
        pulumi.set(__self__, "recompile", recompile)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="addMaskingColumnsFromSdmTrigger")
    def add_masking_columns_from_sdm_trigger(self) -> builtins.int:
        return pulumi.get(self, "add_masking_columns_from_sdm_trigger")

    @property
    @pulumi.getter(name="columnSources")
    def column_sources(self) -> Sequence['outputs.GetMaskingPolicyColumnSourceResult']:
        """
        The source of masking columns.
        """
        return pulumi.get(self, "column_sources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the masking policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the masking policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the masking policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="generateHealthReportTrigger")
    def generate_health_report_trigger(self) -> builtins.int:
        return pulumi.get(self, "generate_health_report_trigger")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> builtins.bool:
        """
        Indicates if the temporary tables created during a masking operation should be dropped after masking. It's enabled by default. Set this attribute to false to preserve the temporary tables. Masking creates temporary tables that map the original sensitive  data values to mask values. By default, these temporary tables are dropped after masking. But, in some cases, you may want  to preserve this information to track how masking changed your data. Note that doing so compromises security. These tables  must be dropped before the database is available for unprivileged users.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> builtins.bool:
        """
        Indicates if redo logging is enabled during a masking operation. It's disabled by default. Set this attribute to true to enable redo logging. By default, masking disables redo logging and flashback logging to purge any original unmasked  data from logs. However, in certain circumstances when you only want to test masking, rollback changes, and retry masking, you could enable logging and use a flashback database to retrieve the original unmasked data after it has been masked.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> builtins.bool:
        """
        Indicates if statistics gathering is enabled. It's enabled by default. Set this attribute to false to disable statistics gathering. The masking process gathers statistics on masked database tables after masking completes.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> builtins.str:
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> builtins.str:
        """
        Specifies options to enable parallel execution when running data masking. Allowed values are 'NONE' (no parallelism), 'DEFAULT' (the Oracle Database computes the optimum degree of parallelism) or an integer value to be used as the degree of parallelism. Parallel execution helps effectively use multiple CPUs and improve masking performance. Refer to the Oracle Database parallel execution framework when choosing an explicit degree of parallelism.
        """
        return pulumi.get(self, "parallel_degree")

    @property
    @pulumi.getter(name="postMaskingScript")
    def post_masking_script(self) -> builtins.str:
        """
        A post-masking script, which can contain SQL and PL/SQL statements. It's executed after the core masking script generated using the masking policy. It's usually used to perform additional transformation or cleanup work after masking.
        """
        return pulumi.get(self, "post_masking_script")

    @property
    @pulumi.getter(name="preMaskingScript")
    def pre_masking_script(self) -> builtins.str:
        """
        A pre-masking script, which can contain SQL and PL/SQL statements. It's executed before  the core masking script generated using the masking policy. It's usually used to perform any preparation or prerequisite work before masking data.
        """
        return pulumi.get(self, "pre_masking_script")

    @property
    @pulumi.getter
    def recompile(self) -> builtins.str:
        """
        Specifies how to recompile invalid objects post data masking. Allowed values are 'SERIAL' (recompile in serial),  'PARALLEL' (recompile in parallel), 'NONE' (do not recompile). If it's set to PARALLEL, the value of parallelDegree attribute is used. Use the built-in UTL_RECOMP package to recompile any remaining invalid objects after masking completes.
        """
        return pulumi.get(self, "recompile")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the masking policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the masking policy was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the masking policy was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMaskingPolicyResult(GetMaskingPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingPolicyResult(
            add_masking_columns_from_sdm_trigger=self.add_masking_columns_from_sdm_trigger,
            column_sources=self.column_sources,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            generate_health_report_trigger=self.generate_health_report_trigger,
            id=self.id,
            is_drop_temp_tables_enabled=self.is_drop_temp_tables_enabled,
            is_redo_logging_enabled=self.is_redo_logging_enabled,
            is_refresh_stats_enabled=self.is_refresh_stats_enabled,
            masking_policy_id=self.masking_policy_id,
            parallel_degree=self.parallel_degree,
            post_masking_script=self.post_masking_script,
            pre_masking_script=self.pre_masking_script,
            recompile=self.recompile,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_masking_policy(masking_policy_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingPolicyResult:
    """
    This data source provides details about a specific Masking Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy = oci.DataSafe.get_masking_policy(masking_policy_id=test_masking_policy_oci_data_safe_masking_policy["id"])
    ```


    :param builtins.str masking_policy_id: The OCID of the masking policy.
    """
    __args__ = dict()
    __args__['maskingPolicyId'] = masking_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingPolicy:getMaskingPolicy', __args__, opts=opts, typ=GetMaskingPolicyResult).value

    return AwaitableGetMaskingPolicyResult(
        add_masking_columns_from_sdm_trigger=pulumi.get(__ret__, 'add_masking_columns_from_sdm_trigger'),
        column_sources=pulumi.get(__ret__, 'column_sources'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        generate_health_report_trigger=pulumi.get(__ret__, 'generate_health_report_trigger'),
        id=pulumi.get(__ret__, 'id'),
        is_drop_temp_tables_enabled=pulumi.get(__ret__, 'is_drop_temp_tables_enabled'),
        is_redo_logging_enabled=pulumi.get(__ret__, 'is_redo_logging_enabled'),
        is_refresh_stats_enabled=pulumi.get(__ret__, 'is_refresh_stats_enabled'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        parallel_degree=pulumi.get(__ret__, 'parallel_degree'),
        post_masking_script=pulumi.get(__ret__, 'post_masking_script'),
        pre_masking_script=pulumi.get(__ret__, 'pre_masking_script'),
        recompile=pulumi.get(__ret__, 'recompile'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_masking_policy_output(masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaskingPolicyResult]:
    """
    This data source provides details about a specific Masking Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_policy = oci.DataSafe.get_masking_policy(masking_policy_id=test_masking_policy_oci_data_safe_masking_policy["id"])
    ```


    :param builtins.str masking_policy_id: The OCID of the masking policy.
    """
    __args__ = dict()
    __args__['maskingPolicyId'] = masking_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getMaskingPolicy:getMaskingPolicy', __args__, opts=opts, typ=GetMaskingPolicyResult)
    return __ret__.apply(lambda __response__: GetMaskingPolicyResult(
        add_masking_columns_from_sdm_trigger=pulumi.get(__response__, 'add_masking_columns_from_sdm_trigger'),
        column_sources=pulumi.get(__response__, 'column_sources'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        generate_health_report_trigger=pulumi.get(__response__, 'generate_health_report_trigger'),
        id=pulumi.get(__response__, 'id'),
        is_drop_temp_tables_enabled=pulumi.get(__response__, 'is_drop_temp_tables_enabled'),
        is_redo_logging_enabled=pulumi.get(__response__, 'is_redo_logging_enabled'),
        is_refresh_stats_enabled=pulumi.get(__response__, 'is_refresh_stats_enabled'),
        masking_policy_id=pulumi.get(__response__, 'masking_policy_id'),
        parallel_degree=pulumi.get(__response__, 'parallel_degree'),
        post_masking_script=pulumi.get(__response__, 'post_masking_script'),
        pre_masking_script=pulumi.get(__response__, 'pre_masking_script'),
        recompile=pulumi.get(__response__, 'recompile'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
