# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSqlFirewallViolationAnalyticsResult',
    'AwaitableGetSqlFirewallViolationAnalyticsResult',
    'get_sql_firewall_violation_analytics',
    'get_sql_firewall_violation_analytics_output',
]

@pulumi.output_type
class GetSqlFirewallViolationAnalyticsResult:
    """
    A collection of values returned by getSqlFirewallViolationAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, group_bies=None, id=None, query_time_zone=None, scim_query=None, sql_firewall_violation_analytics_collections=None, summary_fields=None, time_ended=None, time_started=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_bies and not isinstance(group_bies, list):
            raise TypeError("Expected argument 'group_bies' to be a list")
        pulumi.set(__self__, "group_bies", group_bies)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query_time_zone and not isinstance(query_time_zone, str):
            raise TypeError("Expected argument 'query_time_zone' to be a str")
        pulumi.set(__self__, "query_time_zone", query_time_zone)
        if scim_query and not isinstance(scim_query, str):
            raise TypeError("Expected argument 'scim_query' to be a str")
        pulumi.set(__self__, "scim_query", scim_query)
        if sql_firewall_violation_analytics_collections and not isinstance(sql_firewall_violation_analytics_collections, list):
            raise TypeError("Expected argument 'sql_firewall_violation_analytics_collections' to be a list")
        pulumi.set(__self__, "sql_firewall_violation_analytics_collections", sql_firewall_violation_analytics_collections)
        if summary_fields and not isinstance(summary_fields, list):
            raise TypeError("Expected argument 'summary_fields' to be a list")
        pulumi.set(__self__, "summary_fields", summary_fields)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSqlFirewallViolationAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="queryTimeZone")
    def query_time_zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "query_time_zone")

    @property
    @pulumi.getter(name="scimQuery")
    def scim_query(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scim_query")

    @property
    @pulumi.getter(name="sqlFirewallViolationAnalyticsCollections")
    def sql_firewall_violation_analytics_collections(self) -> Sequence['outputs.GetSqlFirewallViolationAnalyticsSqlFirewallViolationAnalyticsCollectionResult']:
        """
        The list of sql_firewall_violation_analytics_collection.
        """
        return pulumi.get(self, "sql_firewall_violation_analytics_collections")

    @property
    @pulumi.getter(name="summaryFields")
    def summary_fields(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "summary_fields")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[builtins.str]:
        """
        The time at which the aggregation ended.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[builtins.str]:
        """
        The time at which the aggregation started.
        """
        return pulumi.get(self, "time_started")


class AwaitableGetSqlFirewallViolationAnalyticsResult(GetSqlFirewallViolationAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlFirewallViolationAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            group_bies=self.group_bies,
            id=self.id,
            query_time_zone=self.query_time_zone,
            scim_query=self.scim_query,
            sql_firewall_violation_analytics_collections=self.sql_firewall_violation_analytics_collections,
            summary_fields=self.summary_fields,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_sql_firewall_violation_analytics(access_level: Optional[builtins.str] = None,
                                         compartment_id: Optional[builtins.str] = None,
                                         compartment_id_in_subtree: Optional[builtins.bool] = None,
                                         filters: Optional[Sequence[Union['GetSqlFirewallViolationAnalyticsFilterArgs', 'GetSqlFirewallViolationAnalyticsFilterArgsDict']]] = None,
                                         group_bies: Optional[Sequence[builtins.str]] = None,
                                         query_time_zone: Optional[builtins.str] = None,
                                         scim_query: Optional[builtins.str] = None,
                                         summary_fields: Optional[Sequence[builtins.str]] = None,
                                         time_ended: Optional[builtins.str] = None,
                                         time_started: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlFirewallViolationAnalyticsResult:
    """
    This data source provides the list of Sql Firewall Violation Analytics in Oracle Cloud Infrastructure Data Safe service.

    Returns the aggregation details of the SQL Firewall violations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_violation_analytics = oci.DataSafe.get_sql_firewall_violation_analytics(compartment_id=compartment_id,
        access_level=sql_firewall_violation_analytic_access_level,
        compartment_id_in_subtree=sql_firewall_violation_analytic_compartment_id_in_subtree,
        group_bies=sql_firewall_violation_analytic_group_by,
        query_time_zone=sql_firewall_violation_analytic_query_time_zone,
        scim_query=sql_firewall_violation_analytic_scim_query,
        summary_fields=sql_firewall_violation_analytic_summary_field,
        time_ended=sql_firewall_violation_analytic_time_ended,
        time_started=sql_firewall_violation_analytic_time_started)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] group_bies: A groupBy can only be used in combination with summaryField parameter. A groupBy value has to be a subset of the values mentioned in summaryField parameter.
    :param builtins.str query_time_zone: Default time zone is UTC if no time zone provided. The date-time considerations of the resource will be in accordance with the specified time zone.
    :param builtins.str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(operationTime ge '2021-06-04T01-00-26') and (violationAction eq 'BLOCKED')
    :param Sequence[builtins.str] summary_fields: Specifies a subset of summarized fields to be returned in the response.
    :param builtins.str time_ended: An optional filter to return audit events whose creation time in the database is less than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param builtins.str time_started: An optional filter to return audit events whose creation time in the database is greater than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['queryTimeZone'] = query_time_zone
    __args__['scimQuery'] = scim_query
    __args__['summaryFields'] = summary_fields
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlFirewallViolationAnalytics:getSqlFirewallViolationAnalytics', __args__, opts=opts, typ=GetSqlFirewallViolationAnalyticsResult).value

    return AwaitableGetSqlFirewallViolationAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        group_bies=pulumi.get(__ret__, 'group_bies'),
        id=pulumi.get(__ret__, 'id'),
        query_time_zone=pulumi.get(__ret__, 'query_time_zone'),
        scim_query=pulumi.get(__ret__, 'scim_query'),
        sql_firewall_violation_analytics_collections=pulumi.get(__ret__, 'sql_firewall_violation_analytics_collections'),
        summary_fields=pulumi.get(__ret__, 'summary_fields'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))
def get_sql_firewall_violation_analytics_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSqlFirewallViolationAnalyticsFilterArgs', 'GetSqlFirewallViolationAnalyticsFilterArgsDict']]]]] = None,
                                                group_bies: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                query_time_zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                scim_query: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                summary_fields: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                time_ended: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                time_started: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlFirewallViolationAnalyticsResult]:
    """
    This data source provides the list of Sql Firewall Violation Analytics in Oracle Cloud Infrastructure Data Safe service.

    Returns the aggregation details of the SQL Firewall violations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_violation_analytics = oci.DataSafe.get_sql_firewall_violation_analytics(compartment_id=compartment_id,
        access_level=sql_firewall_violation_analytic_access_level,
        compartment_id_in_subtree=sql_firewall_violation_analytic_compartment_id_in_subtree,
        group_bies=sql_firewall_violation_analytic_group_by,
        query_time_zone=sql_firewall_violation_analytic_query_time_zone,
        scim_query=sql_firewall_violation_analytic_scim_query,
        summary_fields=sql_firewall_violation_analytic_summary_field,
        time_ended=sql_firewall_violation_analytic_time_ended,
        time_started=sql_firewall_violation_analytic_time_started)
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param Sequence[builtins.str] group_bies: A groupBy can only be used in combination with summaryField parameter. A groupBy value has to be a subset of the values mentioned in summaryField parameter.
    :param builtins.str query_time_zone: Default time zone is UTC if no time zone provided. The date-time considerations of the resource will be in accordance with the specified time zone.
    :param builtins.str scim_query: The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2 of the System for Cross-Domain Identity Management (SCIM) specification, which is available at [RFC3339](https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions, text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format. (Numeric and boolean values should not be quoted.)
           
           **Example:** query=(operationTime ge '2021-06-04T01-00-26') and (violationAction eq 'BLOCKED')
    :param Sequence[builtins.str] summary_fields: Specifies a subset of summarized fields to be returned in the response.
    :param builtins.str time_ended: An optional filter to return audit events whose creation time in the database is less than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param builtins.str time_started: An optional filter to return audit events whose creation time in the database is greater than and equal to the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['groupBies'] = group_bies
    __args__['queryTimeZone'] = query_time_zone
    __args__['scimQuery'] = scim_query
    __args__['summaryFields'] = summary_fields
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlFirewallViolationAnalytics:getSqlFirewallViolationAnalytics', __args__, opts=opts, typ=GetSqlFirewallViolationAnalyticsResult)
    return __ret__.apply(lambda __response__: GetSqlFirewallViolationAnalyticsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__response__, 'filters'),
        group_bies=pulumi.get(__response__, 'group_bies'),
        id=pulumi.get(__response__, 'id'),
        query_time_zone=pulumi.get(__response__, 'query_time_zone'),
        scim_query=pulumi.get(__response__, 'scim_query'),
        sql_firewall_violation_analytics_collections=pulumi.get(__response__, 'sql_firewall_violation_analytics_collections'),
        summary_fields=pulumi.get(__response__, 'summary_fields'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started')))
