# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetDatabasesTablesResult',
    'AwaitableGetTargetDatabasesTablesResult',
    'get_target_databases_tables',
    'get_target_databases_tables_output',
]

@pulumi.output_type
class GetTargetDatabasesTablesResult:
    """
    A collection of values returned by getTargetDatabasesTables.
    """
    def __init__(__self__, filters=None, id=None, schema_name_contains=None, schema_names=None, table_name_contains=None, table_names=None, tables=None, target_database_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schema_name_contains and not isinstance(schema_name_contains, str):
            raise TypeError("Expected argument 'schema_name_contains' to be a str")
        pulumi.set(__self__, "schema_name_contains", schema_name_contains)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if table_name_contains and not isinstance(table_name_contains, str):
            raise TypeError("Expected argument 'table_name_contains' to be a str")
        pulumi.set(__self__, "table_name_contains", table_name_contains)
        if table_names and not isinstance(table_names, list):
            raise TypeError("Expected argument 'table_names' to be a list")
        pulumi.set(__self__, "table_names", table_names)
        if tables and not isinstance(tables, list):
            raise TypeError("Expected argument 'tables' to be a list")
        pulumi.set(__self__, "tables", tables)
        if target_database_id and not isinstance(target_database_id, str):
            raise TypeError("Expected argument 'target_database_id' to be a str")
        pulumi.set(__self__, "target_database_id", target_database_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetDatabasesTablesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="schemaNameContains")
    def schema_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "schema_name_contains")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Name of the schema.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="tableNameContains")
    def table_name_contains(self) -> Optional[builtins.str]:
        return pulumi.get(self, "table_name_contains")

    @property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Name of the table.
        """
        return pulumi.get(self, "table_names")

    @property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.GetTargetDatabasesTablesTableResult']:
        """
        The list of tables.
        """
        return pulumi.get(self, "tables")

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> builtins.str:
        return pulumi.get(self, "target_database_id")


class AwaitableGetTargetDatabasesTablesResult(GetTargetDatabasesTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabasesTablesResult(
            filters=self.filters,
            id=self.id,
            schema_name_contains=self.schema_name_contains,
            schema_names=self.schema_names,
            table_name_contains=self.table_name_contains,
            table_names=self.table_names,
            tables=self.tables,
            target_database_id=self.target_database_id)


def get_target_databases_tables(filters: Optional[Sequence[Union['GetTargetDatabasesTablesFilterArgs', 'GetTargetDatabasesTablesFilterArgsDict']]] = None,
                                schema_name_contains: Optional[builtins.str] = None,
                                schema_names: Optional[Sequence[builtins.str]] = None,
                                table_name_contains: Optional[builtins.str] = None,
                                table_names: Optional[Sequence[builtins.str]] = None,
                                target_database_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabasesTablesResult:
    """
    This data source provides the list of Target Databases Tables in Oracle Cloud Infrastructure Data Safe service.

    Returns a list of table metadata objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_databases_tables = oci.DataSafe.get_target_databases_tables(target_database_id=test_target_database["id"],
        schema_names=target_databases_table_schema_name,
        schema_name_contains=target_databases_table_schema_name_contains,
        table_names=test_table["name"],
        table_name_contains=target_databases_table_table_name_contains)
    ```


    :param builtins.str schema_name_contains: A filter to return only items if schema name contains a specific string.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str table_name_contains: A filter to return only items if table name contains a specific string.
    :param Sequence[builtins.str] table_names: A filter to return only items related to specific table name.
    :param builtins.str target_database_id: The OCID of the Data Safe target database.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['schemaNameContains'] = schema_name_contains
    __args__['schemaNames'] = schema_names
    __args__['tableNameContains'] = table_name_contains
    __args__['tableNames'] = table_names
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabasesTables:getTargetDatabasesTables', __args__, opts=opts, typ=GetTargetDatabasesTablesResult).value

    return AwaitableGetTargetDatabasesTablesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        schema_name_contains=pulumi.get(__ret__, 'schema_name_contains'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        table_name_contains=pulumi.get(__ret__, 'table_name_contains'),
        table_names=pulumi.get(__ret__, 'table_names'),
        tables=pulumi.get(__ret__, 'tables'),
        target_database_id=pulumi.get(__ret__, 'target_database_id'))
def get_target_databases_tables_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTargetDatabasesTablesFilterArgs', 'GetTargetDatabasesTablesFilterArgsDict']]]]] = None,
                                       schema_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       schema_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                       table_name_contains: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       table_names: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                       target_database_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetDatabasesTablesResult]:
    """
    This data source provides the list of Target Databases Tables in Oracle Cloud Infrastructure Data Safe service.

    Returns a list of table metadata objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_databases_tables = oci.DataSafe.get_target_databases_tables(target_database_id=test_target_database["id"],
        schema_names=target_databases_table_schema_name,
        schema_name_contains=target_databases_table_schema_name_contains,
        table_names=test_table["name"],
        table_name_contains=target_databases_table_table_name_contains)
    ```


    :param builtins.str schema_name_contains: A filter to return only items if schema name contains a specific string.
    :param Sequence[builtins.str] schema_names: A filter to return only items related to specific schema name.
    :param builtins.str table_name_contains: A filter to return only items if table name contains a specific string.
    :param Sequence[builtins.str] table_names: A filter to return only items related to specific table name.
    :param builtins.str target_database_id: The OCID of the Data Safe target database.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['schemaNameContains'] = schema_name_contains
    __args__['schemaNames'] = schema_names
    __args__['tableNameContains'] = table_name_contains
    __args__['tableNames'] = table_names
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getTargetDatabasesTables:getTargetDatabasesTables', __args__, opts=opts, typ=GetTargetDatabasesTablesResult)
    return __ret__.apply(lambda __response__: GetTargetDatabasesTablesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        schema_name_contains=pulumi.get(__response__, 'schema_name_contains'),
        schema_names=pulumi.get(__response__, 'schema_names'),
        table_name_contains=pulumi.get(__response__, 'table_name_contains'),
        table_names=pulumi.get(__response__, 'table_names'),
        tables=pulumi.get(__response__, 'tables'),
        target_database_id=pulumi.get(__response__, 'target_database_id')))
