# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensitiveDataModelReferentialRelationArgs', 'SensitiveDataModelReferentialRelation']

@pulumi.input_type
class SensitiveDataModelReferentialRelationArgs:
    def __init__(__self__, *,
                 child: pulumi.Input['SensitiveDataModelReferentialRelationChildArgs'],
                 parent: pulumi.Input['SensitiveDataModelReferentialRelationParentArgs'],
                 relation_type: pulumi.Input[builtins.str],
                 sensitive_data_model_id: pulumi.Input[builtins.str],
                 is_sensitive: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a SensitiveDataModelReferentialRelation resource.
        :param pulumi.Input['SensitiveDataModelReferentialRelationChildArgs'] child: columnsInfo object has details of column group with schema details.
        :param pulumi.Input['SensitiveDataModelReferentialRelationParentArgs'] parent: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[builtins.str] sensitive_data_model_id: The OCID of the sensitive data model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.bool] is_sensitive: Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        """
        pulumi.set(__self__, "child", child)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "relation_type", relation_type)
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if is_sensitive is not None:
            pulumi.set(__self__, "is_sensitive", is_sensitive)

    @property
    @pulumi.getter
    def child(self) -> pulumi.Input['SensitiveDataModelReferentialRelationChildArgs']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "child")

    @child.setter
    def child(self, value: pulumi.Input['SensitiveDataModelReferentialRelationChildArgs']):
        pulumi.set(self, "child", value)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input['SensitiveDataModelReferentialRelationParentArgs']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input['SensitiveDataModelReferentialRelationParentArgs']):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @relation_type.setter
    def relation_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relation_type", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the sensitive data model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        """
        return pulumi.get(self, "is_sensitive")

    @is_sensitive.setter
    def is_sensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_sensitive", value)


@pulumi.input_type
class _SensitiveDataModelReferentialRelationState:
    def __init__(__self__, *,
                 child: Optional[pulumi.Input['SensitiveDataModelReferentialRelationChildArgs']] = None,
                 is_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input['SensitiveDataModelReferentialRelationParentArgs']] = None,
                 relation_type: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SensitiveDataModelReferentialRelation resources.
        :param pulumi.Input['SensitiveDataModelReferentialRelationChildArgs'] child: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.bool] is_sensitive: Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        :param pulumi.Input[builtins.str] key: The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
        :param pulumi.Input['SensitiveDataModelReferentialRelationParentArgs'] parent: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[builtins.str] sensitive_data_model_id: The OCID of the sensitive data model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the referential relation.
        """
        if child is not None:
            pulumi.set(__self__, "child", child)
        if is_sensitive is not None:
            pulumi.set(__self__, "is_sensitive", is_sensitive)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if relation_type is not None:
            pulumi.set(__self__, "relation_type", relation_type)
        if sensitive_data_model_id is not None:
            pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def child(self) -> Optional[pulumi.Input['SensitiveDataModelReferentialRelationChildArgs']]:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "child")

    @child.setter
    def child(self, value: Optional[pulumi.Input['SensitiveDataModelReferentialRelationChildArgs']]):
        pulumi.set(self, "child", value)

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        """
        return pulumi.get(self, "is_sensitive")

    @is_sensitive.setter
    def is_sensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_sensitive", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input['SensitiveDataModelReferentialRelationParentArgs']]:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input['SensitiveDataModelReferentialRelationParentArgs']]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @relation_type.setter
    def relation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "relation_type", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the sensitive data model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the referential relation.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("oci:DataSafe/sensitiveDataModelReferentialRelation:SensitiveDataModelReferentialRelation")
class SensitiveDataModelReferentialRelation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationChildArgs', 'SensitiveDataModelReferentialRelationChildArgsDict']]] = None,
                 is_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 parent: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationParentArgs', 'SensitiveDataModelReferentialRelationParentArgsDict']]] = None,
                 relation_type: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Data Model Referential Relation resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new referential relation in the specified sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model_referential_relation = oci.data_safe.SensitiveDataModelReferentialRelation("test_sensitive_data_model_referential_relation",
            child={
                "app_name": sensitive_data_model_referential_relation_child_app_name,
                "column_groups": sensitive_data_model_referential_relation_child_column_group,
                "object": sensitive_data_model_referential_relation_child_object,
                "object_type": sensitive_data_model_referential_relation_child_object_type,
                "schema_name": sensitive_data_model_referential_relation_child_schema_name,
                "sensitive_type_ids": sensitive_data_model_referential_relation_child_sensitive_type_ids,
            },
            parent={
                "app_name": sensitive_data_model_referential_relation_parent_app_name,
                "column_groups": sensitive_data_model_referential_relation_parent_column_group,
                "object": sensitive_data_model_referential_relation_parent_object,
                "object_type": sensitive_data_model_referential_relation_parent_object_type,
                "schema_name": sensitive_data_model_referential_relation_parent_schema_name,
                "sensitive_type_ids": sensitive_data_model_referential_relation_parent_sensitive_type_ids,
            },
            relation_type=sensitive_data_model_referential_relation_relation_type,
            sensitive_data_model_id=test_sensitive_data_model["id"],
            is_sensitive=sensitive_data_model_referential_relation_is_sensitive)
        ```

        ## Import

        SensitiveDataModelReferentialRelations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModelReferentialRelation:SensitiveDataModelReferentialRelation test_sensitive_data_model_referential_relation "sensitiveDataModels/{sensitiveDataModelId}/referentialRelations/{referentialRelationKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SensitiveDataModelReferentialRelationChildArgs', 'SensitiveDataModelReferentialRelationChildArgsDict']] child: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.bool] is_sensitive: Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        :param pulumi.Input[Union['SensitiveDataModelReferentialRelationParentArgs', 'SensitiveDataModelReferentialRelationParentArgsDict']] parent: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[builtins.str] sensitive_data_model_id: The OCID of the sensitive data model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataModelReferentialRelationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Data Model Referential Relation resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new referential relation in the specified sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model_referential_relation = oci.data_safe.SensitiveDataModelReferentialRelation("test_sensitive_data_model_referential_relation",
            child={
                "app_name": sensitive_data_model_referential_relation_child_app_name,
                "column_groups": sensitive_data_model_referential_relation_child_column_group,
                "object": sensitive_data_model_referential_relation_child_object,
                "object_type": sensitive_data_model_referential_relation_child_object_type,
                "schema_name": sensitive_data_model_referential_relation_child_schema_name,
                "sensitive_type_ids": sensitive_data_model_referential_relation_child_sensitive_type_ids,
            },
            parent={
                "app_name": sensitive_data_model_referential_relation_parent_app_name,
                "column_groups": sensitive_data_model_referential_relation_parent_column_group,
                "object": sensitive_data_model_referential_relation_parent_object,
                "object_type": sensitive_data_model_referential_relation_parent_object_type,
                "schema_name": sensitive_data_model_referential_relation_parent_schema_name,
                "sensitive_type_ids": sensitive_data_model_referential_relation_parent_sensitive_type_ids,
            },
            relation_type=sensitive_data_model_referential_relation_relation_type,
            sensitive_data_model_id=test_sensitive_data_model["id"],
            is_sensitive=sensitive_data_model_referential_relation_is_sensitive)
        ```

        ## Import

        SensitiveDataModelReferentialRelations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModelReferentialRelation:SensitiveDataModelReferentialRelation test_sensitive_data_model_referential_relation "sensitiveDataModels/{sensitiveDataModelId}/referentialRelations/{referentialRelationKey}"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataModelReferentialRelationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataModelReferentialRelationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationChildArgs', 'SensitiveDataModelReferentialRelationChildArgsDict']]] = None,
                 is_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 parent: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationParentArgs', 'SensitiveDataModelReferentialRelationParentArgsDict']]] = None,
                 relation_type: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataModelReferentialRelationArgs.__new__(SensitiveDataModelReferentialRelationArgs)

            if child is None and not opts.urn:
                raise TypeError("Missing required property 'child'")
            __props__.__dict__["child"] = child
            __props__.__dict__["is_sensitive"] = is_sensitive
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if relation_type is None and not opts.urn:
                raise TypeError("Missing required property 'relation_type'")
            __props__.__dict__["relation_type"] = relation_type
            if sensitive_data_model_id is None and not opts.urn:
                raise TypeError("Missing required property 'sensitive_data_model_id'")
            __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
            __props__.__dict__["key"] = None
            __props__.__dict__["state"] = None
        super(SensitiveDataModelReferentialRelation, __self__).__init__(
            'oci:DataSafe/sensitiveDataModelReferentialRelation:SensitiveDataModelReferentialRelation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationChildArgs', 'SensitiveDataModelReferentialRelationChildArgsDict']]] = None,
            is_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[Union['SensitiveDataModelReferentialRelationParentArgs', 'SensitiveDataModelReferentialRelationParentArgsDict']]] = None,
            relation_type: Optional[pulumi.Input[builtins.str]] = None,
            sensitive_data_model_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'SensitiveDataModelReferentialRelation':
        """
        Get an existing SensitiveDataModelReferentialRelation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SensitiveDataModelReferentialRelationChildArgs', 'SensitiveDataModelReferentialRelationChildArgsDict']] child: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.bool] is_sensitive: Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        :param pulumi.Input[builtins.str] key: The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
        :param pulumi.Input[Union['SensitiveDataModelReferentialRelationParentArgs', 'SensitiveDataModelReferentialRelationParentArgsDict']] parent: columnsInfo object has details of column group with schema details.
        :param pulumi.Input[builtins.str] relation_type: The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[builtins.str] sensitive_data_model_id: The OCID of the sensitive data model.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the referential relation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataModelReferentialRelationState.__new__(_SensitiveDataModelReferentialRelationState)

        __props__.__dict__["child"] = child
        __props__.__dict__["is_sensitive"] = is_sensitive
        __props__.__dict__["key"] = key
        __props__.__dict__["parent"] = parent
        __props__.__dict__["relation_type"] = relation_type
        __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
        __props__.__dict__["state"] = state
        return SensitiveDataModelReferentialRelation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def child(self) -> pulumi.Output['outputs.SensitiveDataModelReferentialRelationChild']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "child")

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> pulumi.Output[builtins.bool]:
        """
        Add to sensitive data model if passed true. If false is passed, then the columns will not be added in the sensitive data model as sensitive columns and  if sensitive type OCIDs are assigned to the columns, then the sensitive type OCIDs will not be retained.
        """
        return pulumi.get(self, "is_sensitive")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The unique key that identifies the referential relation. It's numeric and unique within a sensitive data model.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output['outputs.SensitiveDataModelReferentialRelationParent']:
        """
        columnsInfo object has details of column group with schema details.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of referential relationship the sensitive column has with its parent.  DB_DEFINED indicates that the relationship is defined in the database dictionary.  APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the sensitive data model.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the referential relation.
        """
        return pulumi.get(self, "state")

