# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMlApplicationInstanceResult',
    'AwaitableGetMlApplicationInstanceResult',
    'get_ml_application_instance',
    'get_ml_application_instance_output',
]

@pulumi.output_type
class GetMlApplicationInstanceResult:
    """
    A collection of values returned by getMlApplicationInstance.
    """
    def __init__(__self__, auth_configurations=None, compartment_id=None, configurations=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_enabled=None, lifecycle_details=None, lifecycle_substate=None, ml_application_id=None, ml_application_implementation_id=None, ml_application_implementation_name=None, ml_application_instance_id=None, ml_application_name=None, prediction_endpoint_details=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if auth_configurations and not isinstance(auth_configurations, list):
            raise TypeError("Expected argument 'auth_configurations' to be a list")
        pulumi.set(__self__, "auth_configurations", auth_configurations)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_substate and not isinstance(lifecycle_substate, str):
            raise TypeError("Expected argument 'lifecycle_substate' to be a str")
        pulumi.set(__self__, "lifecycle_substate", lifecycle_substate)
        if ml_application_id and not isinstance(ml_application_id, str):
            raise TypeError("Expected argument 'ml_application_id' to be a str")
        pulumi.set(__self__, "ml_application_id", ml_application_id)
        if ml_application_implementation_id and not isinstance(ml_application_implementation_id, str):
            raise TypeError("Expected argument 'ml_application_implementation_id' to be a str")
        pulumi.set(__self__, "ml_application_implementation_id", ml_application_implementation_id)
        if ml_application_implementation_name and not isinstance(ml_application_implementation_name, str):
            raise TypeError("Expected argument 'ml_application_implementation_name' to be a str")
        pulumi.set(__self__, "ml_application_implementation_name", ml_application_implementation_name)
        if ml_application_instance_id and not isinstance(ml_application_instance_id, str):
            raise TypeError("Expected argument 'ml_application_instance_id' to be a str")
        pulumi.set(__self__, "ml_application_instance_id", ml_application_instance_id)
        if ml_application_name and not isinstance(ml_application_name, str):
            raise TypeError("Expected argument 'ml_application_name' to be a str")
        pulumi.set(__self__, "ml_application_name", ml_application_name)
        if prediction_endpoint_details and not isinstance(prediction_endpoint_details, list):
            raise TypeError("Expected argument 'prediction_endpoint_details' to be a list")
        pulumi.set(__self__, "prediction_endpoint_details", prediction_endpoint_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="authConfigurations")
    def auth_configurations(self) -> Sequence['outputs.GetMlApplicationInstanceAuthConfigurationResult']:
        """
        AuthN/Z configuration for online prediction
        """
        return pulumi.get(self, "auth_configurations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment where the MlApplicationInstance is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetMlApplicationInstanceConfigurationResult']:
        """
        Data that are used for provisioning of the given MlApplicationInstance. These are validated against configurationSchema defined in referenced MlApplicationImplementation.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The name of MlApplicationInstance. System will generate displayName when not provided during creation.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the MlApplicationInstance. Unique identifier that is immutable after creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> builtins.bool:
        """
        States whether the MlApplicationInstance is supposed to be in ACTIVE lifecycle state.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubstate")
    def lifecycle_substate(self) -> builtins.str:
        """
        The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all Oracle Cloud Infrastructure resources. The NEEDS_ATTENTION and FAILED substates are deprecated in favor of (NON_)?RECOVERABLE_(PROVIDER|SERVICE)_ISSUE and will be removed in next release.
        """
        return pulumi.get(self, "lifecycle_substate")

    @property
    @pulumi.getter(name="mlApplicationId")
    def ml_application_id(self) -> builtins.str:
        """
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.
        """
        return pulumi.get(self, "ml_application_id")

    @property
    @pulumi.getter(name="mlApplicationImplementationId")
    def ml_application_implementation_id(self) -> builtins.str:
        """
        The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)
        """
        return pulumi.get(self, "ml_application_implementation_id")

    @property
    @pulumi.getter(name="mlApplicationImplementationName")
    def ml_application_implementation_name(self) -> builtins.str:
        """
        The name of Ml Application Implementation (based on mlApplicationImplementationId)
        """
        return pulumi.get(self, "ml_application_implementation_name")

    @property
    @pulumi.getter(name="mlApplicationInstanceId")
    def ml_application_instance_id(self) -> builtins.str:
        return pulumi.get(self, "ml_application_instance_id")

    @property
    @pulumi.getter(name="mlApplicationName")
    def ml_application_name(self) -> builtins.str:
        """
        The name of ML Application (based on mlApplicationId).
        """
        return pulumi.get(self, "ml_application_name")

    @property
    @pulumi.getter(name="predictionEndpointDetails")
    def prediction_endpoint_details(self) -> Sequence['outputs.GetMlApplicationInstancePredictionEndpointDetailResult']:
        """
        Prediction endpoint related information.
        """
        return pulumi.get(self, "prediction_endpoint_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the MlApplicationInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the MlApplication was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Time of last MlApplicationInstance update in the format defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMlApplicationInstanceResult(GetMlApplicationInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMlApplicationInstanceResult(
            auth_configurations=self.auth_configurations,
            compartment_id=self.compartment_id,
            configurations=self.configurations,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            lifecycle_details=self.lifecycle_details,
            lifecycle_substate=self.lifecycle_substate,
            ml_application_id=self.ml_application_id,
            ml_application_implementation_id=self.ml_application_implementation_id,
            ml_application_implementation_name=self.ml_application_implementation_name,
            ml_application_instance_id=self.ml_application_instance_id,
            ml_application_name=self.ml_application_name,
            prediction_endpoint_details=self.prediction_endpoint_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_ml_application_instance(ml_application_instance_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMlApplicationInstanceResult:
    """
    This data source provides details about a specific Ml Application Instance resource in Oracle Cloud Infrastructure Data Science service.

    Gets a MlApplicationInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_instance = oci.DataScience.get_ml_application_instance(ml_application_instance_id=test_ml_application_instance_oci_datascience_ml_application_instance["id"])
    ```


    :param builtins.str ml_application_instance_id: unique MlApplicationInstance identifier
    """
    __args__ = dict()
    __args__['mlApplicationInstanceId'] = ml_application_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getMlApplicationInstance:getMlApplicationInstance', __args__, opts=opts, typ=GetMlApplicationInstanceResult).value

    return AwaitableGetMlApplicationInstanceResult(
        auth_configurations=pulumi.get(__ret__, 'auth_configurations'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__ret__, 'lifecycle_substate'),
        ml_application_id=pulumi.get(__ret__, 'ml_application_id'),
        ml_application_implementation_id=pulumi.get(__ret__, 'ml_application_implementation_id'),
        ml_application_implementation_name=pulumi.get(__ret__, 'ml_application_implementation_name'),
        ml_application_instance_id=pulumi.get(__ret__, 'ml_application_instance_id'),
        ml_application_name=pulumi.get(__ret__, 'ml_application_name'),
        prediction_endpoint_details=pulumi.get(__ret__, 'prediction_endpoint_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_ml_application_instance_output(ml_application_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMlApplicationInstanceResult]:
    """
    This data source provides details about a specific Ml Application Instance resource in Oracle Cloud Infrastructure Data Science service.

    Gets a MlApplicationInstance by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ml_application_instance = oci.DataScience.get_ml_application_instance(ml_application_instance_id=test_ml_application_instance_oci_datascience_ml_application_instance["id"])
    ```


    :param builtins.str ml_application_instance_id: unique MlApplicationInstance identifier
    """
    __args__ = dict()
    __args__['mlApplicationInstanceId'] = ml_application_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getMlApplicationInstance:getMlApplicationInstance', __args__, opts=opts, typ=GetMlApplicationInstanceResult)
    return __ret__.apply(lambda __response__: GetMlApplicationInstanceResult(
        auth_configurations=pulumi.get(__response__, 'auth_configurations'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        configurations=pulumi.get(__response__, 'configurations'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        lifecycle_substate=pulumi.get(__response__, 'lifecycle_substate'),
        ml_application_id=pulumi.get(__response__, 'ml_application_id'),
        ml_application_implementation_id=pulumi.get(__response__, 'ml_application_implementation_id'),
        ml_application_implementation_name=pulumi.get(__response__, 'ml_application_implementation_name'),
        ml_application_instance_id=pulumi.get(__response__, 'ml_application_instance_id'),
        ml_application_name=pulumi.get(__response__, 'ml_application_name'),
        prediction_endpoint_details=pulumi.get(__response__, 'prediction_endpoint_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
