# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulesResult',
    'AwaitableGetSchedulesResult',
    'get_schedules',
    'get_schedules_output',
]

@pulumi.output_type
class GetSchedulesResult:
    """
    A collection of values returned by getSchedules.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, project_id=None, schedules=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the schedule.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly display name for the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the schedule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the schedule.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetSchedulesScheduleResult']:
        """
        The list of schedules.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the schedule.           Example: `ACTIVE`
        """
        return pulumi.get(self, "state")


class AwaitableGetSchedulesResult(GetSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            project_id=self.project_id,
            schedules=self.schedules,
            state=self.state)


def get_schedules(compartment_id: Optional[builtins.str] = None,
                  display_name: Optional[builtins.str] = None,
                  filters: Optional[Sequence[Union['GetSchedulesFilterArgs', 'GetSchedulesFilterArgsDict']]] = None,
                  id: Optional[builtins.str] = None,
                  project_id: Optional[builtins.str] = None,
                  state: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulesResult:
    """
    This data source provides the list of Schedules in Oracle Cloud Infrastructure Data Science service.

    Returns a list of Schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedules = oci.DataScience.get_schedules(compartment_id=compartment_id,
        display_name=schedule_display_name,
        id=schedule_id,
        project_id=test_project["id"],
        state=schedule_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str id: unique Schedule identifier
    :param builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getSchedules:getSchedules', __args__, opts=opts, typ=GetSchedulesResult).value

    return AwaitableGetSchedulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schedules=pulumi.get(__ret__, 'schedules'),
        state=pulumi.get(__ret__, 'state'))
def get_schedules_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulesFilterArgs', 'GetSchedulesFilterArgsDict']]]]] = None,
                         id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulesResult]:
    """
    This data source provides the list of Schedules in Oracle Cloud Infrastructure Data Science service.

    Returns a list of Schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_schedules = oci.DataScience.get_schedules(compartment_id=compartment_id,
        display_name=schedule_display_name,
        id=schedule_id,
        project_id=test_project["id"],
        state=schedule_state)
    ```


    :param builtins.str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param builtins.str display_name: <b>Filter</b> results by its user-friendly name.
    :param builtins.str id: unique Schedule identifier
    :param builtins.str project_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getSchedules:getSchedules', __args__, opts=opts, typ=GetSchedulesResult)
    return __ret__.apply(lambda __response__: GetSchedulesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        schedules=pulumi.get(__response__, 'schedules'),
        state=pulumi.get(__response__, 'state')))
