# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPatchManagementResult',
    'AwaitableGetPatchManagementResult',
    'get_patch_management',
    'get_patch_management_output',
]

@pulumi.output_type
class GetPatchManagementResult:
    """
    A collection of values returned by getPatchManagement.
    """
    def __init__(__self__, compartment_id=None, database_release=None, defined_tags=None, freeform_tags=None, id=None, images_patch_recommendation_summaries=None, message=None, patch_operations_summaries=None, resources=None, resources_patch_compliance_summaries=None, state=None, system_tags=None, time_enabled=None, time_started_greater_than_or_equal_to=None, time_started_less_than=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_release and not isinstance(database_release, str):
            raise TypeError("Expected argument 'database_release' to be a str")
        pulumi.set(__self__, "database_release", database_release)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images_patch_recommendation_summaries and not isinstance(images_patch_recommendation_summaries, list):
            raise TypeError("Expected argument 'images_patch_recommendation_summaries' to be a list")
        pulumi.set(__self__, "images_patch_recommendation_summaries", images_patch_recommendation_summaries)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if patch_operations_summaries and not isinstance(patch_operations_summaries, list):
            raise TypeError("Expected argument 'patch_operations_summaries' to be a list")
        pulumi.set(__self__, "patch_operations_summaries", patch_operations_summaries)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if resources_patch_compliance_summaries and not isinstance(resources_patch_compliance_summaries, list):
            raise TypeError("Expected argument 'resources_patch_compliance_summaries' to be a list")
        pulumi.set(__self__, "resources_patch_compliance_summaries", resources_patch_compliance_summaries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_enabled and not isinstance(time_enabled, str):
            raise TypeError("Expected argument 'time_enabled' to be a str")
        pulumi.set(__self__, "time_enabled", time_enabled)
        if time_started_greater_than_or_equal_to and not isinstance(time_started_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_started_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_started_greater_than_or_equal_to", time_started_greater_than_or_equal_to)
        if time_started_less_than and not isinstance(time_started_less_than, str):
            raise TypeError("Expected argument 'time_started_less_than' to be a str")
        pulumi.set(__self__, "time_started_less_than", time_started_less_than)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseRelease")
    def database_release(self) -> Optional[builtins.str]:
        return pulumi.get(self, "database_release")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imagesPatchRecommendationSummaries")
    def images_patch_recommendation_summaries(self) -> Sequence['outputs.GetPatchManagementImagesPatchRecommendationSummaryResult']:
        """
        Summary of image patches recommended to install.
        """
        return pulumi.get(self, "images_patch_recommendation_summaries")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message describing the status of the feature's state
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="patchOperationsSummaries")
    def patch_operations_summaries(self) -> Sequence['outputs.GetPatchManagementPatchOperationsSummaryResult']:
        """
        Summary of patch operations.
        """
        return pulumi.get(self, "patch_operations_summaries")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetPatchManagementResourceResult']:
        """
        resources objects
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="resourcesPatchComplianceSummaries")
    def resources_patch_compliance_summaries(self) -> Sequence['outputs.GetPatchManagementResourcesPatchComplianceSummaryResult']:
        """
        Summary of image patches to be compliant to install.
        """
        return pulumi.get(self, "resources_patch_compliance_summaries")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the feature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeEnabled")
    def time_enabled(self) -> builtins.str:
        """
        The time the Vulnerability was enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_enabled")

    @property
    @pulumi.getter(name="timeStartedGreaterThanOrEqualTo")
    def time_started_greater_than_or_equal_to(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_started_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeStartedLessThan")
    def time_started_less_than(self) -> Optional[builtins.str]:
        return pulumi.get(self, "time_started_less_than")


class AwaitableGetPatchManagementResult(GetPatchManagementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchManagementResult(
            compartment_id=self.compartment_id,
            database_release=self.database_release,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            images_patch_recommendation_summaries=self.images_patch_recommendation_summaries,
            message=self.message,
            patch_operations_summaries=self.patch_operations_summaries,
            resources=self.resources,
            resources_patch_compliance_summaries=self.resources_patch_compliance_summaries,
            state=self.state,
            system_tags=self.system_tags,
            time_enabled=self.time_enabled,
            time_started_greater_than_or_equal_to=self.time_started_greater_than_or_equal_to,
            time_started_less_than=self.time_started_less_than)


def get_patch_management(compartment_id: Optional[builtins.str] = None,
                         database_release: Optional[builtins.str] = None,
                         time_started_greater_than_or_equal_to: Optional[builtins.str] = None,
                         time_started_less_than: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchManagementResult:
    """
    This data source provides details about a specific Patch Management resource in Oracle Cloud Infrastructure Dblm service.

    Overview of Patch Management.


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str time_started_greater_than_or_equal_to: A filter to return only resources whose timeStarted is greater than or equal to the given date-time.
    :param builtins.str time_started_less_than: A filter to return only resources whose timeStarted is less than the given date-time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['timeStartedGreaterThanOrEqualTo'] = time_started_greater_than_or_equal_to
    __args__['timeStartedLessThan'] = time_started_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getPatchManagement:getPatchManagement', __args__, opts=opts, typ=GetPatchManagementResult).value

    return AwaitableGetPatchManagementResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_release=pulumi.get(__ret__, 'database_release'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        images_patch_recommendation_summaries=pulumi.get(__ret__, 'images_patch_recommendation_summaries'),
        message=pulumi.get(__ret__, 'message'),
        patch_operations_summaries=pulumi.get(__ret__, 'patch_operations_summaries'),
        resources=pulumi.get(__ret__, 'resources'),
        resources_patch_compliance_summaries=pulumi.get(__ret__, 'resources_patch_compliance_summaries'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_enabled=pulumi.get(__ret__, 'time_enabled'),
        time_started_greater_than_or_equal_to=pulumi.get(__ret__, 'time_started_greater_than_or_equal_to'),
        time_started_less_than=pulumi.get(__ret__, 'time_started_less_than'))
def get_patch_management_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                database_release: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                time_started_greater_than_or_equal_to: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                time_started_less_than: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchManagementResult]:
    """
    This data source provides details about a specific Patch Management resource in Oracle Cloud Infrastructure Dblm service.

    Overview of Patch Management.


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str time_started_greater_than_or_equal_to: A filter to return only resources whose timeStarted is greater than or equal to the given date-time.
    :param builtins.str time_started_less_than: A filter to return only resources whose timeStarted is less than the given date-time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['timeStartedGreaterThanOrEqualTo'] = time_started_greater_than_or_equal_to
    __args__['timeStartedLessThan'] = time_started_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getPatchManagement:getPatchManagement', __args__, opts=opts, typ=GetPatchManagementResult)
    return __ret__.apply(lambda __response__: GetPatchManagementResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_release=pulumi.get(__response__, 'database_release'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        images_patch_recommendation_summaries=pulumi.get(__response__, 'images_patch_recommendation_summaries'),
        message=pulumi.get(__response__, 'message'),
        patch_operations_summaries=pulumi.get(__response__, 'patch_operations_summaries'),
        resources=pulumi.get(__response__, 'resources'),
        resources_patch_compliance_summaries=pulumi.get(__response__, 'resources_patch_compliance_summaries'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_enabled=pulumi.get(__response__, 'time_enabled'),
        time_started_greater_than_or_equal_to=pulumi.get(__response__, 'time_started_greater_than_or_equal_to'),
        time_started_less_than=pulumi.get(__response__, 'time_started_less_than')))
