# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPatchManagementDatabasesResult',
    'AwaitableGetPatchManagementDatabasesResult',
    'get_patch_management_databases',
    'get_patch_management_databases_output',
]

@pulumi.output_type
class GetPatchManagementDatabasesResult:
    """
    A collection of values returned by getPatchManagementDatabases.
    """
    def __init__(__self__, compartment_id=None, database_release=None, database_type=None, display_name=None, drifter_patch_id=None, filters=None, id=None, image_compliance=None, image_id=None, patch_databases_collections=None, severity_types=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_release and not isinstance(database_release, str):
            raise TypeError("Expected argument 'database_release' to be a str")
        pulumi.set(__self__, "database_release", database_release)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if drifter_patch_id and not isinstance(drifter_patch_id, int):
            raise TypeError("Expected argument 'drifter_patch_id' to be a int")
        pulumi.set(__self__, "drifter_patch_id", drifter_patch_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_compliance and not isinstance(image_compliance, str):
            raise TypeError("Expected argument 'image_compliance' to be a str")
        pulumi.set(__self__, "image_compliance", image_compliance)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if patch_databases_collections and not isinstance(patch_databases_collections, list):
            raise TypeError("Expected argument 'patch_databases_collections' to be a list")
        pulumi.set(__self__, "patch_databases_collections", patch_databases_collections)
        if severity_types and not isinstance(severity_types, list):
            raise TypeError("Expected argument 'severity_types' to be a list")
        pulumi.set(__self__, "severity_types", severity_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseRelease")
    def database_release(self) -> Optional[builtins.str]:
        return pulumi.get(self, "database_release")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[builtins.str]:
        """
        Database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drifterPatchId")
    def drifter_patch_id(self) -> Optional[builtins.int]:
        return pulumi.get(self, "drifter_patch_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPatchManagementDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageCompliance")
    def image_compliance(self) -> Optional[builtins.str]:
        return pulumi.get(self, "image_compliance")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[builtins.str]:
        """
        Image identifier.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="patchDatabasesCollections")
    def patch_databases_collections(self) -> Sequence['outputs.GetPatchManagementDatabasesPatchDatabasesCollectionResult']:
        """
        The list of patch_databases_collection.
        """
        return pulumi.get(self, "patch_databases_collections")

    @property
    @pulumi.getter(name="severityTypes")
    def severity_types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "severity_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")


class AwaitableGetPatchManagementDatabasesResult(GetPatchManagementDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPatchManagementDatabasesResult(
            compartment_id=self.compartment_id,
            database_release=self.database_release,
            database_type=self.database_type,
            display_name=self.display_name,
            drifter_patch_id=self.drifter_patch_id,
            filters=self.filters,
            id=self.id,
            image_compliance=self.image_compliance,
            image_id=self.image_id,
            patch_databases_collections=self.patch_databases_collections,
            severity_types=self.severity_types,
            state=self.state)


def get_patch_management_databases(compartment_id: Optional[builtins.str] = None,
                                   database_release: Optional[builtins.str] = None,
                                   database_type: Optional[builtins.str] = None,
                                   display_name: Optional[builtins.str] = None,
                                   drifter_patch_id: Optional[builtins.int] = None,
                                   filters: Optional[Sequence[Union['GetPatchManagementDatabasesFilterArgs', 'GetPatchManagementDatabasesFilterArgsDict']]] = None,
                                   image_compliance: Optional[builtins.str] = None,
                                   image_id: Optional[builtins.str] = None,
                                   severity_types: Optional[Sequence[builtins.str]] = None,
                                   state: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPatchManagementDatabasesResult:
    """
    This data source provides the list of Patch Management Databases in Oracle Cloud Infrastructure Dblm service.

    Gets the list of databases

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patch_management_databases = oci.Dblm.get_patch_management_databases(compartment_id=compartment_id,
        database_release=patch_management_database_database_release,
        database_type=patch_management_database_database_type,
        display_name=patch_management_database_display_name,
        drifter_patch_id=test_patch["id"],
        image_compliance=patch_management_database_image_compliance,
        image_id=test_image["id"],
        severity_types=patch_management_database_severity_type,
        state=patch_management_database_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str database_type: Filter by database type. Possible values Single Instance or RAC.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.int drifter_patch_id: A filter to return only database that have given patchId as additional patch (drifter from image version).
    :param builtins.str image_compliance: Filter databases by image compliance status.
    :param builtins.str image_id: Subscribed image
    :param Sequence[builtins.str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['databaseType'] = database_type
    __args__['displayName'] = display_name
    __args__['drifterPatchId'] = drifter_patch_id
    __args__['filters'] = filters
    __args__['imageCompliance'] = image_compliance
    __args__['imageId'] = image_id
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getPatchManagementDatabases:getPatchManagementDatabases', __args__, opts=opts, typ=GetPatchManagementDatabasesResult).value

    return AwaitableGetPatchManagementDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_release=pulumi.get(__ret__, 'database_release'),
        database_type=pulumi.get(__ret__, 'database_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        drifter_patch_id=pulumi.get(__ret__, 'drifter_patch_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_compliance=pulumi.get(__ret__, 'image_compliance'),
        image_id=pulumi.get(__ret__, 'image_id'),
        patch_databases_collections=pulumi.get(__ret__, 'patch_databases_collections'),
        severity_types=pulumi.get(__ret__, 'severity_types'),
        state=pulumi.get(__ret__, 'state'))
def get_patch_management_databases_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          database_release: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          database_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          drifter_patch_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPatchManagementDatabasesFilterArgs', 'GetPatchManagementDatabasesFilterArgsDict']]]]] = None,
                                          image_compliance: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          image_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          severity_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                          state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPatchManagementDatabasesResult]:
    """
    This data source provides the list of Patch Management Databases in Oracle Cloud Infrastructure Dblm service.

    Gets the list of databases

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_patch_management_databases = oci.Dblm.get_patch_management_databases(compartment_id=compartment_id,
        database_release=patch_management_database_database_release,
        database_type=patch_management_database_database_type,
        display_name=patch_management_database_display_name,
        drifter_patch_id=test_patch["id"],
        image_compliance=patch_management_database_image_compliance,
        image_id=test_image["id"],
        severity_types=patch_management_database_severity_type,
        state=patch_management_database_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str database_type: Filter by database type. Possible values Single Instance or RAC.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.int drifter_patch_id: A filter to return only database that have given patchId as additional patch (drifter from image version).
    :param builtins.str image_compliance: Filter databases by image compliance status.
    :param builtins.str image_id: Subscribed image
    :param Sequence[builtins.str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['databaseType'] = database_type
    __args__['displayName'] = display_name
    __args__['drifterPatchId'] = drifter_patch_id
    __args__['filters'] = filters
    __args__['imageCompliance'] = image_compliance
    __args__['imageId'] = image_id
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getPatchManagementDatabases:getPatchManagementDatabases', __args__, opts=opts, typ=GetPatchManagementDatabasesResult)
    return __ret__.apply(lambda __response__: GetPatchManagementDatabasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_release=pulumi.get(__response__, 'database_release'),
        database_type=pulumi.get(__response__, 'database_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        drifter_patch_id=pulumi.get(__response__, 'drifter_patch_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_compliance=pulumi.get(__response__, 'image_compliance'),
        image_id=pulumi.get(__response__, 'image_id'),
        patch_databases_collections=pulumi.get(__response__, 'patch_databases_collections'),
        severity_types=pulumi.get(__response__, 'severity_types'),
        state=pulumi.get(__response__, 'state')))
