# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVulnerabilityResult',
    'AwaitableGetVulnerabilityResult',
    'get_vulnerability',
    'get_vulnerability_output',
]

@pulumi.output_type
class GetVulnerabilityResult:
    """
    A collection of values returned by getVulnerability.
    """
    def __init__(__self__, compartment_id=None, database_release=None, freeform_tags=None, id=None, message=None, patch_recommendations_summaries=None, resources=None, resources_summaries=None, state=None, system_tags=None, time_enabled=None, vulnerabilities_summaries=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_release and not isinstance(database_release, str):
            raise TypeError("Expected argument 'database_release' to be a str")
        pulumi.set(__self__, "database_release", database_release)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if patch_recommendations_summaries and not isinstance(patch_recommendations_summaries, list):
            raise TypeError("Expected argument 'patch_recommendations_summaries' to be a list")
        pulumi.set(__self__, "patch_recommendations_summaries", patch_recommendations_summaries)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if resources_summaries and not isinstance(resources_summaries, list):
            raise TypeError("Expected argument 'resources_summaries' to be a list")
        pulumi.set(__self__, "resources_summaries", resources_summaries)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_enabled and not isinstance(time_enabled, str):
            raise TypeError("Expected argument 'time_enabled' to be a str")
        pulumi.set(__self__, "time_enabled", time_enabled)
        if vulnerabilities_summaries and not isinstance(vulnerabilities_summaries, list):
            raise TypeError("Expected argument 'vulnerabilities_summaries' to be a list")
        pulumi.set(__self__, "vulnerabilities_summaries", vulnerabilities_summaries)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseRelease")
    def database_release(self) -> Optional[builtins.str]:
        return pulumi.get(self, "database_release")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message describing the status of the feature's state.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="patchRecommendationsSummaries")
    def patch_recommendations_summaries(self) -> Sequence['outputs.GetVulnerabilityPatchRecommendationsSummaryResult']:
        """
        Summary of the patch recommendations for databases.
        """
        return pulumi.get(self, "patch_recommendations_summaries")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetVulnerabilityResourceResult']:
        """
        Resources objects.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="resourcesSummaries")
    def resources_summaries(self) -> Sequence['outputs.GetVulnerabilityResourcesSummaryResult']:
        """
        Summary of dblm registered and unregistered resources.
        """
        return pulumi.get(self, "resources_summaries")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the feature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeEnabled")
    def time_enabled(self) -> builtins.str:
        """
        The time the the Vulnerability was enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_enabled")

    @property
    @pulumi.getter(name="vulnerabilitiesSummaries")
    def vulnerabilities_summaries(self) -> Sequence['outputs.GetVulnerabilityVulnerabilitiesSummaryResult']:
        """
        Summary of vulnerabilities found in registered resources grouped by severity.
        """
        return pulumi.get(self, "vulnerabilities_summaries")


class AwaitableGetVulnerabilityResult(GetVulnerabilityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityResult(
            compartment_id=self.compartment_id,
            database_release=self.database_release,
            freeform_tags=self.freeform_tags,
            id=self.id,
            message=self.message,
            patch_recommendations_summaries=self.patch_recommendations_summaries,
            resources=self.resources,
            resources_summaries=self.resources_summaries,
            state=self.state,
            system_tags=self.system_tags,
            time_enabled=self.time_enabled,
            vulnerabilities_summaries=self.vulnerabilities_summaries)


def get_vulnerability(compartment_id: Optional[builtins.str] = None,
                      database_release: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityResult:
    """
    This data source provides details about a specific Vulnerability resource in Oracle Cloud Infrastructure Dblm service.

    Gets a Vulnerability


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerability:getVulnerability', __args__, opts=opts, typ=GetVulnerabilityResult).value

    return AwaitableGetVulnerabilityResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_release=pulumi.get(__ret__, 'database_release'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        message=pulumi.get(__ret__, 'message'),
        patch_recommendations_summaries=pulumi.get(__ret__, 'patch_recommendations_summaries'),
        resources=pulumi.get(__ret__, 'resources'),
        resources_summaries=pulumi.get(__ret__, 'resources_summaries'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_enabled=pulumi.get(__ret__, 'time_enabled'),
        vulnerabilities_summaries=pulumi.get(__ret__, 'vulnerabilities_summaries'))
def get_vulnerability_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                             database_release: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityResult]:
    """
    This data source provides details about a specific Vulnerability resource in Oracle Cloud Infrastructure Dblm service.

    Gets a Vulnerability


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerability:getVulnerability', __args__, opts=opts, typ=GetVulnerabilityResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_release=pulumi.get(__response__, 'database_release'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        message=pulumi.get(__response__, 'message'),
        patch_recommendations_summaries=pulumi.get(__response__, 'patch_recommendations_summaries'),
        resources=pulumi.get(__response__, 'resources'),
        resources_summaries=pulumi.get(__response__, 'resources_summaries'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_enabled=pulumi.get(__response__, 'time_enabled'),
        vulnerabilities_summaries=pulumi.get(__response__, 'vulnerabilities_summaries')))
