# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVulnerabilityResourcesResult',
    'AwaitableGetVulnerabilityResourcesResult',
    'get_vulnerability_resources',
    'get_vulnerability_resources_output',
]

@pulumi.output_type
class GetVulnerabilityResourcesResult:
    """
    A collection of values returned by getVulnerabilityResources.
    """
    def __init__(__self__, compartment_id=None, cve_id=None, database_release=None, display_name=None, filters=None, id=None, patch_recommendations=None, severity_types=None, state=None, vulnerability_resource_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cve_id and not isinstance(cve_id, str):
            raise TypeError("Expected argument 'cve_id' to be a str")
        pulumi.set(__self__, "cve_id", cve_id)
        if database_release and not isinstance(database_release, str):
            raise TypeError("Expected argument 'database_release' to be a str")
        pulumi.set(__self__, "database_release", database_release)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if patch_recommendations and not isinstance(patch_recommendations, list):
            raise TypeError("Expected argument 'patch_recommendations' to be a list")
        pulumi.set(__self__, "patch_recommendations", patch_recommendations)
        if severity_types and not isinstance(severity_types, list):
            raise TypeError("Expected argument 'severity_types' to be a list")
        pulumi.set(__self__, "severity_types", severity_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vulnerability_resource_collections and not isinstance(vulnerability_resource_collections, list):
            raise TypeError("Expected argument 'vulnerability_resource_collections' to be a list")
        pulumi.set(__self__, "vulnerability_resource_collections", vulnerability_resource_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cveId")
    def cve_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "cve_id")

    @property
    @pulumi.getter(name="databaseRelease")
    def database_release(self) -> Optional[builtins.str]:
        return pulumi.get(self, "database_release")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVulnerabilityResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="patchRecommendations")
    def patch_recommendations(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "patch_recommendations")

    @property
    @pulumi.getter(name="severityTypes")
    def severity_types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "severity_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vulnerabilityResourceCollections")
    def vulnerability_resource_collections(self) -> Sequence['outputs.GetVulnerabilityResourcesVulnerabilityResourceCollectionResult']:
        """
        The list of vulnerability_resource_collection.
        """
        return pulumi.get(self, "vulnerability_resource_collections")


class AwaitableGetVulnerabilityResourcesResult(GetVulnerabilityResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityResourcesResult(
            compartment_id=self.compartment_id,
            cve_id=self.cve_id,
            database_release=self.database_release,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            patch_recommendations=self.patch_recommendations,
            severity_types=self.severity_types,
            state=self.state,
            vulnerability_resource_collections=self.vulnerability_resource_collections)


def get_vulnerability_resources(compartment_id: Optional[builtins.str] = None,
                                cve_id: Optional[builtins.str] = None,
                                database_release: Optional[builtins.str] = None,
                                display_name: Optional[builtins.str] = None,
                                filters: Optional[Sequence[Union['GetVulnerabilityResourcesFilterArgs', 'GetVulnerabilityResourcesFilterArgsDict']]] = None,
                                patch_recommendations: Optional[Sequence[builtins.str]] = None,
                                severity_types: Optional[Sequence[builtins.str]] = None,
                                state: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityResourcesResult:
    """
    This data source provides the list of Vulnerability Resources in Oracle Cloud Infrastructure Dblm service.

    Lists the summary of vulnerable and clean resourcees

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_resources = oci.Dblm.get_vulnerability_resources(compartment_id=compartment_id,
        cve_id=test_cve["id"],
        database_release=vulnerability_resource_database_release,
        display_name=vulnerability_resource_display_name,
        patch_recommendations=vulnerability_resource_patch_recommendation,
        severity_types=vulnerability_resource_severity_type,
        state=vulnerability_resource_state)
    ```


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str cve_id: The id of a CVE.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param Sequence[builtins.str] patch_recommendations: Filter by one or more severity types. Possible values are upToDate, patchAvailable
    :param Sequence[builtins.str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['cveId'] = cve_id
    __args__['databaseRelease'] = database_release
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['patchRecommendations'] = patch_recommendations
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerabilityResources:getVulnerabilityResources', __args__, opts=opts, typ=GetVulnerabilityResourcesResult).value

    return AwaitableGetVulnerabilityResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cve_id=pulumi.get(__ret__, 'cve_id'),
        database_release=pulumi.get(__ret__, 'database_release'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        patch_recommendations=pulumi.get(__ret__, 'patch_recommendations'),
        severity_types=pulumi.get(__ret__, 'severity_types'),
        state=pulumi.get(__ret__, 'state'),
        vulnerability_resource_collections=pulumi.get(__ret__, 'vulnerability_resource_collections'))
def get_vulnerability_resources_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                       cve_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       database_release: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVulnerabilityResourcesFilterArgs', 'GetVulnerabilityResourcesFilterArgsDict']]]]] = None,
                                       patch_recommendations: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                       severity_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityResourcesResult]:
    """
    This data source provides the list of Vulnerability Resources in Oracle Cloud Infrastructure Dblm service.

    Lists the summary of vulnerable and clean resourcees

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_resources = oci.Dblm.get_vulnerability_resources(compartment_id=compartment_id,
        cve_id=test_cve["id"],
        database_release=vulnerability_resource_database_release,
        display_name=vulnerability_resource_display_name,
        patch_recommendations=vulnerability_resource_patch_recommendation,
        severity_types=vulnerability_resource_severity_type,
        state=vulnerability_resource_state)
    ```


    :param builtins.str compartment_id: The required ID of the compartment in which to list resources.
    :param builtins.str cve_id: The id of a CVE.
    :param builtins.str database_release: A filter to return only database that match the given release version.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param Sequence[builtins.str] patch_recommendations: Filter by one or more severity types. Possible values are upToDate, patchAvailable
    :param Sequence[builtins.str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info and none.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['cveId'] = cve_id
    __args__['databaseRelease'] = database_release
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['patchRecommendations'] = patch_recommendations
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerabilityResources:getVulnerabilityResources', __args__, opts=opts, typ=GetVulnerabilityResourcesResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cve_id=pulumi.get(__response__, 'cve_id'),
        database_release=pulumi.get(__response__, 'database_release'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        patch_recommendations=pulumi.get(__response__, 'patch_recommendations'),
        severity_types=pulumi.get(__response__, 'severity_types'),
        state=pulumi.get(__response__, 'state'),
        vulnerability_resource_collections=pulumi.get(__response__, 'vulnerability_resource_collections')))
