# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDelegationSubscriptionResult',
    'AwaitableGetDelegationSubscriptionResult',
    'get_delegation_subscription',
    'get_delegation_subscription_output',
]

@pulumi.output_type
class GetDelegationSubscriptionResult:
    """
    A collection of values returned by getDelegationSubscription.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, delegation_subscription_id=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_state_details=None, service_provider_id=None, state=None, subscribed_service_type=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if delegation_subscription_id and not isinstance(delegation_subscription_id, str):
            raise TypeError("Expected argument 'delegation_subscription_id' to be a str")
        pulumi.set(__self__, "delegation_subscription_id", delegation_subscription_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if service_provider_id and not isinstance(service_provider_id, str):
            raise TypeError("Expected argument 'service_provider_id' to be a str")
        pulumi.set(__self__, "service_provider_id", service_provider_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscribed_service_type and not isinstance(subscribed_service_type, str):
            raise TypeError("Expected argument 'subscribed_service_type' to be a str")
        pulumi.set(__self__, "subscribed_service_type", subscribed_service_type)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the Delegation Subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="delegationSubscriptionId")
    def delegation_subscription_id(self) -> builtins.str:
        return pulumi.get(self, "delegation_subscription_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the Delegation Subscription.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier for the Delegation Subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> builtins.str:
        """
        Unique identifier of the Service Provider.
        """
        return pulumi.get(self, "service_provider_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the Service Provider.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscribedServiceType")
    def subscribed_service_type(self) -> builtins.str:
        """
        Subscribed Service Provider Service Type.
        """
        return pulumi.get(self, "subscribed_service_type")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDelegationSubscriptionResult(GetDelegationSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegationSubscriptionResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            delegation_subscription_id=self.delegation_subscription_id,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            service_provider_id=self.service_provider_id,
            state=self.state,
            subscribed_service_type=self.subscribed_service_type,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_delegation_subscription(delegation_subscription_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegationSubscriptionResult:
    """
    This data source provides details about a specific Delegation Subscription resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets a DelegationSubscription by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegation_subscription = oci.DelegateAccessControl.get_delegation_subscription(delegation_subscription_id=test_delegation_subscription_oci_delegate_access_control_delegation_subscription["id"])
    ```


    :param builtins.str delegation_subscription_id: unique Delegation Subscription identifier
    """
    __args__ = dict()
    __args__['delegationSubscriptionId'] = delegation_subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getDelegationSubscription:getDelegationSubscription', __args__, opts=opts, typ=GetDelegationSubscriptionResult).value

    return AwaitableGetDelegationSubscriptionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        delegation_subscription_id=pulumi.get(__ret__, 'delegation_subscription_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        service_provider_id=pulumi.get(__ret__, 'service_provider_id'),
        state=pulumi.get(__ret__, 'state'),
        subscribed_service_type=pulumi.get(__ret__, 'subscribed_service_type'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_delegation_subscription_output(delegation_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDelegationSubscriptionResult]:
    """
    This data source provides details about a specific Delegation Subscription resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets a DelegationSubscription by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegation_subscription = oci.DelegateAccessControl.get_delegation_subscription(delegation_subscription_id=test_delegation_subscription_oci_delegate_access_control_delegation_subscription["id"])
    ```


    :param builtins.str delegation_subscription_id: unique Delegation Subscription identifier
    """
    __args__ = dict()
    __args__['delegationSubscriptionId'] = delegation_subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DelegateAccessControl/getDelegationSubscription:getDelegationSubscription', __args__, opts=opts, typ=GetDelegationSubscriptionResult)
    return __ret__.apply(lambda __response__: GetDelegationSubscriptionResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        delegation_subscription_id=pulumi.get(__response__, 'delegation_subscription_id'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        service_provider_id=pulumi.get(__response__, 'service_provider_id'),
        state=pulumi.get(__response__, 'state'),
        subscribed_service_type=pulumi.get(__response__, 'subscribed_service_type'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
