# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoryDiffResult',
    'AwaitableGetRepositoryDiffResult',
    'get_repository_diff',
    'get_repository_diff_output',
]

@pulumi.output_type
class GetRepositoryDiffResult:
    """
    A collection of values returned by getRepositoryDiff.
    """
    def __init__(__self__, are_conflicts_in_file=None, base_version=None, changes=None, file_path=None, id=None, is_binary=None, is_comparison_from_merge_base=None, is_large=None, new_id=None, new_path=None, old_id=None, old_path=None, repository_id=None, target_version=None):
        if are_conflicts_in_file and not isinstance(are_conflicts_in_file, bool):
            raise TypeError("Expected argument 'are_conflicts_in_file' to be a bool")
        pulumi.set(__self__, "are_conflicts_in_file", are_conflicts_in_file)
        if base_version and not isinstance(base_version, str):
            raise TypeError("Expected argument 'base_version' to be a str")
        pulumi.set(__self__, "base_version", base_version)
        if changes and not isinstance(changes, list):
            raise TypeError("Expected argument 'changes' to be a list")
        pulumi.set(__self__, "changes", changes)
        if file_path and not isinstance(file_path, str):
            raise TypeError("Expected argument 'file_path' to be a str")
        pulumi.set(__self__, "file_path", file_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_binary and not isinstance(is_binary, bool):
            raise TypeError("Expected argument 'is_binary' to be a bool")
        pulumi.set(__self__, "is_binary", is_binary)
        if is_comparison_from_merge_base and not isinstance(is_comparison_from_merge_base, bool):
            raise TypeError("Expected argument 'is_comparison_from_merge_base' to be a bool")
        pulumi.set(__self__, "is_comparison_from_merge_base", is_comparison_from_merge_base)
        if is_large and not isinstance(is_large, bool):
            raise TypeError("Expected argument 'is_large' to be a bool")
        pulumi.set(__self__, "is_large", is_large)
        if new_id and not isinstance(new_id, str):
            raise TypeError("Expected argument 'new_id' to be a str")
        pulumi.set(__self__, "new_id", new_id)
        if new_path and not isinstance(new_path, str):
            raise TypeError("Expected argument 'new_path' to be a str")
        pulumi.set(__self__, "new_path", new_path)
        if old_id and not isinstance(old_id, str):
            raise TypeError("Expected argument 'old_id' to be a str")
        pulumi.set(__self__, "old_id", old_id)
        if old_path and not isinstance(old_path, str):
            raise TypeError("Expected argument 'old_path' to be a str")
        pulumi.set(__self__, "old_path", old_path)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="areConflictsInFile")
    def are_conflicts_in_file(self) -> builtins.bool:
        """
        Indicates whether the changed file contains conflicts.
        """
        return pulumi.get(self, "are_conflicts_in_file")

    @property
    @pulumi.getter(name="baseVersion")
    def base_version(self) -> builtins.str:
        return pulumi.get(self, "base_version")

    @property
    @pulumi.getter
    def changes(self) -> Sequence['outputs.GetRepositoryDiffChangeResult']:
        """
        List of changed section in the file.
        """
        return pulumi.get(self, "changes")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> builtins.str:
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBinary")
    def is_binary(self) -> builtins.bool:
        """
        Indicates whether the file is binary.
        """
        return pulumi.get(self, "is_binary")

    @property
    @pulumi.getter(name="isComparisonFromMergeBase")
    def is_comparison_from_merge_base(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_comparison_from_merge_base")

    @property
    @pulumi.getter(name="isLarge")
    def is_large(self) -> builtins.bool:
        """
        Indicates whether the file is large.
        """
        return pulumi.get(self, "is_large")

    @property
    @pulumi.getter(name="newId")
    def new_id(self) -> builtins.str:
        """
        The ID of the changed object on the target version.
        """
        return pulumi.get(self, "new_id")

    @property
    @pulumi.getter(name="newPath")
    def new_path(self) -> builtins.str:
        """
        The path on the target version to the changed object.
        """
        return pulumi.get(self, "new_path")

    @property
    @pulumi.getter(name="oldId")
    def old_id(self) -> builtins.str:
        """
        The ID of the changed object on the base version.
        """
        return pulumi.get(self, "old_id")

    @property
    @pulumi.getter(name="oldPath")
    def old_path(self) -> builtins.str:
        """
        The path on the base version to the changed object.
        """
        return pulumi.get(self, "old_path")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> builtins.str:
        return pulumi.get(self, "target_version")


class AwaitableGetRepositoryDiffResult(GetRepositoryDiffResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryDiffResult(
            are_conflicts_in_file=self.are_conflicts_in_file,
            base_version=self.base_version,
            changes=self.changes,
            file_path=self.file_path,
            id=self.id,
            is_binary=self.is_binary,
            is_comparison_from_merge_base=self.is_comparison_from_merge_base,
            is_large=self.is_large,
            new_id=self.new_id,
            new_path=self.new_path,
            old_id=self.old_id,
            old_path=self.old_path,
            repository_id=self.repository_id,
            target_version=self.target_version)


def get_repository_diff(base_version: Optional[builtins.str] = None,
                        file_path: Optional[builtins.str] = None,
                        is_comparison_from_merge_base: Optional[builtins.bool] = None,
                        repository_id: Optional[builtins.str] = None,
                        target_version: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryDiffResult:
    """
    This data source provides details about a specific Repository Diff resource in Oracle Cloud Infrastructure Devops service.

    Gets the line-by-line difference between file on different commits. This API will be deprecated on Wed, 29 Mar 2023 01:00:00 GMT as it does not get recognized when filePath has '/'. This will be replaced by "/repositories/{repositoryId}/file/diffs"

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diff = oci.DevOps.get_repository_diff(base_version=repository_diff_base_version,
        file_path=repository_diff_file_path,
        repository_id=test_repository["id"],
        target_version=repository_diff_target_version,
        is_comparison_from_merge_base=repository_diff_is_comparison_from_merge_base)
    ```


    :param builtins.str base_version: The branch to compare changes against.
    :param builtins.str file_path: Path to a file within a repository.
    :param builtins.bool is_comparison_from_merge_base: Boolean to indicate whether to use merge base or most recent revision.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str target_version: The branch where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filePath'] = file_path
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryDiff:getRepositoryDiff', __args__, opts=opts, typ=GetRepositoryDiffResult).value

    return AwaitableGetRepositoryDiffResult(
        are_conflicts_in_file=pulumi.get(__ret__, 'are_conflicts_in_file'),
        base_version=pulumi.get(__ret__, 'base_version'),
        changes=pulumi.get(__ret__, 'changes'),
        file_path=pulumi.get(__ret__, 'file_path'),
        id=pulumi.get(__ret__, 'id'),
        is_binary=pulumi.get(__ret__, 'is_binary'),
        is_comparison_from_merge_base=pulumi.get(__ret__, 'is_comparison_from_merge_base'),
        is_large=pulumi.get(__ret__, 'is_large'),
        new_id=pulumi.get(__ret__, 'new_id'),
        new_path=pulumi.get(__ret__, 'new_path'),
        old_id=pulumi.get(__ret__, 'old_id'),
        old_path=pulumi.get(__ret__, 'old_path'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        target_version=pulumi.get(__ret__, 'target_version'))
def get_repository_diff_output(base_version: Optional[pulumi.Input[builtins.str]] = None,
                               file_path: Optional[pulumi.Input[builtins.str]] = None,
                               is_comparison_from_merge_base: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               repository_id: Optional[pulumi.Input[builtins.str]] = None,
                               target_version: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryDiffResult]:
    """
    This data source provides details about a specific Repository Diff resource in Oracle Cloud Infrastructure Devops service.

    Gets the line-by-line difference between file on different commits. This API will be deprecated on Wed, 29 Mar 2023 01:00:00 GMT as it does not get recognized when filePath has '/'. This will be replaced by "/repositories/{repositoryId}/file/diffs"

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diff = oci.DevOps.get_repository_diff(base_version=repository_diff_base_version,
        file_path=repository_diff_file_path,
        repository_id=test_repository["id"],
        target_version=repository_diff_target_version,
        is_comparison_from_merge_base=repository_diff_is_comparison_from_merge_base)
    ```


    :param builtins.str base_version: The branch to compare changes against.
    :param builtins.str file_path: Path to a file within a repository.
    :param builtins.bool is_comparison_from_merge_base: Boolean to indicate whether to use merge base or most recent revision.
    :param builtins.str repository_id: Unique repository identifier.
    :param builtins.str target_version: The branch where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filePath'] = file_path
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepositoryDiff:getRepositoryDiff', __args__, opts=opts, typ=GetRepositoryDiffResult)
    return __ret__.apply(lambda __response__: GetRepositoryDiffResult(
        are_conflicts_in_file=pulumi.get(__response__, 'are_conflicts_in_file'),
        base_version=pulumi.get(__response__, 'base_version'),
        changes=pulumi.get(__response__, 'changes'),
        file_path=pulumi.get(__response__, 'file_path'),
        id=pulumi.get(__response__, 'id'),
        is_binary=pulumi.get(__response__, 'is_binary'),
        is_comparison_from_merge_base=pulumi.get(__response__, 'is_comparison_from_merge_base'),
        is_large=pulumi.get(__response__, 'is_large'),
        new_id=pulumi.get(__response__, 'new_id'),
        new_path=pulumi.get(__response__, 'new_path'),
        old_id=pulumi.get(__response__, 'old_id'),
        old_path=pulumi.get(__response__, 'old_path'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        target_version=pulumi.get(__response__, 'target_version')))
