# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSteeringPolicyResult',
    'AwaitableGetSteeringPolicyResult',
    'get_steering_policy',
    'get_steering_policy_output',
]

@pulumi.output_type
class GetSteeringPolicyResult:
    """
    A collection of values returned by getSteeringPolicy.
    """
    def __init__(__self__, answers=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, health_check_monitor_id=None, id=None, rules=None, self=None, state=None, steering_policy_id=None, template=None, time_created=None, ttl=None):
        if answers and not isinstance(answers, list):
            raise TypeError("Expected argument 'answers' to be a list")
        pulumi.set(__self__, "answers", answers)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if health_check_monitor_id and not isinstance(health_check_monitor_id, str):
            raise TypeError("Expected argument 'health_check_monitor_id' to be a str")
        pulumi.set(__self__, "health_check_monitor_id", health_check_monitor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if steering_policy_id and not isinstance(steering_policy_id, str):
            raise TypeError("Expected argument 'steering_policy_id' to be a str")
        pulumi.set(__self__, "steering_policy_id", steering_policy_id)
        if template and not isinstance(template, str):
            raise TypeError("Expected argument 'template' to be a str")
        pulumi.set(__self__, "template", template)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def answers(self) -> Sequence['outputs.GetSteeringPolicyAnswerResult']:
        """
        The set of all answers that can potentially issue from the steering policy.
        """
        return pulumi.get(self, "answers")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the steering policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name for the steering policy. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="healthCheckMonitorId")
    def health_check_monitor_id(self) -> builtins.str:
        """
        The OCID of the health check monitor providing health data about the answers of the steering policy. A steering policy answer with `rdata` matching a monitored endpoint will use the health data of that endpoint. A steering policy answer with `rdata` not matching any monitored endpoint will be assumed healthy.
        """
        return pulumi.get(self, "health_check_monitor_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSteeringPolicyRuleResult']:
        """
        The series of rules that will be processed in sequence to reduce the pool of answers to a response for any given request.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def self(self) -> builtins.str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="steeringPolicyId")
    def steering_policy_id(self) -> builtins.str:
        return pulumi.get(self, "steering_policy_id")

    @property
    @pulumi.getter
    def template(self) -> builtins.str:
        """
        A set of predefined rules based on the desired purpose of the steering policy. Each template utilizes Traffic Management's rules in a different order to produce the desired results when answering DNS queries.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def ttl(self) -> builtins.int:
        """
        The Time To Live (TTL) for responses from the steering policy, in seconds. If not specified during creation, a value of 30 seconds will be used.
        """
        return pulumi.get(self, "ttl")


class AwaitableGetSteeringPolicyResult(GetSteeringPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSteeringPolicyResult(
            answers=self.answers,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            health_check_monitor_id=self.health_check_monitor_id,
            id=self.id,
            rules=self.rules,
            self=self.self,
            state=self.state,
            steering_policy_id=self.steering_policy_id,
            template=self.template,
            time_created=self.time_created,
            ttl=self.ttl)


def get_steering_policy(steering_policy_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSteeringPolicyResult:
    """
    This data source provides details about a specific Steering Policy resource in Oracle Cloud Infrastructure DNS service.

    Gets information about the specified steering policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policy = oci.Dns.get_steering_policy(steering_policy_id=test_steering_policy_oci_dns_steering_policy["id"])
    ```


    :param builtins.str steering_policy_id: The OCID of the target steering policy.
    """
    __args__ = dict()
    __args__['steeringPolicyId'] = steering_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getSteeringPolicy:getSteeringPolicy', __args__, opts=opts, typ=GetSteeringPolicyResult).value

    return AwaitableGetSteeringPolicyResult(
        answers=pulumi.get(__ret__, 'answers'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        health_check_monitor_id=pulumi.get(__ret__, 'health_check_monitor_id'),
        id=pulumi.get(__ret__, 'id'),
        rules=pulumi.get(__ret__, 'rules'),
        self=pulumi.get(__ret__, 'self'),
        state=pulumi.get(__ret__, 'state'),
        steering_policy_id=pulumi.get(__ret__, 'steering_policy_id'),
        template=pulumi.get(__ret__, 'template'),
        time_created=pulumi.get(__ret__, 'time_created'),
        ttl=pulumi.get(__ret__, 'ttl'))
def get_steering_policy_output(steering_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSteeringPolicyResult]:
    """
    This data source provides details about a specific Steering Policy resource in Oracle Cloud Infrastructure DNS service.

    Gets information about the specified steering policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policy = oci.Dns.get_steering_policy(steering_policy_id=test_steering_policy_oci_dns_steering_policy["id"])
    ```


    :param builtins.str steering_policy_id: The OCID of the target steering policy.
    """
    __args__ = dict()
    __args__['steeringPolicyId'] = steering_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dns/getSteeringPolicy:getSteeringPolicy', __args__, opts=opts, typ=GetSteeringPolicyResult)
    return __ret__.apply(lambda __response__: GetSteeringPolicyResult(
        answers=pulumi.get(__response__, 'answers'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        health_check_monitor_id=pulumi.get(__response__, 'health_check_monitor_id'),
        id=pulumi.get(__response__, 'id'),
        rules=pulumi.get(__response__, 'rules'),
        self=pulumi.get(__response__, 'self'),
        state=pulumi.get(__response__, 'state'),
        steering_policy_id=pulumi.get(__response__, 'steering_policy_id'),
        template=pulumi.get(__response__, 'template'),
        time_created=pulumi.get(__response__, 'time_created'),
        ttl=pulumi.get(__response__, 'ttl')))
