# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOutboundConnectorResult',
    'AwaitableGetOutboundConnectorResult',
    'get_outbound_connector',
    'get_outbound_connector_output',
]

@pulumi.output_type
class GetOutboundConnectorResult:
    """
    A collection of values returned by getOutboundConnector.
    """
    def __init__(__self__, availability_domain=None, bind_distinguished_name=None, compartment_id=None, connector_type=None, defined_tags=None, display_name=None, endpoints=None, freeform_tags=None, id=None, is_lock_override=None, locks=None, outbound_connector_id=None, password_secret_id=None, password_secret_version=None, state=None, system_tags=None, time_created=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if bind_distinguished_name and not isinstance(bind_distinguished_name, str):
            raise TypeError("Expected argument 'bind_distinguished_name' to be a str")
        pulumi.set(__self__, "bind_distinguished_name", bind_distinguished_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connector_type and not isinstance(connector_type, str):
            raise TypeError("Expected argument 'connector_type' to be a str")
        pulumi.set(__self__, "connector_type", connector_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if outbound_connector_id and not isinstance(outbound_connector_id, str):
            raise TypeError("Expected argument 'outbound_connector_id' to be a str")
        pulumi.set(__self__, "outbound_connector_id", outbound_connector_id)
        if password_secret_id and not isinstance(password_secret_id, str):
            raise TypeError("Expected argument 'password_secret_id' to be a str")
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        if password_secret_version and not isinstance(password_secret_version, int):
            raise TypeError("Expected argument 'password_secret_version' to be a int")
        pulumi.set(__self__, "password_secret_version", password_secret_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bindDistinguishedName")
    def bind_distinguished_name(self) -> builtins.str:
        """
        The LDAP Distinguished Name of the account.
        """
        return pulumi.get(self, "bind_distinguished_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> builtins.str:
        """
        The account type of this outbound connector.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetOutboundConnectorEndpointResult']:
        """
        Array of server endpoints to use when connecting with the LDAP bind account.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the outbound connector.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetOutboundConnectorLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="outboundConnectorId")
    def outbound_connector_id(self) -> builtins.str:
        return pulumi.get(self, "outbound_connector_id")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> builtins.int:
        """
        Version of the password secret in the Vault to use.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of this outbound connector.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetOutboundConnectorResult(GetOutboundConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOutboundConnectorResult(
            availability_domain=self.availability_domain,
            bind_distinguished_name=self.bind_distinguished_name,
            compartment_id=self.compartment_id,
            connector_type=self.connector_type,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            endpoints=self.endpoints,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_lock_override=self.is_lock_override,
            locks=self.locks,
            outbound_connector_id=self.outbound_connector_id,
            password_secret_id=self.password_secret_id,
            password_secret_version=self.password_secret_version,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_outbound_connector(outbound_connector_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOutboundConnectorResult:
    """
    This data source provides details about a specific Outbound Connector resource in Oracle Cloud Infrastructure File Storage service.

    Gets the specified outbound connector's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_outbound_connector = oci.FileStorage.get_outbound_connector(outbound_connector_id=test_outbound_connector_oci_file_storage_outbound_connector["id"])
    ```


    :param builtins.str outbound_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the outbound connector.
    """
    __args__ = dict()
    __args__['outboundConnectorId'] = outbound_connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FileStorage/getOutboundConnector:getOutboundConnector', __args__, opts=opts, typ=GetOutboundConnectorResult).value

    return AwaitableGetOutboundConnectorResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        bind_distinguished_name=pulumi.get(__ret__, 'bind_distinguished_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connector_type=pulumi.get(__ret__, 'connector_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        locks=pulumi.get(__ret__, 'locks'),
        outbound_connector_id=pulumi.get(__ret__, 'outbound_connector_id'),
        password_secret_id=pulumi.get(__ret__, 'password_secret_id'),
        password_secret_version=pulumi.get(__ret__, 'password_secret_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_outbound_connector_output(outbound_connector_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOutboundConnectorResult]:
    """
    This data source provides details about a specific Outbound Connector resource in Oracle Cloud Infrastructure File Storage service.

    Gets the specified outbound connector's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_outbound_connector = oci.FileStorage.get_outbound_connector(outbound_connector_id=test_outbound_connector_oci_file_storage_outbound_connector["id"])
    ```


    :param builtins.str outbound_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the outbound connector.
    """
    __args__ = dict()
    __args__['outboundConnectorId'] = outbound_connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FileStorage/getOutboundConnector:getOutboundConnector', __args__, opts=opts, typ=GetOutboundConnectorResult)
    return __ret__.apply(lambda __response__: GetOutboundConnectorResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        bind_distinguished_name=pulumi.get(__response__, 'bind_distinguished_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connector_type=pulumi.get(__response__, 'connector_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoints=pulumi.get(__response__, 'endpoints'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        locks=pulumi.get(__response__, 'locks'),
        outbound_connector_id=pulumi.get(__response__, 'outbound_connector_id'),
        password_secret_id=pulumi.get(__response__, 'password_secret_id'),
        password_secret_version=pulumi.get(__response__, 'password_secret_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
