# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMaintenanceWindowResult',
    'AwaitableGetMaintenanceWindowResult',
    'get_maintenance_window',
    'get_maintenance_window_output',
]

@pulumi.output_type
class GetMaintenanceWindowResult:
    """
    A collection of values returned by getMaintenanceWindow.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, duration=None, freeform_tags=None, id=None, is_outage=None, is_recurring=None, lifecycle_details=None, maintenance_window_id=None, recurrences=None, resource_region=None, state=None, system_tags=None, time_created=None, time_schedule_start=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_outage and not isinstance(is_outage, bool):
            raise TypeError("Expected argument 'is_outage' to be a bool")
        pulumi.set(__self__, "is_outage", is_outage)
        if is_recurring and not isinstance(is_recurring, bool):
            raise TypeError("Expected argument 'is_recurring' to be a bool")
        pulumi.set(__self__, "is_recurring", is_recurring)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window_id and not isinstance(maintenance_window_id, str):
            raise TypeError("Expected argument 'maintenance_window_id' to be a str")
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        if recurrences and not isinstance(recurrences, str):
            raise TypeError("Expected argument 'recurrences' to be a str")
        pulumi.set(__self__, "recurrences", recurrences)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_schedule_start and not isinstance(time_schedule_start, str):
            raise TypeError("Expected argument 'time_schedule_start' to be a str")
        pulumi.set(__self__, "time_schedule_start", time_schedule_start)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        Duration of the maintenance window. Specify how long the maintenance window remains open.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isOutage")
    def is_outage(self) -> builtins.bool:
        """
        Does the maintenenace window cause outage? An outage indicates whether a maintenance window can consider operations that require downtime. It means a period when the application is not accessible.
        """
        return pulumi.get(self, "is_outage")

    @property
    @pulumi.getter(name="isRecurring")
    def is_recurring(self) -> builtins.bool:
        """
        Is this a recurring maintenance window?
        """
        return pulumi.get(self, "is_recurring")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> builtins.str:
        return pulumi.get(self, "maintenance_window_id")

    @property
    @pulumi.getter
    def recurrences(self) -> builtins.str:
        """
        Recurrence rule specification if maintenance window recurring. Specify the frequency of running the maintenance window.
        """
        return pulumi.get(self, "recurrences")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the MaintenanceWindow.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> builtins.str:
        """
        Specify the date and time of the day that the maintenance window starts.
        """
        return pulumi.get(self, "time_schedule_start")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMaintenanceWindowResult(GetMaintenanceWindowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceWindowResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            duration=self.duration,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_outage=self.is_outage,
            is_recurring=self.is_recurring,
            lifecycle_details=self.lifecycle_details,
            maintenance_window_id=self.maintenance_window_id,
            recurrences=self.recurrences,
            resource_region=self.resource_region,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_schedule_start=self.time_schedule_start,
            time_updated=self.time_updated)


def get_maintenance_window(maintenance_window_id: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceWindowResult:
    """
    This data source provides details about a specific Maintenance Window resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details for a maintenance window in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_window = oci.FleetAppsManagement.get_maintenance_window(maintenance_window_id=test_maintenance_window_oci_fleet_apps_management_maintenance_window["id"])
    ```


    :param builtins.str maintenance_window_id: unique MaintenanceWindow identifier
    """
    __args__ = dict()
    __args__['maintenanceWindowId'] = maintenance_window_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getMaintenanceWindow:getMaintenanceWindow', __args__, opts=opts, typ=GetMaintenanceWindowResult).value

    return AwaitableGetMaintenanceWindowResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        duration=pulumi.get(__ret__, 'duration'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_outage=pulumi.get(__ret__, 'is_outage'),
        is_recurring=pulumi.get(__ret__, 'is_recurring'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_window_id=pulumi.get(__ret__, 'maintenance_window_id'),
        recurrences=pulumi.get(__ret__, 'recurrences'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_schedule_start=pulumi.get(__ret__, 'time_schedule_start'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_maintenance_window_output(maintenance_window_id: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaintenanceWindowResult]:
    """
    This data source provides details about a specific Maintenance Window resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Get the details for a maintenance window in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_window = oci.FleetAppsManagement.get_maintenance_window(maintenance_window_id=test_maintenance_window_oci_fleet_apps_management_maintenance_window["id"])
    ```


    :param builtins.str maintenance_window_id: unique MaintenanceWindow identifier
    """
    __args__ = dict()
    __args__['maintenanceWindowId'] = maintenance_window_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getMaintenanceWindow:getMaintenanceWindow', __args__, opts=opts, typ=GetMaintenanceWindowResult)
    return __ret__.apply(lambda __response__: GetMaintenanceWindowResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        duration=pulumi.get(__response__, 'duration'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_outage=pulumi.get(__response__, 'is_outage'),
        is_recurring=pulumi.get(__response__, 'is_recurring'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        maintenance_window_id=pulumi.get(__response__, 'maintenance_window_id'),
        recurrences=pulumi.get(__response__, 'recurrences'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_schedule_start=pulumi.get(__response__, 'time_schedule_start'),
        time_updated=pulumi.get(__response__, 'time_updated')))
