# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPlatformConfigurationResult',
    'AwaitableGetPlatformConfigurationResult',
    'get_platform_configuration',
    'get_platform_configuration_output',
]

@pulumi.output_type
class GetPlatformConfigurationResult:
    """
    A collection of values returned by getPlatformConfiguration.
    """
    def __init__(__self__, compartment_id=None, config_category_details=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, platform_configuration_id=None, resource_region=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_category_details and not isinstance(config_category_details, list):
            raise TypeError("Expected argument 'config_category_details' to be a list")
        pulumi.set(__self__, "config_category_details", config_category_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if platform_configuration_id and not isinstance(platform_configuration_id, str):
            raise TypeError("Expected argument 'platform_configuration_id' to be a str")
        pulumi.set(__self__, "platform_configuration_id", platform_configuration_id)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configCategoryDetails")
    def config_category_details(self) -> Sequence['outputs.GetPlatformConfigurationConfigCategoryDetailResult']:
        """
        Config Category Details.
        """
        return pulumi.get(self, "config_category_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="platformConfigurationId")
    def platform_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "platform_configuration_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> builtins.str:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the PlatformConfiguration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the configuration.
        """
        return pulumi.get(self, "type")


class AwaitableGetPlatformConfigurationResult(GetPlatformConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlatformConfigurationResult(
            compartment_id=self.compartment_id,
            config_category_details=self.config_category_details,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            platform_configuration_id=self.platform_configuration_id,
            resource_region=self.resource_region,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_platform_configuration(platform_configuration_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlatformConfigurationResult:
    """
    This data source provides details about a specific Platform Configuration resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a PlatformConfiguration by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_platform_configuration = oci.FleetAppsManagement.get_platform_configuration(platform_configuration_id=test_platform_configuration_oci_fleet_apps_management_platform_configuration["id"])
    ```


    :param builtins.str platform_configuration_id: unique PlatformConfiguration identifier
    """
    __args__ = dict()
    __args__['platformConfigurationId'] = platform_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getPlatformConfiguration:getPlatformConfiguration', __args__, opts=opts, typ=GetPlatformConfigurationResult).value

    return AwaitableGetPlatformConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_category_details=pulumi.get(__ret__, 'config_category_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        platform_configuration_id=pulumi.get(__ret__, 'platform_configuration_id'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_platform_configuration_output(platform_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlatformConfigurationResult]:
    """
    This data source provides details about a specific Platform Configuration resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a PlatformConfiguration by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_platform_configuration = oci.FleetAppsManagement.get_platform_configuration(platform_configuration_id=test_platform_configuration_oci_fleet_apps_management_platform_configuration["id"])
    ```


    :param builtins.str platform_configuration_id: unique PlatformConfiguration identifier
    """
    __args__ = dict()
    __args__['platformConfigurationId'] = platform_configuration_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getPlatformConfiguration:getPlatformConfiguration', __args__, opts=opts, typ=GetPlatformConfigurationResult)
    return __ret__.apply(lambda __response__: GetPlatformConfigurationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_category_details=pulumi.get(__response__, 'config_category_details'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        platform_configuration_id=pulumi.get(__response__, 'platform_configuration_id'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
