# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFsuCollectionResult',
    'AwaitableGetFsuCollectionResult',
    'get_fsu_collection',
    'get_fsu_collection_output',
]

@pulumi.output_type
class GetFsuCollectionResult:
    """
    A collection of values returned by getFsuCollection.
    """
    def __init__(__self__, active_fsu_cycles=None, compartment_id=None, defined_tags=None, display_name=None, fleet_discoveries=None, freeform_tags=None, fsu_collection_id=None, id=None, last_completed_fsu_cycle_id=None, lifecycle_details=None, service_type=None, source_major_version=None, state=None, system_tags=None, target_count=None, time_created=None, time_updated=None, type=None):
        if active_fsu_cycles and not isinstance(active_fsu_cycles, list):
            raise TypeError("Expected argument 'active_fsu_cycles' to be a list")
        pulumi.set(__self__, "active_fsu_cycles", active_fsu_cycles)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fleet_discoveries and not isinstance(fleet_discoveries, list):
            raise TypeError("Expected argument 'fleet_discoveries' to be a list")
        pulumi.set(__self__, "fleet_discoveries", fleet_discoveries)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if fsu_collection_id and not isinstance(fsu_collection_id, str):
            raise TypeError("Expected argument 'fsu_collection_id' to be a str")
        pulumi.set(__self__, "fsu_collection_id", fsu_collection_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_completed_fsu_cycle_id and not isinstance(last_completed_fsu_cycle_id, str):
            raise TypeError("Expected argument 'last_completed_fsu_cycle_id' to be a str")
        pulumi.set(__self__, "last_completed_fsu_cycle_id", last_completed_fsu_cycle_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if source_major_version and not isinstance(source_major_version, str):
            raise TypeError("Expected argument 'source_major_version' to be a str")
        pulumi.set(__self__, "source_major_version", source_major_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_count and not isinstance(target_count, int):
            raise TypeError("Expected argument 'target_count' to be a int")
        pulumi.set(__self__, "target_count", target_count)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activeFsuCycles")
    def active_fsu_cycles(self) -> Sequence['outputs.GetFsuCollectionActiveFsuCycleResult']:
        """
        Active Exadata Fleet Update Cycle resource for this Collection. Object would be null if there is no active Cycle.
        """
        return pulumi.get(self, "active_fsu_cycles")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Exadata Fleet Update Collection resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fleetDiscoveries")
    def fleet_discoveries(self) -> Sequence['outputs.GetFsuCollectionFleetDiscoveryResult']:
        """
        Supported fleet discovery strategies for DB Collections. If specified on an Update Collection request, this will re-discover the targets of the Collection.
        """
        return pulumi.get(self, "fleet_discoveries")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fsuCollectionId")
    def fsu_collection_id(self) -> builtins.str:
        return pulumi.get(self, "fsu_collection_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID identifier for the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastCompletedFsuCycleId")
    def last_completed_fsu_cycle_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of last completed FSU Cycle.
        """
        return pulumi.get(self, "last_completed_fsu_cycle_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> builtins.str:
        """
        Exadata service type for the target resource members.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="sourceMajorVersion")
    def source_major_version(self) -> builtins.str:
        """
        Database Major Version of targets to be included in the Exadata Fleet Update Collection. https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/DbVersionSummary/ListDbVersions Only Database targets that match the version specified in this value would be added to the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "source_major_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the Exadata Fleet Update Collection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCount")
    def target_count(self) -> builtins.int:
        """
        Number of targets that are members of this Collection.
        """
        return pulumi.get(self, "target_count")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the Exadata Fleet Update Collection was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Exadata Fleet Update Collection was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Exadata Fleet Update Collection type.
        """
        return pulumi.get(self, "type")


class AwaitableGetFsuCollectionResult(GetFsuCollectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFsuCollectionResult(
            active_fsu_cycles=self.active_fsu_cycles,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            fleet_discoveries=self.fleet_discoveries,
            freeform_tags=self.freeform_tags,
            fsu_collection_id=self.fsu_collection_id,
            id=self.id,
            last_completed_fsu_cycle_id=self.last_completed_fsu_cycle_id,
            lifecycle_details=self.lifecycle_details,
            service_type=self.service_type,
            source_major_version=self.source_major_version,
            state=self.state,
            system_tags=self.system_tags,
            target_count=self.target_count,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_fsu_collection(fsu_collection_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFsuCollectionResult:
    """
    This data source provides details about a specific Fsu Collection resource in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a Exadata Fleet Update Collection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_collection = oci.FleetSoftwareUpdate.get_fsu_collection(fsu_collection_id=test_fsu_collection_oci_fleet_software_update_fsu_collection["id"])
    ```


    :param builtins.str fsu_collection_id: Unique Exadata Fleet Update Collection identifier.
    """
    __args__ = dict()
    __args__['fsuCollectionId'] = fsu_collection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetSoftwareUpdate/getFsuCollection:getFsuCollection', __args__, opts=opts, typ=GetFsuCollectionResult).value

    return AwaitableGetFsuCollectionResult(
        active_fsu_cycles=pulumi.get(__ret__, 'active_fsu_cycles'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fleet_discoveries=pulumi.get(__ret__, 'fleet_discoveries'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        fsu_collection_id=pulumi.get(__ret__, 'fsu_collection_id'),
        id=pulumi.get(__ret__, 'id'),
        last_completed_fsu_cycle_id=pulumi.get(__ret__, 'last_completed_fsu_cycle_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        service_type=pulumi.get(__ret__, 'service_type'),
        source_major_version=pulumi.get(__ret__, 'source_major_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_count=pulumi.get(__ret__, 'target_count'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_fsu_collection_output(fsu_collection_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFsuCollectionResult]:
    """
    This data source provides details about a specific Fsu Collection resource in Oracle Cloud Infrastructure Fleet Software Update service.

    Gets a Exadata Fleet Update Collection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fsu_collection = oci.FleetSoftwareUpdate.get_fsu_collection(fsu_collection_id=test_fsu_collection_oci_fleet_software_update_fsu_collection["id"])
    ```


    :param builtins.str fsu_collection_id: Unique Exadata Fleet Update Collection identifier.
    """
    __args__ = dict()
    __args__['fsuCollectionId'] = fsu_collection_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetSoftwareUpdate/getFsuCollection:getFsuCollection', __args__, opts=opts, typ=GetFsuCollectionResult)
    return __ret__.apply(lambda __response__: GetFsuCollectionResult(
        active_fsu_cycles=pulumi.get(__response__, 'active_fsu_cycles'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        fleet_discoveries=pulumi.get(__response__, 'fleet_discoveries'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        fsu_collection_id=pulumi.get(__response__, 'fsu_collection_id'),
        id=pulumi.get(__response__, 'id'),
        last_completed_fsu_cycle_id=pulumi.get(__response__, 'last_completed_fsu_cycle_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        service_type=pulumi.get(__response__, 'service_type'),
        source_major_version=pulumi.get(__response__, 'source_major_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_count=pulumi.get(__response__, 'target_count'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
