# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAgentDataIngestionJobsResult',
    'AwaitableGetAgentDataIngestionJobsResult',
    'get_agent_data_ingestion_jobs',
    'get_agent_data_ingestion_jobs_output',
]

@pulumi.output_type
class GetAgentDataIngestionJobsResult:
    """
    A collection of values returned by getAgentDataIngestionJobs.
    """
    def __init__(__self__, compartment_id=None, data_ingestion_job_collections=None, data_source_id=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_ingestion_job_collections and not isinstance(data_ingestion_job_collections, list):
            raise TypeError("Expected argument 'data_ingestion_job_collections' to be a list")
        pulumi.set(__self__, "data_ingestion_job_collections", data_ingestion_job_collections)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataIngestionJobCollections")
    def data_ingestion_job_collections(self) -> Sequence['outputs.GetAgentDataIngestionJobsDataIngestionJobCollectionResult']:
        """
        The list of data_ingestion_job_collection.
        """
        return pulumi.get(self, "data_ingestion_job_collections")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent DataSource.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAgentDataIngestionJobsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the data ingestion job.
        """
        return pulumi.get(self, "state")


class AwaitableGetAgentDataIngestionJobsResult(GetAgentDataIngestionJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentDataIngestionJobsResult(
            compartment_id=self.compartment_id,
            data_ingestion_job_collections=self.data_ingestion_job_collections,
            data_source_id=self.data_source_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_agent_data_ingestion_jobs(compartment_id: Optional[builtins.str] = None,
                                  data_source_id: Optional[builtins.str] = None,
                                  display_name: Optional[builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetAgentDataIngestionJobsFilterArgs', 'GetAgentDataIngestionJobsFilterArgsDict']]] = None,
                                  state: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentDataIngestionJobsResult:
    """
    This data source provides the list of Data Ingestion Jobs in Oracle Cloud Infrastructure Generative Ai Agent service.

    **ListDataIngestionJobs**

    Gets a list of data ingestion jobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_ingestion_jobs = oci.GenerativeAi.get_agent_data_ingestion_jobs(compartment_id=compartment_id,
        data_source_id=test_data_source["id"],
        display_name=data_ingestion_job_display_name,
        state=data_ingestion_job_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str data_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the data source.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dataSourceId'] = data_source_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getAgentDataIngestionJobs:getAgentDataIngestionJobs', __args__, opts=opts, typ=GetAgentDataIngestionJobsResult).value

    return AwaitableGetAgentDataIngestionJobsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_ingestion_job_collections=pulumi.get(__ret__, 'data_ingestion_job_collections'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_agent_data_ingestion_jobs_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         data_source_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAgentDataIngestionJobsFilterArgs', 'GetAgentDataIngestionJobsFilterArgsDict']]]]] = None,
                                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentDataIngestionJobsResult]:
    """
    This data source provides the list of Data Ingestion Jobs in Oracle Cloud Infrastructure Generative Ai Agent service.

    **ListDataIngestionJobs**

    Gets a list of data ingestion jobs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_ingestion_jobs = oci.GenerativeAi.get_agent_data_ingestion_jobs(compartment_id=compartment_id,
        data_source_id=test_data_source["id"],
        display_name=data_ingestion_job_display_name,
        state=data_ingestion_job_state)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param builtins.str data_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the data source.
    :param builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dataSourceId'] = data_source_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenerativeAi/getAgentDataIngestionJobs:getAgentDataIngestionJobs', __args__, opts=opts, typ=GetAgentDataIngestionJobsResult)
    return __ret__.apply(lambda __response__: GetAgentDataIngestionJobsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_ingestion_job_collections=pulumi.get(__response__, 'data_ingestion_job_collections'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
