# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetArtifactByPathResult',
    'AwaitableGetArtifactByPathResult',
    'get_artifact_by_path',
    'get_artifact_by_path_output',
]

@pulumi.output_type
class GetArtifactByPathResult:
    """
    A collection of values returned by getArtifactByPath.
    """
    def __init__(__self__, artifact_id=None, artifact_path=None, compartment_id=None, content=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, repository_id=None, sha256=None, size_in_bytes=None, source=None, state=None, time_created=None, version=None):
        if artifact_id and not isinstance(artifact_id, str):
            raise TypeError("Expected argument 'artifact_id' to be a str")
        pulumi.set(__self__, "artifact_id", artifact_id)
        if artifact_path and not isinstance(artifact_path, str):
            raise TypeError("Expected argument 'artifact_path' to be a str")
        pulumi.set(__self__, "artifact_path", artifact_path)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if sha256 and not isinstance(sha256, str):
            raise TypeError("Expected argument 'sha256' to be a str")
        pulumi.set(__self__, "sha256", sha256)
        if size_in_bytes and not isinstance(size_in_bytes, str):
            raise TypeError("Expected argument 'size_in_bytes' to be a str")
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> builtins.str:
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="artifactPath")
    def artifact_path(self) -> builtins.str:
        return pulumi.get(self, "artifact_path")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> builtins.str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha256(self) -> builtins.str:
        return pulumi.get(self, "sha256")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> builtins.str:
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetArtifactByPathResult(GetArtifactByPathResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetArtifactByPathResult(
            artifact_id=self.artifact_id,
            artifact_path=self.artifact_path,
            compartment_id=self.compartment_id,
            content=self.content,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            repository_id=self.repository_id,
            sha256=self.sha256,
            size_in_bytes=self.size_in_bytes,
            source=self.source,
            state=self.state,
            time_created=self.time_created,
            version=self.version)


def get_artifact_by_path(artifact_path: Optional[builtins.str] = None,
                         repository_id: Optional[builtins.str] = None,
                         version: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetArtifactByPathResult:
    """
    This data source provides details about a specific Artifact By Path resource in Oracle Cloud Infrastructure Generic Artifacts Content service.

    Get generic artifact content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_artifact_by_path = oci.GenericArtifactsContent.get_artifact_by_path(artifact_path=artifact_by_path_artifact_path,
        repository_id=test_repository["id"],
        version=artifact_by_path_version)
    ```


    :param builtins.str artifact_path: The generic artifact path.  Example: `foo/bar/baz`
    :param builtins.str repository_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the repository.  Example: `ocid1.repository.oc1..exampleuniqueID`
    :param builtins.str version: The generic artifact version.  Example: `1.1.2`
    """
    __args__ = dict()
    __args__['artifactPath'] = artifact_path
    __args__['repositoryId'] = repository_id
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenericArtifactsContent/getArtifactByPath:getArtifactByPath', __args__, opts=opts, typ=GetArtifactByPathResult).value

    return AwaitableGetArtifactByPathResult(
        artifact_id=pulumi.get(__ret__, 'artifact_id'),
        artifact_path=pulumi.get(__ret__, 'artifact_path'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        content=pulumi.get(__ret__, 'content'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        sha256=pulumi.get(__ret__, 'sha256'),
        size_in_bytes=pulumi.get(__ret__, 'size_in_bytes'),
        source=pulumi.get(__ret__, 'source'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        version=pulumi.get(__ret__, 'version'))
def get_artifact_by_path_output(artifact_path: Optional[pulumi.Input[builtins.str]] = None,
                                repository_id: Optional[pulumi.Input[builtins.str]] = None,
                                version: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetArtifactByPathResult]:
    """
    This data source provides details about a specific Artifact By Path resource in Oracle Cloud Infrastructure Generic Artifacts Content service.

    Get generic artifact content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_artifact_by_path = oci.GenericArtifactsContent.get_artifact_by_path(artifact_path=artifact_by_path_artifact_path,
        repository_id=test_repository["id"],
        version=artifact_by_path_version)
    ```


    :param builtins.str artifact_path: The generic artifact path.  Example: `foo/bar/baz`
    :param builtins.str repository_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the repository.  Example: `ocid1.repository.oc1..exampleuniqueID`
    :param builtins.str version: The generic artifact version.  Example: `1.1.2`
    """
    __args__ = dict()
    __args__['artifactPath'] = artifact_path
    __args__['repositoryId'] = repository_id
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GenericArtifactsContent/getArtifactByPath:getArtifactByPath', __args__, opts=opts, typ=GetArtifactByPathResult)
    return __ret__.apply(lambda __response__: GetArtifactByPathResult(
        artifact_id=pulumi.get(__response__, 'artifact_id'),
        artifact_path=pulumi.get(__response__, 'artifact_path'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        content=pulumi.get(__response__, 'content'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        sha256=pulumi.get(__response__, 'sha256'),
        size_in_bytes=pulumi.get(__response__, 'size_in_bytes'),
        source=pulumi.get(__response__, 'source'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        version=pulumi.get(__response__, 'version')))
