# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ShardedDatabaseCatalogDetail',
    'ShardedDatabaseCatalogDetailEncryptionKeyDetails',
    'ShardedDatabaseConnectionString',
    'ShardedDatabaseGsm',
    'ShardedDatabasePatchOperation',
    'ShardedDatabaseShardDetail',
    'ShardedDatabaseShardDetailEncryptionKeyDetails',
    'GetPrivateEndpointsFilterResult',
    'GetPrivateEndpointsPrivateEndpointCollectionResult',
    'GetPrivateEndpointsPrivateEndpointCollectionItemResult',
    'GetShardedDatabaseCatalogDetailResult',
    'GetShardedDatabaseCatalogDetailEncryptionKeyDetailResult',
    'GetShardedDatabaseConnectionStringResult',
    'GetShardedDatabaseGsmResult',
    'GetShardedDatabasePatchOperationResult',
    'GetShardedDatabaseShardDetailResult',
    'GetShardedDatabaseShardDetailEncryptionKeyDetailResult',
    'GetShardedDatabasesFilterResult',
    'GetShardedDatabasesShardedDatabaseCollectionResult',
    'GetShardedDatabasesShardedDatabaseCollectionItemResult',
]

@pulumi.output_type
class ShardedDatabaseCatalogDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "cloudAutonomousVmClusterId":
            suggest = "cloud_autonomous_vm_cluster_id"
        elif key == "computeCount":
            suggest = "compute_count"
        elif key == "dataStorageSizeInGbs":
            suggest = "data_storage_size_in_gbs"
        elif key == "isAutoScalingEnabled":
            suggest = "is_auto_scaling_enabled"
        elif key == "containerDatabaseId":
            suggest = "container_database_id"
        elif key == "containerDatabaseParentId":
            suggest = "container_database_parent_id"
        elif key == "encryptionKeyDetails":
            suggest = "encryption_key_details"
        elif key == "peerCloudAutonomousVmClusterId":
            suggest = "peer_cloud_autonomous_vm_cluster_id"
        elif key == "shardGroup":
            suggest = "shard_group"
        elif key == "supportingResourceId":
            suggest = "supporting_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeSslCertificateExpires":
            suggest = "time_ssl_certificate_expires"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseCatalogDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseCatalogDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseCatalogDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: builtins.str,
                 cloud_autonomous_vm_cluster_id: builtins.str,
                 compute_count: builtins.float,
                 data_storage_size_in_gbs: builtins.float,
                 is_auto_scaling_enabled: builtins.bool,
                 container_database_id: Optional[builtins.str] = None,
                 container_database_parent_id: Optional[builtins.str] = None,
                 encryption_key_details: Optional['outputs.ShardedDatabaseCatalogDetailEncryptionKeyDetails'] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 name: Optional[builtins.str] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[builtins.str] = None,
                 shard_group: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 supporting_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_ssl_certificate_expires: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None):
        """
        :param builtins.str admin_password: Admin password for the catalog database.
        :param builtins.str cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param builtins.float compute_count: The compute count for the catalog database. It has to be in multiple of 2.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs for the catalog database.
        :param builtins.bool is_auto_scaling_enabled: Determines the auto-scaling mode for the catalog database.
        :param builtins.str container_database_id: Identifier of the underlying container database.
        :param builtins.str container_database_parent_id: Identifier of the underlying container database parent.
        :param 'ShardedDatabaseCatalogDetailEncryptionKeyDetailsArgs' encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param Mapping[str, builtins.str] metadata: Additional metadata related to shard's underlying supporting resource.
        :param builtins.str name: Name of the shard.
        :param builtins.str peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param builtins.str shard_group: Name of the shard-group to which the shard belongs.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if container_database_parent_id is not None:
            pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        if encryption_key_details is not None:
            pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if shard_group is not None:
            pulumi.set(__self__, "shard_group", shard_group)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> builtins.str:
        """
        Admin password for the catalog database.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> builtins.float:
        """
        The compute count for the catalog database. It has to be in multiple of 2.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> builtins.float:
        """
        The data disk group size to be allocated in GBs for the catalog database.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> builtins.bool:
        """
        Determines the auto-scaling mode for the catalog database.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Optional['outputs.ShardedDatabaseCatalogDetailEncryptionKeyDetails']:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> Optional[builtins.str]:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[builtins.str]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class ShardedDatabaseCatalogDetailEncryptionKeyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "vaultId":
            suggest = "vault_id"
        elif key == "kmsKeyVersionId":
            suggest = "kms_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseCatalogDetailEncryptionKeyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseCatalogDetailEncryptionKeyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseCatalogDetailEncryptionKeyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: builtins.str,
                 vault_id: builtins.str,
                 kms_key_version_id: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param builtins.str vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        :param builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")


@pulumi.output_type
class ShardedDatabaseConnectionString(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allConnectionStrings":
            suggest = "all_connection_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseConnectionString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseConnectionString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseConnectionString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_connection_strings: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] all_connection_strings: Collection of connection strings.
        """
        if all_connection_strings is not None:
            pulumi.set(__self__, "all_connection_strings", all_connection_strings)

    @property
    @pulumi.getter(name="allConnectionStrings")
    def all_connection_strings(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Collection of connection strings.
        """
        return pulumi.get(self, "all_connection_strings")


@pulumi.output_type
class ShardedDatabaseGsm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeCount":
            suggest = "compute_count"
        elif key == "dataStorageSizeInGbs":
            suggest = "data_storage_size_in_gbs"
        elif key == "supportingResourceId":
            suggest = "supporting_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeSslCertificateExpires":
            suggest = "time_ssl_certificate_expires"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseGsm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseGsm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseGsm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_count: Optional[builtins.float] = None,
                 data_storage_size_in_gbs: Optional[builtins.float] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 name: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 supporting_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_ssl_certificate_expires: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None):
        """
        :param builtins.float compute_count: The compute amount available to the underlying autonomous database associated with shard.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs.
        :param Mapping[str, builtins.str] metadata: Additional metadata related to shard's underlying supporting resource.
        :param builtins.str name: Name of the shard.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if data_storage_size_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[builtins.float]:
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> Optional[builtins.float]:
        """
        The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[builtins.str]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class ShardedDatabasePatchOperation(dict):
    def __init__(__self__, *,
                 operation: builtins.str,
                 selection: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str operation: (Updatable) The operation can be one of these values: `INSERT`, `MERGE`, `REMOVE`
        :param builtins.str selection: (Updatable)
        :param builtins.str value: (Updatable)
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        """
        (Updatable) The operation can be one of these values: `INSERT`, `MERGE`, `REMOVE`
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        """
        (Updatable)
        """
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        (Updatable)
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ShardedDatabaseShardDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "cloudAutonomousVmClusterId":
            suggest = "cloud_autonomous_vm_cluster_id"
        elif key == "computeCount":
            suggest = "compute_count"
        elif key == "dataStorageSizeInGbs":
            suggest = "data_storage_size_in_gbs"
        elif key == "isAutoScalingEnabled":
            suggest = "is_auto_scaling_enabled"
        elif key == "containerDatabaseId":
            suggest = "container_database_id"
        elif key == "containerDatabaseParentId":
            suggest = "container_database_parent_id"
        elif key == "encryptionKeyDetails":
            suggest = "encryption_key_details"
        elif key == "peerCloudAutonomousVmClusterId":
            suggest = "peer_cloud_autonomous_vm_cluster_id"
        elif key == "shardGroup":
            suggest = "shard_group"
        elif key == "shardSpace":
            suggest = "shard_space"
        elif key == "supportingResourceId":
            suggest = "supporting_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeSslCertificateExpires":
            suggest = "time_ssl_certificate_expires"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseShardDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseShardDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseShardDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: builtins.str,
                 cloud_autonomous_vm_cluster_id: builtins.str,
                 compute_count: builtins.float,
                 data_storage_size_in_gbs: builtins.float,
                 is_auto_scaling_enabled: builtins.bool,
                 container_database_id: Optional[builtins.str] = None,
                 container_database_parent_id: Optional[builtins.str] = None,
                 encryption_key_details: Optional['outputs.ShardedDatabaseShardDetailEncryptionKeyDetails'] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 name: Optional[builtins.str] = None,
                 peer_cloud_autonomous_vm_cluster_id: Optional[builtins.str] = None,
                 shard_group: Optional[builtins.str] = None,
                 shard_space: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 supporting_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None,
                 time_ssl_certificate_expires: Optional[builtins.str] = None,
                 time_updated: Optional[builtins.str] = None):
        """
        :param builtins.str admin_password: Admin password for shard database.
        :param builtins.str cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        :param builtins.float compute_count: The compute count for the shard database. It has to be in multiples of 2.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs for the shard database.
        :param builtins.bool is_auto_scaling_enabled: Determines the auto-scaling mode for the shard database.
        :param builtins.str container_database_id: Identifier of the underlying container database.
        :param builtins.str container_database_parent_id: Identifier of the underlying container database parent.
        :param 'ShardedDatabaseShardDetailEncryptionKeyDetailsArgs' encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param Mapping[str, builtins.str] metadata: Additional metadata related to shard's underlying supporting resource.
        :param builtins.str name: Name of the shard.
        :param builtins.str peer_cloud_autonomous_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        :param builtins.str shard_group: Name of the shard-group to which the shard belongs.
        :param builtins.str shard_space: The shard space name for the shard database. Shard space for existing shard cannot be changed, once shard is created. Shard space name shall be used while creation of new shards. For User defined sharding, every shard must have a unique shard space name. For system defined sharding, shard space name is not required.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if container_database_parent_id is not None:
            pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        if encryption_key_details is not None:
            pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_cloud_autonomous_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        if shard_group is not None:
            pulumi.set(__self__, "shard_group", shard_group)
        if shard_space is not None:
            pulumi.set(__self__, "shard_space", shard_space)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supporting_resource_id is not None:
            pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> builtins.str:
        """
        Admin password for shard database.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> builtins.float:
        """
        The compute count for the shard database. It has to be in multiples of 2.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> builtins.float:
        """
        The data disk group size to be allocated in GBs for the shard database.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> builtins.bool:
        """
        Determines the auto-scaling mode for the shard database.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Optional['outputs.ShardedDatabaseShardDetailEncryptionKeyDetails']:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional metadata related to shard's underlying supporting resource.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer cloud Autonomous Exadata VM Cluster.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> Optional[builtins.str]:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @property
    @pulumi.getter(name="shardSpace")
    def shard_space(self) -> Optional[builtins.str]:
        """
        The shard space name for the shard database. Shard space for existing shard cannot be changed, once shard is created. Shard space name shall be used while creation of new shards. For User defined sharding, every shard must have a unique shard space name. For system defined sharding, shard space name is not required.
        """
        return pulumi.get(self, "shard_space")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> Optional[builtins.str]:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> Optional[builtins.str]:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[builtins.str]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class ShardedDatabaseShardDetailEncryptionKeyDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "vaultId":
            suggest = "vault_id"
        elif key == "kmsKeyVersionId":
            suggest = "kms_key_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardedDatabaseShardDetailEncryptionKeyDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardedDatabaseShardDetailEncryptionKeyDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardedDatabaseShardDetailEncryptionKeyDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: builtins.str,
                 vault_id: builtins.str,
                 kms_key_version_id: Optional[builtins.str] = None):
        """
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param builtins.str vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        :param builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")


@pulumi.output_type
class GetPrivateEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetPrivateEndpointsPrivateEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetPrivateEndpointsPrivateEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_state_details: builtins.str,
                 nsg_ids: Sequence[builtins.str],
                 private_ip: builtins.str,
                 proxy_compute_instance_id: builtins.str,
                 reinstate_proxy_instance_trigger: builtins.int,
                 sharded_databases: Sequence[builtins.str],
                 state: builtins.str,
                 subnet_id: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 vcn_id: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: PrivateEndpoint description.
        :param builtins.str display_name: A filter to return only private endpoint that match the entire name given. The match is not case sensitive.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: The identifier of the Private Endpoint.
        :param builtins.str lifecycle_state_details: Detailed message for the lifecycle state.
        :param Sequence[builtins.str] nsg_ids: The OCIDs of the network security groups that the private endpoint belongs to.
        :param builtins.str private_ip: IP address of the Private Endpoint.
        :param builtins.str proxy_compute_instance_id: The identifier of the proxy compute instance.
        :param Sequence[builtins.str] sharded_databases: The OCIDs of sharded databases that consumes the given private endpoint.
        :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param builtins.str subnet_id: Identifier of the subnet in which private endpoint exists.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the PrivateEndpoint was first created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Private Endpoint was last updated. An RFC3339 formatted datetime string
        :param builtins.str vcn_id: Identifier of the VCN in which subnet exists.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "proxy_compute_instance_id", proxy_compute_instance_id)
        pulumi.set(__self__, "reinstate_proxy_instance_trigger", reinstate_proxy_instance_trigger)
        pulumi.set(__self__, "sharded_databases", sharded_databases)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        PrivateEndpoint description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only private endpoint that match the entire name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier of the Private Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the network security groups that the private endpoint belongs to.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        """
        IP address of the Private Endpoint.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="proxyComputeInstanceId")
    def proxy_compute_instance_id(self) -> builtins.str:
        """
        The identifier of the proxy compute instance.
        """
        return pulumi.get(self, "proxy_compute_instance_id")

    @property
    @pulumi.getter(name="reinstateProxyInstanceTrigger")
    def reinstate_proxy_instance_trigger(self) -> builtins.int:
        return pulumi.get(self, "reinstate_proxy_instance_trigger")

    @property
    @pulumi.getter(name="shardedDatabases")
    def sharded_databases(self) -> Sequence[builtins.str]:
        """
        The OCIDs of sharded databases that consumes the given private endpoint.
        """
        return pulumi.get(self, "sharded_databases")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        Identifier of the subnet in which private endpoint exists.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the PrivateEndpoint was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Private Endpoint was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        Identifier of the VCN in which subnet exists.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetShardedDatabaseCatalogDetailResult(dict):
    def __init__(__self__, *,
                 admin_password: builtins.str,
                 cloud_autonomous_vm_cluster_id: builtins.str,
                 compute_count: builtins.float,
                 container_database_id: builtins.str,
                 container_database_parent_id: builtins.str,
                 data_storage_size_in_gbs: builtins.float,
                 encryption_key_details: Sequence['outputs.GetShardedDatabaseCatalogDetailEncryptionKeyDetailResult'],
                 is_auto_scaling_enabled: builtins.bool,
                 metadata: Mapping[str, builtins.str],
                 name: builtins.str,
                 peer_cloud_autonomous_vm_cluster_id: builtins.str,
                 shard_group: builtins.str,
                 status: builtins.str,
                 supporting_resource_id: builtins.str,
                 time_created: builtins.str,
                 time_ssl_certificate_expires: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str cloud_autonomous_vm_cluster_id: Identifier of the primary cloudAutonomousVmCluster for the shard.
        :param builtins.float compute_count: The compute amount available to the underlying autonomous database associated with shard.
        :param builtins.str container_database_id: Identifier of the underlying container database.
        :param builtins.str container_database_parent_id: Identifier of the underlying container database parent.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs.
        :param Sequence['GetShardedDatabaseCatalogDetailEncryptionKeyDetailArgs'] encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param builtins.bool is_auto_scaling_enabled: Determines the auto-scaling mode.
        :param Mapping[str, builtins.str] metadata: Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        :param builtins.str name: Name of the shard.
        :param builtins.str peer_cloud_autonomous_vm_cluster_id: Identifier of the peer cloudAutonomousVmCluster for the shard.
        :param builtins.str shard_group: Name of the shard-group to which the shard belongs.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "container_database_id", container_database_id)
        pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "shard_group", shard_group)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> builtins.str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        Identifier of the primary cloudAutonomousVmCluster for the shard.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> builtins.float:
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> builtins.str:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> builtins.str:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> builtins.float:
        """
        The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Sequence['outputs.GetShardedDatabaseCatalogDetailEncryptionKeyDetailResult']:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> builtins.bool:
        """
        Determines the auto-scaling mode.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        Identifier of the peer cloudAutonomousVmCluster for the shard.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> builtins.str:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> builtins.str:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> builtins.str:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetShardedDatabaseCatalogDetailEncryptionKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: builtins.str,
                 kms_key_version_id: builtins.str,
                 vault_id: builtins.str):
        """
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        :param builtins.str vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetShardedDatabaseConnectionStringResult(dict):
    def __init__(__self__, *,
                 all_connection_strings: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] all_connection_strings: Collection of connection strings.
        """
        pulumi.set(__self__, "all_connection_strings", all_connection_strings)

    @property
    @pulumi.getter(name="allConnectionStrings")
    def all_connection_strings(self) -> Mapping[str, builtins.str]:
        """
        Collection of connection strings.
        """
        return pulumi.get(self, "all_connection_strings")


@pulumi.output_type
class GetShardedDatabaseGsmResult(dict):
    def __init__(__self__, *,
                 compute_count: builtins.float,
                 data_storage_size_in_gbs: builtins.float,
                 metadata: Mapping[str, builtins.str],
                 name: builtins.str,
                 status: builtins.str,
                 supporting_resource_id: builtins.str,
                 time_created: builtins.str,
                 time_ssl_certificate_expires: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.float compute_count: The compute amount available to the underlying autonomous database associated with shard.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs.
        :param Mapping[str, builtins.str] metadata: Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        :param builtins.str name: Name of the shard.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> builtins.float:
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> builtins.float:
        """
        The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> builtins.str:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> builtins.str:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetShardedDatabasePatchOperationResult(dict):
    def __init__(__self__, *,
                 operation: builtins.str,
                 selection: builtins.str,
                 value: builtins.str):
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def selection(self) -> builtins.str:
        return pulumi.get(self, "selection")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetShardedDatabaseShardDetailResult(dict):
    def __init__(__self__, *,
                 admin_password: builtins.str,
                 cloud_autonomous_vm_cluster_id: builtins.str,
                 compute_count: builtins.float,
                 container_database_id: builtins.str,
                 container_database_parent_id: builtins.str,
                 data_storage_size_in_gbs: builtins.float,
                 encryption_key_details: Sequence['outputs.GetShardedDatabaseShardDetailEncryptionKeyDetailResult'],
                 is_auto_scaling_enabled: builtins.bool,
                 metadata: Mapping[str, builtins.str],
                 name: builtins.str,
                 peer_cloud_autonomous_vm_cluster_id: builtins.str,
                 shard_group: builtins.str,
                 shard_space: builtins.str,
                 status: builtins.str,
                 supporting_resource_id: builtins.str,
                 time_created: builtins.str,
                 time_ssl_certificate_expires: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str cloud_autonomous_vm_cluster_id: Identifier of the primary cloudAutonomousVmCluster for the shard.
        :param builtins.float compute_count: The compute amount available to the underlying autonomous database associated with shard.
        :param builtins.str container_database_id: Identifier of the underlying container database.
        :param builtins.str container_database_parent_id: Identifier of the underlying container database parent.
        :param builtins.float data_storage_size_in_gbs: The data disk group size to be allocated in GBs.
        :param Sequence['GetShardedDatabaseShardDetailEncryptionKeyDetailArgs'] encryption_key_details: Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        :param builtins.bool is_auto_scaling_enabled: Determines the auto-scaling mode.
        :param Mapping[str, builtins.str] metadata: Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        :param builtins.str name: Name of the shard.
        :param builtins.str peer_cloud_autonomous_vm_cluster_id: Identifier of the peer cloudAutonomousVmCluster for the shard.
        :param builtins.str shard_group: Name of the shard-group to which the shard belongs.
        :param builtins.str shard_space: Shard space name.
        :param builtins.str status: Status of shard or catalog or gsm for the sharded database.
        :param builtins.str supporting_resource_id: Identifier of the underlying supporting resource.
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_ssl_certificate_expires: The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "cloud_autonomous_vm_cluster_id", cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "container_database_id", container_database_id)
        pulumi.set(__self__, "container_database_parent_id", container_database_parent_id)
        pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        pulumi.set(__self__, "encryption_key_details", encryption_key_details)
        pulumi.set(__self__, "is_auto_scaling_enabled", is_auto_scaling_enabled)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peer_cloud_autonomous_vm_cluster_id", peer_cloud_autonomous_vm_cluster_id)
        pulumi.set(__self__, "shard_group", shard_group)
        pulumi.set(__self__, "shard_space", shard_space)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supporting_resource_id", supporting_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ssl_certificate_expires", time_ssl_certificate_expires)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> builtins.str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="cloudAutonomousVmClusterId")
    def cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        Identifier of the primary cloudAutonomousVmCluster for the shard.
        """
        return pulumi.get(self, "cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> builtins.float:
        """
        The compute amount available to the underlying autonomous database associated with shard.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> builtins.str:
        """
        Identifier of the underlying container database.
        """
        return pulumi.get(self, "container_database_id")

    @property
    @pulumi.getter(name="containerDatabaseParentId")
    def container_database_parent_id(self) -> builtins.str:
        """
        Identifier of the underlying container database parent.
        """
        return pulumi.get(self, "container_database_parent_id")

    @property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> builtins.float:
        """
        The data disk group size to be allocated in GBs.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @property
    @pulumi.getter(name="encryptionKeyDetails")
    def encryption_key_details(self) -> Sequence['outputs.GetShardedDatabaseShardDetailEncryptionKeyDetailResult']:
        """
        Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails are not specified for catalog, then Oracle managed key will be used for catalog. For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
        """
        return pulumi.get(self, "encryption_key_details")

    @property
    @pulumi.getter(name="isAutoScalingEnabled")
    def is_auto_scaling_enabled(self) -> builtins.bool:
        """
        Determines the auto-scaling mode.
        """
        return pulumi.get(self, "is_auto_scaling_enabled")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        Comma separated names of argument corresponding to which metadata need to be retrived, namely VM_CLUSTER_INFO, ADDITIONAL_RESOURCE_INFO. An example is metadata=VM_CLUSTER_INFO,ADDITIONAL_RESOURCE_INFO.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerCloudAutonomousVmClusterId")
    def peer_cloud_autonomous_vm_cluster_id(self) -> builtins.str:
        """
        Identifier of the peer cloudAutonomousVmCluster for the shard.
        """
        return pulumi.get(self, "peer_cloud_autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="shardGroup")
    def shard_group(self) -> builtins.str:
        """
        Name of the shard-group to which the shard belongs.
        """
        return pulumi.get(self, "shard_group")

    @property
    @pulumi.getter(name="shardSpace")
    def shard_space(self) -> builtins.str:
        """
        Shard space name.
        """
        return pulumi.get(self, "shard_space")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of shard or catalog or gsm for the sharded database.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportingResourceId")
    def supporting_resource_id(self) -> builtins.str:
        """
        Identifier of the underlying supporting resource.
        """
        return pulumi.get(self, "supporting_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSslCertificateExpires")
    def time_ssl_certificate_expires(self) -> builtins.str:
        """
        The time the ssl certificate associated with shard expires. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_ssl_certificate_expires")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetShardedDatabaseShardDetailEncryptionKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: builtins.str,
                 kms_key_version_id: builtins.str,
                 vault_id: builtins.str):
        """
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        :param builtins.str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        :param builtins.str vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key in vault identified by vaultId in customer tenancy  that is used as the master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key version for key identified by kmsKeyId that is used in data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the vault in customer tenancy where KMS key is present. For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only, which is also replicated in the region of standby shard.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetShardedDatabasesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the shard.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the shard.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetShardedDatabasesShardedDatabaseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetShardedDatabasesShardedDatabaseCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetShardedDatabasesShardedDatabaseCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetShardedDatabasesShardedDatabaseCollectionItemResult(dict):
    def __init__(__self__, *,
                 character_set: builtins.str,
                 chunks: builtins.int,
                 cluster_certificate_common_name: builtins.str,
                 compartment_id: builtins.str,
                 db_deployment_type: builtins.str,
                 db_version: builtins.str,
                 db_workload: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_state: builtins.str,
                 lifecycle_state_details: builtins.str,
                 listener_port: builtins.int,
                 listener_port_tls: builtins.int,
                 ncharacter_set: builtins.str,
                 ons_port_local: builtins.int,
                 ons_port_remote: builtins.int,
                 prefix: builtins.str,
                 replication_factor: builtins.int,
                 replication_method: builtins.str,
                 replication_unit: builtins.int,
                 sharding_method: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 total_cpu_count: builtins.float,
                 total_data_storage_size_in_gbs: builtins.float):
        """
        :param builtins.str character_set: The character set for the database.
        :param builtins.int chunks: The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        :param builtins.str cluster_certificate_common_name: The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param builtins.str db_deployment_type: The database deployment type.
        :param builtins.str db_version: Oracle Database version number.
        :param builtins.str db_workload: Possible workload types.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str display_name: A filter to return only sharded databases that match the entire name given. The match is not case sensitive.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Sharded Database identifier
        :param builtins.str lifecycle_state_details: Detailed message for the lifecycle state.
        :param builtins.int listener_port: The GSM listener port number.
        :param builtins.int listener_port_tls: The TLS listener port number for sharded database.
        :param builtins.str ncharacter_set: The national character set for the database.
        :param builtins.int ons_port_local: Ons local port number.
        :param builtins.int ons_port_remote: Ons remote port number.
        :param builtins.str prefix: Unique prefix for the sharded database.
        :param builtins.int replication_factor: The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        :param builtins.str replication_method: The Replication method for sharded database. Use RAFT for Raft replication, and DG for DataGuard. If replicationMethod is not provided, it defaults to DG.
        :param builtins.int replication_unit: For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        :param builtins.str sharding_method: Sharding Method.
        :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param builtins.str time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "chunks", chunks)
        pulumi.set(__self__, "cluster_certificate_common_name", cluster_certificate_common_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_deployment_type", db_deployment_type)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "db_workload", db_workload)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_port_tls", listener_port_tls)
        pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        pulumi.set(__self__, "ons_port_local", ons_port_local)
        pulumi.set(__self__, "ons_port_remote", ons_port_remote)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "replication_factor", replication_factor)
        pulumi.set(__self__, "replication_method", replication_method)
        pulumi.set(__self__, "replication_unit", replication_unit)
        pulumi.set(__self__, "sharding_method", sharding_method)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_cpu_count", total_cpu_count)
        pulumi.set(__self__, "total_data_storage_size_in_gbs", total_data_storage_size_in_gbs)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> builtins.str:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter
    def chunks(self) -> builtins.int:
        """
        The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        """
        return pulumi.get(self, "chunks")

    @property
    @pulumi.getter(name="clusterCertificateCommonName")
    def cluster_certificate_common_name(self) -> builtins.str:
        """
        The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        """
        return pulumi.get(self, "cluster_certificate_common_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbDeploymentType")
    def db_deployment_type(self) -> builtins.str:
        """
        The database deployment type.
        """
        return pulumi.get(self, "db_deployment_type")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> builtins.str:
        """
        Oracle Database version number.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> builtins.str:
        """
        Possible workload types.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only sharded databases that match the entire name given. The match is not case sensitive.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Sharded Database identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> builtins.str:
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> builtins.int:
        """
        The GSM listener port number.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerPortTls")
    def listener_port_tls(self) -> builtins.int:
        """
        The TLS listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port_tls")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> builtins.str:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="onsPortLocal")
    def ons_port_local(self) -> builtins.int:
        """
        Ons local port number.
        """
        return pulumi.get(self, "ons_port_local")

    @property
    @pulumi.getter(name="onsPortRemote")
    def ons_port_remote(self) -> builtins.int:
        """
        Ons remote port number.
        """
        return pulumi.get(self, "ons_port_remote")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        Unique prefix for the sharded database.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> builtins.int:
        """
        The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="replicationMethod")
    def replication_method(self) -> builtins.str:
        """
        The Replication method for sharded database. Use RAFT for Raft replication, and DG for DataGuard. If replicationMethod is not provided, it defaults to DG.
        """
        return pulumi.get(self, "replication_method")

    @property
    @pulumi.getter(name="replicationUnit")
    def replication_unit(self) -> builtins.int:
        """
        For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        """
        return pulumi.get(self, "replication_unit")

    @property
    @pulumi.getter(name="shardingMethod")
    def sharding_method(self) -> builtins.str:
        """
        Sharding Method.
        """
        return pulumi.get(self, "sharding_method")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalCpuCount")
    def total_cpu_count(self) -> builtins.float:
        return pulumi.get(self, "total_cpu_count")

    @property
    @pulumi.getter(name="totalDataStorageSizeInGbs")
    def total_data_storage_size_in_gbs(self) -> builtins.float:
        return pulumi.get(self, "total_data_storage_size_in_gbs")


